/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.controller;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.clipboard.ClipboardException;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.service.Clipboard;
import org.silverpeas.core.clipboard.service.MainClipboard;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.pdc.service.PdcSettings;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.selection.Selection;
import org.silverpeas.core.web.session.SessionCloseable;
import org.silverpeas.core.web.subscription.SubscriptionContext;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class MainSessionController
implements Clipboard,
SessionCloseable,
Serializable {
    public static final String MAIN_SESSION_CONTROLLER_ATT = "SilverSessionController";
    private final transient Clipboard clipboard = (Clipboard)ServiceProvider.getService(Clipboard.class, (Annotation[])new Annotation[]{new AnnotationLiteral<MainClipboard>(){}});
    private final UserPreferences userPreferences;
    private transient PdcManager pdcManager = null;
    private transient HttpSession httpSession = null;
    private String sessionId = null;
    private String userId = null;
    private transient OrganizationController organizationController = null;
    private String userLanguage = null;
    private ZoneId userZoneId = null;
    private transient Selection selection = null;
    private String userSpace = null;
    private transient SubscriptionContext subscriptionContext = null;
    private static boolean appInMaintenance = false;
    private static final List<String> spacesInMaintenance = new ArrayList<String>();
    private boolean allowPasswordChange;

    public static MainSessionController getInstance(HttpSession session) {
        return (MainSessionController)session.getAttribute(MAIN_SESSION_CONTROLLER_ATT);
    }

    public static boolean isAppInMaintenance() {
        return appInMaintenance;
    }

    public static void setAppModeMaintenance(boolean mode) {
        appInMaintenance = mode;
    }

    public boolean isSpaceInMaintenance(String spaceId) {
        String checkedSpaceId = this.checkSpaceId(spaceId);
        return spacesInMaintenance.contains(checkedSpaceId);
    }

    public void setSpaceModeMaintenance(String spaceId, boolean mode) {
        String checkedSpaceId = this.checkSpaceId(spaceId);
        if (mode) {
            if (!spacesInMaintenance.contains(checkedSpaceId)) {
                spacesInMaintenance.add(checkedSpaceId);
            }
        } else {
            spacesInMaintenance.remove(checkedSpaceId);
        }
    }

    private String checkSpaceId(String spaceId) {
        if (spaceId != null && spaceId.startsWith("WA")) {
            return spaceId.substring("WA".length());
        }
        return spaceId;
    }

    protected MainSessionController() {
        this.userPreferences = null;
    }

    public MainSessionController(String authenticationKey, HttpSession httpSession) throws SilverpeasException {
        try {
            this.httpSession = httpSession;
            this.sessionId = httpSession.getId();
            httpSession.setAttribute(MAIN_SESSION_CONTROLLER_ATT, (Object)this);
            this.userId = AdministrationServiceProvider.getAdminService().identify(authenticationKey, this.sessionId, MainSessionController.isAppInMaintenance());
            this.userPreferences = PersonalizationServiceProvider.getPersonalizationService().getUserSettings(this.userId);
            this.userLanguage = this.userPreferences.getLanguage();
        }
        catch (Exception e) {
            throw new SilverpeasException(SilverpeasExceptionMessages.failureOnGetting((String)"user with authentication key", (Object)authenticationKey), new String[0]);
        }
    }

    public MainSessionController(SessionInfo sessionInfo, HttpSession httpSession) throws SilverpeasException {
        try {
            this.httpSession = httpSession;
            this.sessionId = httpSession.getId();
            httpSession.setAttribute(MAIN_SESSION_CONTROLLER_ATT, (Object)this);
            this.userId = sessionInfo.getUserDetail().getId();
            this.userPreferences = PersonalizationServiceProvider.getPersonalizationService().getUserSettings(this.userId);
            this.userLanguage = this.userPreferences.getLanguage();
        }
        catch (Exception e) {
            throw new SilverpeasException("can not initialize main controller from session id {0}", new String[]{sessionInfo.getSessionId()});
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Selection getSelection() {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        return this.selection;
    }

    public SubscriptionContext getSubscriptionContext() {
        if (this.subscriptionContext == null) {
            this.subscriptionContext = new SubscriptionContext(this.getCurrentUserDetail(), this.userPreferences);
        }
        return this.subscriptionContext;
    }

    private Clipboard getClipboard() {
        return this.clipboard;
    }

    public UserPreferences getPersonalization() {
        return this.userPreferences;
    }

    public String getFavoriteLanguage() {
        if (this.userLanguage == null) {
            this.userLanguage = this.userPreferences.getLanguage();
        }
        return this.userLanguage;
    }

    public ZoneId getFavoriteZoneId() {
        if (this.userZoneId == null) {
            this.userZoneId = this.userPreferences.getZoneId();
        }
        return this.userZoneId;
    }

    public synchronized String getFavoriteSpace() {
        if (this.userSpace == null) {
            this.userSpace = this.userPreferences.getPersonalWorkSpaceId();
            boolean allowed = false;
            if (StringUtil.isDefined((String)this.userSpace)) {
                allowed = this.getOrganisationController().isSpaceAvailable(this.userSpace, this.getUserId());
            }
            if (!allowed) {
                this.getPersonalization().setPersonalWorkSpaceId("");
            }
        }
        return this.userSpace;
    }

    public String getFavoriteLook() {
        return this.userPreferences.getLook();
    }

    public boolean isWebDAVEditingEnabled() {
        return this.userPreferences.isWebdavEditionEnabled();
    }

    public boolean isDragNDropEnabled() {
        return this.userPreferences.isDragAndDropEnabled();
    }

    private OrganizationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganizationControllerProvider.getOrganisationController();
        }
        return this.organizationController;
    }

    public UserAccessLevel getUserAccessLevel() {
        return this.getCurrentUserDetail().getAccessLevel();
    }

    public UserDetail getCurrentUserDetail() {
        try {
            return AdministrationServiceProvider.getAdminService().getUserDetail(this.getUserId());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnGetting((String)"user", (Object)this.getUserId()), (Throwable)e);
            return null;
        }
    }

    public String getComponentParameterValue(String sComponentId, String parameterName) {
        return AdministrationServiceProvider.getAdminService().getComponentParameterValue(sComponentId, parameterName);
    }

    public String[] getUserAvailComponentIds() {
        try {
            return AdministrationServiceProvider.getAdminService().getAvailCompoIds(this.getUserId());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public String[] getUserManageableSpaceIds() {
        try {
            UserDetail user = AdministrationServiceProvider.getAdminService().getUserDetail(this.userId);
            if (user.isAccessAdmin() || "0".equals(this.userId)) {
                return AdministrationServiceProvider.getAdminService().getClientSpaceIds(AdministrationServiceProvider.getAdminService().getAllSpaceIds());
            }
            return AdministrationServiceProvider.getAdminService().getClientSpaceIds(AdministrationServiceProvider.getAdminService().getUserManageableSpaceIds(this.userId));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public boolean isBackOfficeVisible() {
        return this.getCurrentUserDetail().isBackOfficeVisible() || this.getUserManageableSpaceIds().length > 0 || !this.getUserManageableGroupIds().isEmpty() || this.isPDCBackOfficeVisible();
    }

    public boolean isPDCBackOfficeVisible() {
        if (PdcSettings.isDelegationNotEnabled()) {
            return false;
        }
        try {
            return this.getPdcManager().isUserManager(this.userId);
        }
        catch (PdcException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private PdcManager getPdcManager() {
        if (this.pdcManager == null) {
            this.pdcManager = PdcManager.get();
        }
        return this.pdcManager;
    }

    public List<String> getUserManageableGroupIds() {
        try {
            return AdministrationServiceProvider.getAdminService().getUserManageableGroupIds(this.userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public ComponentContext createComponentContext(String spaceId, String componentInstanceId) {
        ComponentContext componentContext = new ComponentContext();
        try {
            if (spaceId != null) {
                SpaceInstLight spaceInst = AdministrationServiceProvider.getAdminService().getSpaceInstLightById(spaceId);
                componentContext.setCurrentSpaceId(spaceId);
                componentContext.setCurrentSpaceName(spaceInst.getName(this.getFavoriteLanguage()));
            }
            if (componentInstanceId != null) {
                SilverpeasComponentInstance componentInst = AdministrationServiceProvider.getAdminService().getComponentInstance(componentInstanceId);
                componentContext.setCurrentComponentId(componentInstanceId);
                componentContext.setCurrentComponentName(componentInst.getName());
                if (componentInst.isPersonal()) {
                    Collection silverpeasRolesFor = componentInst.getSilverpeasRolesFor((User)this.getCurrentUserDetail());
                    componentContext.setCurrentProfile((String[])silverpeasRolesFor.stream().map(SilverpeasRole::getName).toArray(String[]::new));
                } else {
                    componentContext.setCurrentProfile(AdministrationServiceProvider.getAdminService().getCurrentProfiles(this.getUserId(), componentInst.getId()));
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("can not create component context with spaceId={0} and componentId={1}", (Object[])new String[]{spaceId, componentInstanceId}, (Throwable)e);
        }
        return componentContext;
    }

    public void setAllowPasswordChange(boolean flag) {
        this.allowPasswordChange = flag;
    }

    public boolean isAllowPasswordChange() {
        return this.allowPasswordChange;
    }

    public void add(ClipboardSelection clipObject) throws ClipboardException {
        this.getClipboard().add(clipObject);
    }

    public ClipboardSelection getObject() {
        return this.getClipboard().getObject();
    }

    public void pasteDone() throws ClipboardException {
        this.getClipboard().pasteDone();
    }

    public Collection<ClipboardSelection> getSelectedObjects() throws ClipboardException {
        return this.getClipboard().getSelectedObjects();
    }

    public Collection<ClipboardSelection> getObjects() throws ClipboardException {
        return this.getClipboard().getObjects();
    }

    public int size() throws ClipboardException {
        return this.getClipboard().size();
    }

    public ClipboardSelection getObject(int index) throws ClipboardException {
        return this.getClipboard().getObject(index);
    }

    public void setSelected(int index, boolean setIt) throws ClipboardException {
        this.getClipboard().setSelected(index, setIt);
    }

    public void removeObject(int index) throws ClipboardException {
        this.getClipboard().removeObject(index);
    }

    @Override
    public void close() {
        this.clear();
    }

    public void clear() {
        this.getClipboard().clear();
    }

    public void setMultiClipboard() throws ClipboardException {
        this.getClipboard().setMultiClipboard();
    }

    public void setSingleClipboard() throws ClipboardException {
        this.getClipboard().setSingleClipboard();
    }

    public int getCount() throws ClipboardException {
        return this.getClipboard().getCount();
    }

    public String getMessageError() throws ClipboardException {
        return this.getClipboard().getMessageError();
    }

    public Exception getExceptionError() throws ClipboardException {
        return this.getClipboard().getExceptionError();
    }

    public void setMessageError(String messageID, Exception e) throws ClipboardException {
        this.getClipboard().setMessageError(messageID, e);
    }
}

