/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.web.authentication.SilverpeasSessionOpener;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasHttpServlet;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class LoginServlet
extends SilverpeasHttpServlet {
    private static final long serialVersionUID = 4492227920914085441L;
    private static final String LOGOUT_PARAM = "logout";
    @Inject
    private SilverpeasSessionOpener silverpeasSessionOpener;
    private static final SettingBundle general = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
    public static final String PARAM_DOMAINID = "DomainId";

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpRequest httpRequest = HttpRequest.decorate((HttpServletRequest)request);
        SilverpeasHttpServlet.UserSessionStatus userSessionStatus = this.existOpenedUserSession((HttpServletRequest)httpRequest);
        if (userSessionStatus.isValid() || this.isWelcomeWithinAnonymousSession(httpRequest)) {
            this.performOpenedUserOrAnonymousSession((HttpServletRequest)httpRequest, response, userSessionStatus);
        } else {
            this.performLoginDispatch((HttpServletRequest)httpRequest, response);
        }
    }

    private void performOpenedUserOrAnonymousSession(HttpServletRequest request, HttpServletResponse response, SilverpeasHttpServlet.UserSessionStatus userSessionStatus) throws ServletException, IOException {
        if (this.mustCloseSession(request)) {
            HttpSession session = request.getSession(false);
            this.silverpeasSessionOpener.closeSession(session);
            this.performLoginDispatch(request, response);
        } else {
            HttpRequest httpRequest = HttpRequest.decorate((HttpServletRequest)request);
            String destinationUrl = userSessionStatus.isFromDesktop() ? this.silverpeasSessionOpener.getHomePageUrl(httpRequest, null, false) : this.silverpeasSessionOpener.prepareFromExistingSessionInfo(httpRequest, userSessionStatus.getInfo());
            this.redirectOrForwardService((HttpServletRequest)httpRequest, response, destinationUrl);
        }
    }

    private boolean mustCloseSession(HttpServletRequest request) {
        return this.getSsoLoginPage(request).isPresent() && general.getBoolean("login.sso.path.newSession", false) || "Error_SsoNotAllowed".equals(this.getErrorCode(request));
    }

    private Optional<String> getSsoLoginPage(HttpServletRequest request) {
        String ssoPath = general.getString("login.sso.path", "");
        return StringUtil.isDefined((String)ssoPath) ? Optional.of(UriBuilder.fromPath((String)request.getContextPath()).path(ssoPath).build(new Object[0]).toString()) : Optional.empty();
    }

    private boolean isAnonymousAccessActivated() {
        return UserDetail.isAnonymousUserExist();
    }

    private boolean isWelcomeWithinAnonymousSession(HttpRequest request) {
        return request.getParameterAsBoolean("welcome") && request.isWithinAnonymousUserSession();
    }

    private boolean noUserOrAnonymousSession(HttpRequest httpRequest) {
        return !httpRequest.isWithinAnonymousUserSession() && !httpRequest.isWithinUserSession();
    }

    private void performLoginDispatch(HttpServletRequest servletRequest, HttpServletResponse response) throws IOException, ServletException {
        HttpRequest request = HttpRequest.decorate((HttpServletRequest)servletRequest);
        String errorCode = this.getErrorCode((HttpServletRequest)request);
        Optional<String> ssoLoginPage = this.getSsoLoginPage((HttpServletRequest)request);
        if (StringUtil.isNotDefined((String)errorCode) && this.isAnonymousAccessActivated() && this.noUserOrAnonymousSession(request)) {
            UserDetail anonymousUser = UserDetail.getAnonymousUser();
            UriBuilder uriBuilder = UriBuilder.fromPath((String)"/AuthenticationServlet");
            this.addParameter(uriBuilder, "Login", anonymousUser.getLogin());
            this.addParameter(uriBuilder, "Password", anonymousUser.getLogin());
            this.addParameter(uriBuilder, PARAM_DOMAINID, "0");
            RequestDispatcher dispatcher = request.getRequestDispatcher(uriBuilder.toTemplate());
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else if (ssoLoginPage.isPresent() && (StringUtil.isNotDefined((String)errorCode) || "3".equals(errorCode)) && !request.getParameterAsBoolean(LOGOUT_PARAM)) {
            String loginPage = ssoLoginPage.get();
            response.sendRedirect(response.encodeRedirectURL(loginPage));
        } else {
            Object loginPage = general.getString("loginPage");
            if (!StringUtil.isDefined((String)loginPage)) {
                loginPage = request.getContextPath() + "/defaultLogin.jsp";
            } else if (!((String)loginPage).startsWith(request.getContextPath())) {
                loginPage = request.getContextPath() + "/" + (String)loginPage;
            }
            UriBuilder uriBuilder = UriBuilder.fromPath((String)loginPage);
            this.addParameter(uriBuilder, PARAM_DOMAINID, this.getDomainId((HttpServletRequest)request));
            this.addParameter(uriBuilder, "ErrorCode", errorCode);
            this.addParameter(uriBuilder, LOGOUT_PARAM, request.getParameter(LOGOUT_PARAM));
            response.sendRedirect(response.encodeRedirectURL(uriBuilder.toTemplate()));
        }
    }

    private void addParameter(UriBuilder uriBuilder, String param, String value) {
        if (StringUtil.isDefined((String)value)) {
            uriBuilder.queryParam(param, new Object[]{value});
        }
    }

    private String getErrorCode(HttpServletRequest request) {
        return request.getParameter("ErrorCode");
    }

    private String getDomainId(HttpServletRequest request) {
        String domainId = general.getString("loginPage.domainId.default");
        if (StringUtil.isInteger((String)request.getParameter(PARAM_DOMAINID))) {
            domainId = request.getParameter(PARAM_DOMAINID);
        }
        return domainId;
    }
}

