/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreference;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletWindowPreferenceRegistry
implements PortletRegistryTags,
PortletRegistryObject {
    private String version;
    private Map<String, PortletRegistryElement> portletWindowPreferenceTable = new LinkedHashMap<String, PortletRegistryElement>();
    private List<PortletRegistryElement> portletWindowPreferenceList = new ArrayList<PortletRegistryElement>();

    @Override
    public void read(Document document) throws PortletRegistryException {
        Element root = PortletRegistryHelper.getRootElement(document);
        if (root != null) {
            this.populate(root);
        }
    }

    @Override
    public void addRegistryElement(PortletRegistryElement portletWindowPreference) {
        this.portletWindowPreferenceTable.put(this.getUniqueName(portletWindowPreference), portletWindowPreference);
        this.portletWindowPreferenceList.add(portletWindowPreference);
    }

    @Override
    public PortletRegistryElement getRegistryElement(String name) {
        return this.portletWindowPreferenceTable.get(name);
    }

    @Override
    public List<PortletRegistryElement> getRegistryElements() {
        return this.portletWindowPreferenceList;
    }

    @Override
    public boolean removeRegistryElement(PortletRegistryElement portletWindowPreference) {
        this.portletWindowPreferenceTable.remove(this.getUniqueName(portletWindowPreference));
        return this.portletWindowPreferenceList.remove(portletWindowPreference);
    }

    private void populate(Element root) {
        Map<String, String> portletWindowPreferencesAttributes = XMLDocumentHelper.createAttributeTable(root);
        this.setVersion(portletWindowPreferencesAttributes.get("version"));
        List<Element> portletWindowPrefTags = XMLDocumentHelper.createElementList(root);
        for (Element portletWindowPreferenceTag : portletWindowPrefTags) {
            PortletWindowPreference portletWindowPreference = new PortletWindowPreference();
            portletWindowPreference.populateValues(portletWindowPreferenceTag);
            this.addRegistryElement(portletWindowPreference);
        }
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void write(Document document) {
        Element rootTag = XMLDocumentHelper.createElement(document, "PortletWindowPreferenceRegistry");
        rootTag.setAttribute("version", this.getVersion());
        document.appendChild(rootTag);
        for (PortletRegistryElement portletWindowPreferenceElt : this.portletWindowPreferenceTable.values()) {
            PortletWindowPreference portletWindowPreference = (PortletWindowPreference)portletWindowPreferenceElt;
            portletWindowPreference.create(document, rootTag);
        }
    }

    private String getUniqueName(PortletRegistryElement portletWindowPreference) {
        return portletWindowPreference.getName() + portletWindowPreference.getUserName();
    }
}

