/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPortletRegistryElement
implements PortletRegistryTags,
PortletRegistryElement {
    private String name;
    private String userName;
    private String portletName;
    private String isRemote = Boolean.FALSE.toString();
    private String lang;
    private Map<String, Map<String, Object>> collectionMapTable = new HashMap<String, Map<String, Object>>();
    private Map<String, String> collectionStringTable = new HashMap<String, String>();

    @Override
    public void setCollectionProperty(String key, Map<String, Object> values) {
        this.setMap(key, values);
    }

    @Override
    public Map<String, Object> getCollectionProperty(String key) {
        return this.getMapValue(key);
    }

    @Override
    public void setCollectionProperty(String key, List<String> values) {
        this.setList(key, values);
    }

    @Override
    public void setStringProperty(String key, String value) {
        this.setString(key, value);
    }

    @Override
    public String getStringProperty(String key) {
        return this.getStringValue(key);
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.trim().length() == 0) {
            return this.getPortletName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPortletName() {
        return this.portletName;
    }

    @Override
    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String getUserName() {
        if (this.userName == null) {
            return "default";
        }
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getRemote() {
        return this.isRemote;
    }

    @Override
    public void setRemote(String isRemote) {
        this.isRemote = isRemote;
    }

    private void setList(String key, List<String> values) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (values != null) {
            for (String s : values) {
                m.put(s, s);
            }
        }
        this.setMap(key, m);
    }

    private void setMap(String key, Map<String, Object> values) {
        this.collectionMapTable.put(key, values);
    }

    private void setString(String key, String value) {
        this.collectionStringTable.put(key, value);
    }

    private Map<String, Object> getMapValue(String key) {
        return this.collectionMapTable.get(key);
    }

    private String getStringValue(String key) {
        return this.collectionStringTable.get(key);
    }

    protected Map<String, Map<String, Object>> getMapCollectionTable() {
        return this.collectionMapTable;
    }

    protected Map<String, String> getStringCollectionTable() {
        return this.collectionStringTable;
    }

    protected void populateValues(Element rootTag) {
        Element propertiesTag = XMLDocumentHelper.getChildElement(rootTag, "Properties");
        List<Element> tags = XMLDocumentHelper.createElementList(propertiesTag);
        for (Element tag : tags) {
            String tagName = tag.getTagName();
            Map<String, String> attributes = XMLDocumentHelper.createAttributeTable(tag);
            String name = attributes.get("name");
            if (tagName.equals("String")) {
                this.setStringProperty(name, attributes.get("value"));
                continue;
            }
            if (!tagName.equals("Collection")) continue;
            List<Element> innerTags = XMLDocumentHelper.createElementList(tag);
            HashMap<String, Object> mapValues = new HashMap<String, Object>();
            for (Element innerTag : innerTags) {
                String innerName;
                String innerTagName = innerTag.getTagName();
                if (innerTagName.equals("String")) {
                    Map<String, String> stringAttributes = XMLDocumentHelper.createAttributeTable(innerTag);
                    innerName = stringAttributes.get("name");
                    String innerValue = stringAttributes.get("value");
                    if (innerName == null) {
                        mapValues.put(innerValue, innerValue);
                        continue;
                    }
                    mapValues.put(innerName, innerValue);
                    continue;
                }
                if (!innerTagName.equals("Collection")) continue;
                Map<String, String> innerAttributes = XMLDocumentHelper.createAttributeTable(innerTag);
                innerName = innerAttributes.get("name");
                List<Element> stringTags = XMLDocumentHelper.createElementList(innerTag);
                ArrayList<String> listValues = new ArrayList<String>();
                for (Element stringTag : stringTags) {
                    Map<String, String> stringAttributes = XMLDocumentHelper.createAttributeTable(stringTag);
                    listValues.add(stringAttributes.get("value"));
                }
                mapValues.put(innerName, listValues);
            }
            this.setCollectionProperty(name, mapValues);
        }
    }

    protected void create(Document document, Element propertiesTag) {
        String value;
        String name;
        Map<String, String> stringTags = this.getStringCollectionTable();
        Set<Map.Entry<String, String>> mappings1 = stringTags.entrySet();
        for (Map.Entry<String, String> me : mappings1) {
            name = me.getKey();
            value = me.getValue();
            if (value == null || value.trim().length() == 0) continue;
            Element stringTag = XMLDocumentHelper.createElement(document, "String");
            stringTag.setAttribute("name", name);
            stringTag.setAttribute("value", value);
            propertiesTag.appendChild(stringTag);
        }
        Map<String, Map<String, Object>> collectionTags = this.getMapCollectionTable();
        Set<Map.Entry<String, Map<String, Object>>> mappings2 = collectionTags.entrySet();
        for (Map.Entry<String, Map<String, Object>> me : mappings2) {
            name = me.getKey();
            Map<String, Object> values = me.getValue();
            Set<Map.Entry<String, Object>> keys = values.entrySet();
            if (keys.isEmpty()) continue;
            Element collectionTag = XMLDocumentHelper.createElement(document, "Collection");
            collectionTag.setAttribute("name", name);
            propertiesTag.appendChild(collectionTag);
            for (Map.Entry<String, Object> entry : keys) {
                Element innerCollectionTag;
                String key = entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof String) {
                    value = (String)obj;
                    this.createStringTag(document, collectionTag, key, value);
                    continue;
                }
                if (obj instanceof List) {
                    List innerValuesList = (List)obj;
                    innerCollectionTag = XMLDocumentHelper.createElement(document, "Collection");
                    innerCollectionTag.setAttribute("name", key);
                    collectionTag.appendChild(innerCollectionTag);
                    int innerValuesListSize = innerValuesList.size();
                    for (int i = 0; i < innerValuesListSize; ++i) {
                        value = (String)innerValuesList.get(i);
                        this.createStringTag(document, innerCollectionTag, value, value);
                    }
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                Map innerValuesMap = (Map)obj;
                Set<String> innerKeys = values.keySet();
                innerCollectionTag = XMLDocumentHelper.createElement(document, "Collection");
                innerCollectionTag.setAttribute("name", key);
                collectionTag.appendChild(innerCollectionTag);
                for (String innerKey : innerKeys) {
                    value = (String)innerValuesMap.get(innerKey);
                    this.createStringTag(document, innerCollectionTag, innerKey, value);
                }
            }
        }
    }

    private void createStringTag(Document document, Element collectionTag, String key, String value) {
        Element stringTag = XMLDocumentHelper.createElement(document, "String");
        if (key.equals(value)) {
            stringTag.setAttribute("value", value);
        } else {
            stringTag.setAttribute("name", key);
            stringTag.setAttribute("value", value);
        }
        collectionTag.appendChild(stringTag);
    }
}

