/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Column;
import org.silverpeas.core.workflow.api.model.Columns;
import org.silverpeas.core.workflow.engine.model.ColumnImpl;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(name="columns")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ColumnsImpl
implements Columns {
    private static final long serialVersionUID = -179308759997989687L;
    @XmlElement(name="column", type=ColumnImpl.class)
    private List<Column> columnList = new ArrayList<Column>();
    @XmlAttribute(name="role")
    private String roleName = "default";

    @Override
    public List<Column> getColumnList() {
        return this.columnList;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public Column getColumn(String strItemName) {
        String search = StringUtil.defaultStringIfNotDefined((String)strItemName);
        return this.columnList.stream().filter(c -> search.equals(c.getItem().getName())).findFirst().orElse(null);
    }

    @Override
    public void addColumn(Column column) {
        this.columnList.add(column);
    }

    @Override
    public Column createColumn() {
        return new ColumnImpl();
    }

    @Override
    public Iterator<Column> iterateColumn() {
        return this.columnList.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnsImpl columns = (ColumnsImpl)o;
        return Objects.equals(this.roleName, columns.roleName);
    }

    public int hashCode() {
        return this.roleName != null ? this.roleName.hashCode() : 0;
    }
}

