/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.api.user;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.Entity;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.user.ReplacementList;
import org.silverpeas.core.workflow.api.user.User;

public interface Replacement<T extends Replacement<T>>
extends Entity<T, UuidIdentifier> {
    public static <T extends Replacement<T>> Optional<T> get(String replacementId) {
        Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
        return Optional.ofNullable(repository.findById(replacementId));
    }

    public static <T extends Replacement<T>> ReplacementList<T> getAllOf(User incumbent, String workflowInstanceId) {
        Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
        List replacements = repository.findAllByIncumbentAndByWorkflow(incumbent, workflowInstanceId);
        return new ReplacementList(replacements);
    }

    public static <T extends Replacement<T>> ReplacementList<T> getAllBy(User substitute, String workflowInstanceId) {
        Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
        List replacements = repository.findAllBySubstituteAndByWorkflow(substitute, workflowInstanceId);
        return new ReplacementList(replacements);
    }

    public static <T extends Replacement<T>> ReplacementList<T> getAllWith(User incumbent, User substitute, String workflowInstanceId) {
        Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
        List replacements = repository.findAllByUsersAndByWorkflow(incumbent, substitute, workflowInstanceId);
        return new ReplacementList(replacements);
    }

    public static <T extends Replacement<T>> ReplacementList<T> getAll(String workflowInstanceId) {
        Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
        List replacements = repository.findAllByWorkflow(workflowInstanceId);
        return new ReplacementList(replacements);
    }

    public static Constructor between(User incumbent, User substitute) {
        Constructor constructor = (Constructor)ServiceProvider.getService(Constructor.class, (Annotation[])new Annotation[0]);
        return constructor.between(incumbent, substitute);
    }

    public User getIncumbent();

    public User getSubstitute();

    public Replacement<T> setSubstitute(User var1);

    public Period getPeriod();

    public Replacement<T> setPeriod(Period var1);

    public String getWorkflowInstanceId();

    default public T save() {
        return (T)((Replacement)Transaction.performInOne(() -> {
            Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
            return repository.save(this);
        }));
    }

    default public void delete() {
        Transaction.performInOne(() -> {
            Repository repository = (Repository)ServiceProvider.getService(Repository.class, (Annotation[])new Annotation[0]);
            repository.delete(this);
            return null;
        });
    }

    default public boolean isSameAs(Replacement<?> replacement) {
        return Objects.equals(this.getIncumbent().getUserId(), replacement.getIncumbent().getUserId()) && Objects.equals(this.getSubstitute().getUserId(), replacement.getSubstitute().getUserId()) && Objects.equals(this.getPeriod(), replacement.getPeriod());
    }

    public static interface Repository {
        public <T extends Replacement<T>> T save(Replacement<T> var1);

        public <T extends Replacement<T>> void delete(Replacement<T> var1);

        public <T extends Replacement<T>> List<T> findAllByIncumbentAndByWorkflow(User var1, String var2);

        public <T extends Replacement<T>> List<T> findAllBySubstituteAndByWorkflow(User var1, String var2);

        public <T extends Replacement<T>> List<T> findAllByWorkflow(String var1);

        public <T extends Replacement<T>> List<T> findAllByUsersAndByWorkflow(User var1, User var2, String var3);

        public <T extends Replacement<T>> T findById(String var1);
    }

    public static interface Constructor {
        public Constructor between(User var1, User var2);

        public Constructor inWorkflow(String var1);

        public <T extends Replacement<T>> T during(Period var1);
    }
}

