/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.projectmanager.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.projectmanager.model.HolidayDetail;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class ProjectManagerCalendarDAO {
    private static final String PROJECTMANAGER_CALENDAR_TABLENAME = "SC_ProjectManager_Calendar";

    private ProjectManagerCalendarDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHolidayDate(Connection con, HolidayDetail holiday) throws SQLException, UtilException {
        if (!ProjectManagerCalendarDAO.isHolidayDate(con, holiday)) {
            StringBuilder insertStatement = new StringBuilder(128);
            insertStatement.append("INSERT INTO ").append(PROJECTMANAGER_CALENDAR_TABLENAME);
            insertStatement.append(" VALUES ( ? , ? , ? )");
            PreparedStatement prepStmt = null;
            try {
                prepStmt = con.prepareStatement(insertStatement.toString());
                prepStmt.setString(1, ProjectManagerCalendarDAO.date2DBDate(holiday.getDate()));
                prepStmt.setInt(2, holiday.getFatherId());
                prepStmt.setString(3, holiday.getInstanceId());
                prepStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder(128);
        deleteStatement.append("delete from ").append(PROJECTMANAGER_CALENDAR_TABLENAME);
        deleteStatement.append(" where holidayDate = ? ");
        deleteStatement.append(" and fatherId = ? ");
        deleteStatement.append(" and instanceId = ? ");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(deleteStatement.toString());
            prepStmt.setString(1, ProjectManagerCalendarDAO.date2DBDate(holiday.getDate()));
            prepStmt.setInt(2, holiday.getFatherId());
            prepStmt.setString(3, holiday.getInstanceId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static void removeAllHolidayDates(Connection con, String instanceId) throws SQLException {
        String sql = "delete from SC_ProjectManager_Calendar where instanceId = ?";
        try (PreparedStatement deletion = con.prepareStatement("delete from SC_ProjectManager_Calendar where instanceId = ?");){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        boolean bl;
        StringBuilder query = new StringBuilder(128);
        query.append("select * ");
        query.append("from ").append(PROJECTMANAGER_CALENDAR_TABLENAME);
        query.append(" where holidayDate = ? ");
        query.append(" and fatherId = ? ");
        query.append(" and instanceId = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, ProjectManagerCalendarDAO.date2DBDate(holiday.getDate()));
            stmt.setInt(2, holiday.getFatherId());
            stmt.setString(3, holiday.getInstanceId());
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Date> getHolidayDates(Connection con, String instanceId) throws SQLException {
        ArrayList<Date> holidayDates = new ArrayList<Date>();
        StringBuilder query = new StringBuilder(128);
        query.append("SELECT * ");
        query.append("FROM ").append(PROJECTMANAGER_CALENDAR_TABLENAME);
        query.append(" WHERE instanceId = ? ");
        query.append("ORDER BY holidayDate ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, instanceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(ProjectManagerCalendarDAO.dbDate2Date(rs.getString("holidayDate"), "holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Date> getHolidayDates(Connection con, String instanceId, Date beginDate, Date endDate) throws SQLException {
        ArrayList<Date> holidayDates = new ArrayList<Date>();
        StringBuilder query = new StringBuilder(128);
        query.append("SELECT * ");
        query.append("FROM ").append(PROJECTMANAGER_CALENDAR_TABLENAME);
        query.append(" WHERE instanceId = ? ");
        query.append(" AND ? <= holidayDate ");
        query.append(" AND holidayDate <= ? ");
        query.append("ORDER BY holidayDate ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, instanceId);
            stmt.setString(2, ProjectManagerCalendarDAO.date2DBDate(beginDate));
            stmt.setString(3, ProjectManagerCalendarDAO.date2DBDate(endDate));
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(ProjectManagerCalendarDAO.dbDate2Date(rs.getString("holidayDate"), "holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }

    public static String date2DBDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        return formatter.format(date);
    }

    private static Date dbDate2Date(String dbDate, String fieldName) throws SQLException {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            date = formatter.parse(dbDate);
        }
        catch (ParseException e) {
            throw new SQLException("ProjectManagerCalendarDAO : dbDate2Date(" + fieldName + ") : format unknown " + e.toString(), e);
        }
        return date;
    }
}

