/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;

class CorrelationHandler
implements HttpHandler {
    private static final HttpString HEADER = new HttpString("X-Correlation-ID");
    private final HttpHandler next;

    private CorrelationHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String corr = exchange.getRequestHeaders().getFirst(HEADER);
        if (corr != null) {
            exchange.getResponseHeaders().put(HEADER, corr);
        }
        this.next.handleRequest(exchange);
    }

    static HttpHandler wrap(HttpHandler next) {
        return new CorrelationHandler(next);
    }
}

