/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;

public interface Producer<K, V>
extends Closeable {
    public void initTransactions();

    public void beginTransaction() throws ProducerFencedException;

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2) throws ProducerFencedException;

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, ConsumerGroupMetadata var2) throws ProducerFencedException;

    public void commitTransaction() throws ProducerFencedException;

    public void abortTransaction() throws ProducerFencedException;

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1);

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1, Callback var2);

    public void flush();

    public List<PartitionInfo> partitionsFor(String var1);

    public Map<MetricName, ? extends Metric> metrics();

    @Override
    public void close();

    public void close(Duration var1);
}

