/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client._private.Log;

class ContextXATerminator
implements XATerminator {
    private final LocalTransactionContext transactionContext;

    ContextXATerminator(LocalTransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getImportedTransaction(xid).getControl().commit(onePhase);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.getImportedTransaction(xid).getControl().forget();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.getImportedTransaction(xid).getControl().prepare();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.getImportedTransaction(xid).getControl().rollback();
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.transactionContext.getRecoveryInterface().recover(flag);
    }

    private ImportResult<LocalTransaction> getImportedTransaction(Xid xid) throws XAException {
        ImportResult<LocalTransaction> result = this.transactionContext.findOrImportTransaction(xid, 0, true);
        if (result == null) {
            throw Log.log.noTransactionXa(-4);
        }
        LocalTransaction transaction = result.getTransaction();
        if (!transaction.isImported()) {
            throw Log.log.noTransactionXa(-4);
        }
        return result;
    }
}

