/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;

class AbstractDeploymentPlanBuilder {
    private final DeploymentSetPlanImpl setPlan;
    private final boolean rollbackAcrossGroups;

    AbstractDeploymentPlanBuilder() {
        this.setPlan = new DeploymentSetPlanImpl();
        this.rollbackAcrossGroups = false;
    }

    AbstractDeploymentPlanBuilder(AbstractDeploymentPlanBuilder existing, boolean rollbackAcrossGroups) {
        this.setPlan = existing.setPlan;
        this.rollbackAcrossGroups = rollbackAcrossGroups;
    }

    AbstractDeploymentPlanBuilder(AbstractDeploymentPlanBuilder existing, DeploymentSetPlanImpl setPlan) {
        this.setPlan = setPlan;
        this.rollbackAcrossGroups = existing.rollbackAcrossGroups;
    }

    public DeploymentAction getLastAction() {
        return this.getCurrentDeploymentSetPlan().getLastAction();
    }

    DeploymentSetPlanImpl getCurrentDeploymentSetPlan() {
        return this.setPlan;
    }

    public DeploymentPlan build() {
        return new DeploymentPlanImpl(this.setPlan, this.rollbackAcrossGroups);
    }
}

