/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.security.PublicKey;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.i18n.Messages;

public class Verification {
    protected PublicKey key;
    protected KeyRepository repository;
    protected String algorithm = DKIMSignature.DEFAULT_ALGORITHM;
    protected Map<String, String> requiredAttributes = new HashMap<String, String>();
    protected String identifierName;
    protected String identifierValue;
    protected boolean staleCheck;
    protected boolean ignoreExpiration;
    protected int staleSeconds;
    protected int staleMinutes;
    protected int staleHours;
    protected int staleDays;
    protected int staleMonths;
    protected int staleYears;
    protected boolean bodyHashRequired = true;

    public Verification() {
    }

    public Verification(PublicKey key) {
        this.key = key;
    }

    public Verification(KeyRepository repository) {
        this.repository = repository;
    }

    public boolean isBodyHashRequired() {
        return this.bodyHashRequired;
    }

    public void setBodyHashRequired(boolean bodyHashRequired) {
        this.bodyHashRequired = bodyHashRequired;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public void setIdentifierName(String identifierName) {
        this.identifierName = identifierName;
    }

    public String getIdentifierValue() {
        return this.identifierValue;
    }

    public void setIdentifierValue(String identifierValue) {
        this.identifierValue = identifierValue;
    }

    public boolean isIgnoreExpiration() {
        return this.ignoreExpiration;
    }

    public void setIgnoreExpiration(boolean ignoreExpiration) {
        this.ignoreExpiration = ignoreExpiration;
    }

    public boolean isStaleCheck() {
        return this.staleCheck;
    }

    public void setStaleCheck(boolean staleCheck) {
        this.staleCheck = staleCheck;
    }

    public Map<String, String> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public PublicKey getKey() {
        return this.key;
    }

    public void setKey(PublicKey key) {
        this.key = key;
    }

    public KeyRepository getRepository() {
        return this.repository;
    }

    public void setRepository(KeyRepository repository) {
        this.repository = repository;
    }

    public int getStaleSeconds() {
        return this.staleSeconds;
    }

    public void setStaleSeconds(int staleSeconds) {
        this.staleSeconds = staleSeconds;
    }

    public int getStaleMinutes() {
        return this.staleMinutes;
    }

    public void setStaleMinutes(int staleMinutes) {
        this.staleMinutes = staleMinutes;
    }

    public int getStaleHours() {
        return this.staleHours;
    }

    public void setStaleHours(int staleHours) {
        this.staleHours = staleHours;
    }

    public int getStaleDays() {
        return this.staleDays;
    }

    public void setStaleDays(int staleDays) {
        this.staleDays = staleDays;
    }

    public int getStaleMonths() {
        return this.staleMonths;
    }

    public void setStaleMonths(int staleMonths) {
        this.staleMonths = staleMonths;
    }

    public int getStaleYears() {
        return this.staleYears;
    }

    public void setStaleYears(int staleYears) {
        this.staleYears = staleYears;
    }

    public MultivaluedMap<String, String> verify(DKIMSignature signature, Map headers, byte[] body, PublicKey publicKey) throws SignatureException {
        if (publicKey == null) {
            publicKey = this.key;
        }
        if (publicKey == null) {
            throw new SignatureException(Messages.MESSAGES.publicKeyIsNull());
        }
        MultivaluedMap<String, String> verifiedHeaders = signature.verify(this.bodyHashRequired, headers, body, publicKey);
        if (!this.isIgnoreExpiration() && signature.isExpired()) {
            throw new SignatureException(Messages.MESSAGES.signatureExpired());
        }
        if (this.isStaleCheck() && signature.isStale(this.getStaleSeconds(), this.getStaleMinutes(), this.getStaleHours(), this.getStaleDays(), this.getStaleMonths(), this.getStaleYears())) {
            throw new SignatureException(Messages.MESSAGES.signatureIsStale());
        }
        for (Map.Entry<String, String> required : this.getRequiredAttributes().entrySet()) {
            String value = signature.getAttributes().get(required.getKey());
            if (value.equals(required.getValue())) continue;
            throw new SignatureException(Messages.MESSAGES.expectedValue(required.getValue(), value, required.getKey()));
        }
        return verifiedHeaders;
    }
}

