/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.publisher;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.InboundSseEvent;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.client.publisher.SpscLinkedArrayQueue;
import org.jboss.resteasy.microprofile.client.publisher.Subscriptions;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SSEPublisher<T>
implements Publisher<T> {
    private static final Runnable CLEARED = () -> {};
    private final SseEventInputImpl input;
    private final Type genericType;
    private final Providers providers;
    private final ExecutorService executor;
    private static final Logger LOGGER = Logger.getLogger(SSEPublisher.class);

    public SSEPublisher(Type genericType, Providers providers, SseEventInputImpl input, ExecutorService es) {
        this.genericType = genericType;
        this.input = input;
        this.providers = providers;
        this.executor = es;
    }

    public void subscribe(Subscriber<? super T> downstream) {
        SSEProcessor<? super T> processor = new SSEProcessor<T>(downstream, Integer.getInteger("resteasy.microprofile.sseclient.buffersize", 512));
        downstream.onSubscribe(processor);
        this.pump(processor, this.input);
    }

    private void pump(final SSEProcessor processor, final SseEventInputImpl input) {
        final Map contextDataMap = ResteasyContext.getContextDataMap();
        Runnable readEventTask = new Runnable(){

            @Override
            public void run() {
                ResteasyContext.pushContextDataMap((Map)contextDataMap);
                if (SSEPublisher.this.genericType instanceof ParameterizedType) {
                    Type typeArgument = ((ParameterizedType)SSEPublisher.this.genericType).getActualTypeArguments()[0];
                    if (typeArgument.equals(InboundSseEvent.class)) {
                        try {
                            InboundSseEvent event;
                            while ((event = input.read(SSEPublisher.this.providers)) != null) {
                                processor.emit(event);
                            }
                        }
                        catch (Exception e) {
                            processor.onError(e);
                            return;
                        }
                        processor.onCompletion();
                    } else {
                        try {
                            InboundSseEvent event;
                            while ((event = input.read(SSEPublisher.this.providers)) != null) {
                                processor.emit(event.readData((Class)typeArgument));
                            }
                        }
                        catch (Exception e) {
                            processor.onError(e);
                            return;
                        }
                    }
                    processor.onCompletion();
                }
            }
        };
        try {
            this.executor.execute(readEventTask);
        }
        catch (RejectedExecutionException e) {
            LOGGER.warnf("Executor %s rejected emit event task", (Object)this.executor);
            new Thread(readEventTask, "SseClientPublisherNewThread").start();
        }
    }

    private static class SSEProcessor<T>
    implements Subscription {
        private final AtomicLong requested = new AtomicLong();
        private final Subscriber<T> downstream;
        private final Queue<T> queue;
        private final int bufferSize;
        private Throwable failure;
        private volatile boolean done;
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicReference<Runnable> onTermination;

        SSEProcessor(Subscriber<T> downstream, int bufferSize) {
            this.downstream = downstream;
            this.bufferSize = bufferSize;
            this.queue = new SpscLinkedArrayQueue<T>(bufferSize);
            this.onTermination = new AtomicReference();
        }

        public void emit(T t) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t == null) {
                throw new NullPointerException("Reactive Streams Rule 2.13 violated: The received item is `null`");
            }
            if (this.queue.size() == this.bufferSize) {
                T item = this.queue.poll();
                LOGGER.debugf("Dropping server-sent-event '%s' due to lack of downstream requests", item);
            }
            this.queue.offer(t);
            this.drain();
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            } else {
                this.cancel();
                this.downstream.onError((Throwable)new IllegalArgumentException("Reactive Streams Rule 3.9 violated: request must be positive, but was " + n));
            }
        }

        public final void cancel() {
            this.cleanup();
        }

        public boolean isCancelled() {
            return this.onTermination.get() == CLEARED;
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                boolean d;
                long emitted;
                long requests = this.requested.get();
                for (emitted = 0L; emitted != requests; ++emitted) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    T event = q.poll();
                    boolean bl = empty = event == null;
                    if (d && empty) {
                        if (this.failure != null) {
                            this.sendErrorToDownstream(this.failure);
                        } else {
                            this.sendCompletionToDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    try {
                        this.downstream.onNext(event);
                        continue;
                    }
                    catch (Throwable x) {
                        this.cancel();
                    }
                }
                if (emitted == requests) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        if (this.failure != null) {
                            this.sendErrorToDownstream(this.failure);
                        } else {
                            this.sendCompletionToDownstream();
                        }
                        return;
                    }
                }
                if (emitted == 0L) continue;
                Subscriptions.produced(this.requested, emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        protected void onCompletion() {
            this.done = true;
            this.drain();
        }

        protected void onError(Throwable e) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (e == null) {
                throw new NullPointerException("Reactive Streams Rule 2.13 violated: The received error is `null`");
            }
            this.failure = e;
            this.done = true;
            this.drain();
        }

        private void cleanup() {
            Runnable action = this.onTermination.getAndSet(CLEARED);
            if (action != null && action != CLEARED) {
                action.run();
            }
        }

        private void sendCompletionToDownstream() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.downstream.onComplete();
            }
            finally {
                this.cleanup();
            }
        }

        private void sendErrorToDownstream(Throwable e) {
            if (e == null) {
                e = new NullPointerException("Reactive Streams Rule 2.13 violated: The received error is `null`");
            }
            if (this.isCancelled()) {
                return;
            }
            try {
                this.downstream.onError(e);
            }
            finally {
                this.cleanup();
            }
        }
    }
}

