/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.msc.service.ServiceName;

public final class ThreadsServices {
    public static final ServiceName THREAD = ServiceName.JBOSS.append(new String[]{"thread"});
    public static final ServiceName FACTORY = THREAD.append(new String[]{"factory"});
    public static final ServiceName EXECUTOR = THREAD.append(new String[]{"executor"});
    public static final HandoffExecutorResolver STANDARD_HANDOFF_EXECUTOR_RESOLVER = new HandoffExecutorResolver.SimpleResolver(EXECUTOR);
    public static final ThreadFactoryResolver STANDARD_THREAD_FACTORY_RESOLVER = new ThreadFactoryResolver.SimpleResolver(FACTORY);

    private ThreadsServices() {
    }

    public static ThreadFactoryResolver getThreadFactoryResolver(String type) {
        if (type != null && !type.isEmpty()) {
            return new ThreadFactoryResolver.SimpleResolver(ServiceNameFactory.parseServiceName((String)ThreadsServices.getCapabilityBaseName(type)));
        }
        return STANDARD_THREAD_FACTORY_RESOLVER;
    }

    public static HandoffExecutorResolver getHandoffExecutorResolver(String type) {
        if (type != null && !type.isEmpty()) {
            return new HandoffExecutorResolver.SimpleResolver(ServiceNameFactory.parseServiceName((String)ThreadsServices.getCapabilityBaseName(type)));
        }
        return STANDARD_HANDOFF_EXECUTOR_RESOLVER;
    }

    public static ServiceName threadFactoryName(String name) {
        return FACTORY.append(new String[]{name});
    }

    public static ServiceName executorName(String name) {
        return EXECUTOR.append(new String[]{name});
    }

    public static RuntimeCapability<Void> createCapability(String type, Class<?> serviceValueType) {
        return RuntimeCapability.Builder.of((String)ThreadsServices.getCapabilityBaseName(type), (boolean)true, serviceValueType).build();
    }

    public static String getCapabilityBaseName(String type) {
        assert (type != null && !type.isEmpty());
        return "org.wildfly.threads.executor." + type;
    }
}

