/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletXMLDocumentHelper {
    protected static Element getChildElement(Element element, String tagName) {
        NodeList childNodes = element.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            String childTagName;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName)) continue;
            return childElement;
        }
        return null;
    }

    protected static List<Element> getChildElements(Element element, String tagName) {
        List<Element> elements = PortletXMLDocumentHelper.getElementList(element);
        int numElements = elements.size();
        ArrayList<Element> childElements = new ArrayList<Element>(numElements);
        for (int i = 0; i < numElements; ++i) {
            String childTagName;
            Element childElement = elements.get(i);
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName)) continue;
            childElements.add(childElement);
        }
        return childElements;
    }

    public static List<String> getChildElementsText(Element parentElement, String tagName) {
        List<Element> childElements = PortletXMLDocumentHelper.getChildElements(parentElement, tagName);
        if (childElements != null && childElements.size() > 0) {
            ArrayList<String> textList = new ArrayList<String>(childElements.size());
            for (Element element : childElements) {
                textList.add(element.getTextContent().trim());
            }
            return textList;
        }
        return Collections.emptyList();
    }

    public static Set<String> getChildElementsTextSet(Element parentElement, String tagName) {
        List<Element> childElements = PortletXMLDocumentHelper.getChildElements(parentElement, tagName);
        if (childElements != null && childElements.size() > 0) {
            HashSet<String> textList = new HashSet<String>(childElements.size());
            for (Element element : childElements) {
                textList.add(element.getTextContent().trim());
            }
            return textList;
        }
        return Collections.EMPTY_SET;
    }

    protected static List<Element> getElementList(Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList childNodes = element.getChildNodes();
        int numChildren = childNodes.getLength();
        ArrayList<Element> elementList = new ArrayList<Element>(numChildren);
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            elementList.add((Element)childNode);
        }
        return elementList;
    }

    public static String getChildTextTrim(Element element, String tagName) {
        Element childElement = PortletXMLDocumentHelper.getChildElement(element, tagName);
        if (childElement != null) {
            return PortletXMLDocumentHelper.getTextTrim(childElement);
        }
        return null;
    }

    public static String getTextTrim(Element element) {
        Node node;
        if (element != null && (node = element.getChildNodes().item(0)) != null && node.getNodeType() == 3) {
            return node.getNodeValue().trim();
        }
        return "";
    }

    protected static Map<String, String> getAttributeTable(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        if (attrs == null) {
            return Collections.emptyMap();
        }
        int numAttrs = attrs.getLength();
        HashMap<String, String> attributeTable = new HashMap<String, String>(numAttrs);
        for (int i = 0; i < numAttrs; ++i) {
            Node na = attrs.item(i);
            if (na.getNodeType() != 2) continue;
            Attr a = (Attr)na;
            attributeTable.put(a.getName(), a.getValue());
        }
        return attributeTable;
    }

    protected static Element createElement(Document d, String tagName) {
        Element e = d.createElement(tagName);
        return e;
    }

    public static Map<String, String> getDescriptionMap(Element descriptionParentElement) {
        Map<String, String> descriptionMap = null;
        List<Element> descriptionElements = PortletXMLDocumentHelper.getChildElements(descriptionParentElement, "description");
        if (descriptionElements.size() > 0) {
            descriptionMap = new HashMap<String, String>(descriptionElements.size());
            for (Element description : descriptionElements) {
                String lang = "";
                if (description.hasAttribute("xml:lang")) {
                    lang = description.getAttribute("xml:lang");
                }
                descriptionMap.put(lang, PortletXMLDocumentHelper.getTextTrim(description));
            }
        } else {
            descriptionMap = Collections.emptyMap();
        }
        return descriptionMap;
    }

    public static Map<String, String> getDisplayNameMap(Element displayNameParentElement) {
        Map<String, String> displayNameMap = null;
        List<Element> displayNameElements = PortletXMLDocumentHelper.getChildElements(displayNameParentElement, "display-name");
        if (displayNameElements.size() > 0) {
            displayNameMap = new HashMap<String, String>(displayNameElements.size());
            for (Element displayName : displayNameElements) {
                String lang = "";
                if (displayName.hasAttribute("xml:lang")) {
                    lang = displayName.getAttribute("xml:lang");
                }
                displayNameMap.put(lang, PortletXMLDocumentHelper.getTextTrim(displayName));
            }
        } else {
            displayNameMap = Collections.emptyMap();
        }
        return displayNameMap;
    }

    public static String getDescription(Map<String, String> descriptionMap) {
        String description = null;
        if (descriptionMap != null && !descriptionMap.isEmpty()) {
            description = descriptionMap.size() == 1 ? (String)descriptionMap.values().toArray()[0] : (descriptionMap.containsKey("") ? descriptionMap.get("") : (descriptionMap.containsKey("en") ? descriptionMap.get("en") : (descriptionMap.containsKey("en".toUpperCase()) ? descriptionMap.get("en".toUpperCase()) : (String)descriptionMap.values().toArray()[0])));
        }
        return description;
    }

    public static String getId(Element element) {
        if (element.hasAttribute("id")) {
            return element.getAttribute("id");
        }
        return null;
    }

    public static QName generateQName(Element element, String defaultEventNameSpace) {
        QName qname = null;
        if (element != null) {
            String nsAttributeValue;
            int idx;
            String textContent = PortletXMLDocumentHelper.getTextTrim(element);
            String prefix = PortletXMLDocumentHelper.getPrefixFromTextContent(textContent);
            String textContentWithoutPrefix = textContent;
            if (prefix != null && (idx = textContent.indexOf(":")) != -1) {
                textContentWithoutPrefix = textContent.substring(idx + 1);
            }
            qname = (nsAttributeValue = element.lookupNamespaceURI(prefix)) != null && !nsAttributeValue.equals("http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd") ? (prefix != null ? new QName(nsAttributeValue, textContentWithoutPrefix, prefix) : new QName(nsAttributeValue, textContentWithoutPrefix)) : new QName(defaultEventNameSpace, textContentWithoutPrefix);
        }
        return qname;
    }

    private static String getPrefixFromTextContent(String textContent) {
        int idx;
        String prefix = null;
        if (textContent != null && (idx = textContent.indexOf(":")) != -1) {
            prefix = textContent.substring(0, idx);
        }
        return prefix;
    }

    public static List<QName> getSupportedEventChildElementsQName(Element parentElement, String defaultNameSpace, String tagName) {
        List<Element> childElements = PortletXMLDocumentHelper.getChildElements(parentElement, tagName);
        if (childElements != null && childElements.size() > 0) {
            ArrayList<QName> qnameList = new ArrayList<QName>(childElements.size());
            for (Element element : childElements) {
                String name;
                QName qname = PortletXMLDocumentHelper.generateQName(element, defaultNameSpace);
                if (qname == null && (name = PortletXMLDocumentHelper.getChildTextTrim(element, "name")) != null) {
                    qname = new QName(defaultNameSpace, name);
                }
                if (qname == null) continue;
                qnameList.add(qname);
            }
            return qnameList;
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<String, String[]> getRuntimeOptions(Element element) {
        NodeList list;
        Map<String, String[]> optionsMap = null;
        if (element != null && (list = element.getElementsByTagName("container-runtime-option")).getLength() > 0) {
            optionsMap = new HashMap<String, String[]>(list.getLength());
            Element option = null;
            String name = null;
            for (int i = 0; i < list.getLength(); ++i) {
                option = (Element)list.item(i);
                name = PortletXMLDocumentHelper.getChildTextTrim(option, "name");
                if (name == null) continue;
                List<Element> childElements = PortletXMLDocumentHelper.getChildElements(option, "value");
                String[] values = null;
                if (childElements != null) {
                    values = new String[childElements.size()];
                    int j = 0;
                    for (Element childElement : childElements) {
                        values[j++] = PortletXMLDocumentHelper.getTextTrim(childElement);
                    }
                }
                optionsMap.put(name, values);
            }
        }
        if (optionsMap == null) {
            optionsMap = Collections.emptyMap();
        }
        return optionsMap;
    }
}

