/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.pool;

import com.sun.portal.portletcontainer.appengine.util.pool.ObjectManager;
import com.sun.portal.portletcontainer.appengine.util.pool.Pool;

public class NullObjectPool
implements Pool {
    private ObjectManager objectManager;
    private boolean destroyed;
    private int leased;

    public NullObjectPool(ObjectManager objectManager) {
        this.objectManager = objectManager;
        this.destroyed = false;
    }

    public Object obtainObject(Object param) {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        ++this.leased;
        return this.objectManager.createObject(param);
    }

    public void releaseObject(Object o) {
        this.objectManager.destroyObject(o);
        --this.leased;
    }

    public int getLeased() {
        return this.leased;
    }

    public int getMinSize() {
        return 0;
    }

    public int getMaxSize() {
        return 0;
    }

    public void setMaxSize(int maxSize) {
    }

    public void destroy() {
        this.destroyed = true;
    }

    public final boolean doesReuseObjects() {
        return false;
    }
}

