/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.concurrent;

import java.util.ArrayList;
import java.util.List;

public class ConsumerProducer {
    private List queue;
    private int stopLimit = 0;
    private int resumeLimit = 0;
    private Threshold threshold = null;
    private boolean reachedLimit = false;

    public ConsumerProducer() {
        this(0, 0, null);
    }

    public ConsumerProducer(int stopLimit, int resumeLimit, Threshold threshold) {
        this.stopLimit = stopLimit;
        this.resumeLimit = resumeLimit;
        this.threshold = threshold;
        this.queue = new ArrayList(100);
    }

    public synchronized void put(Object o) {
        this.queue.add(o);
        int size = this.queue.size();
        if (size == 1) {
            this.notify();
        }
        if (this.threshold != null && this.stopLimit > 0 && size > this.stopLimit) {
            this.threshold.reachedStopLimit();
            this.reachedLimit = true;
        }
    }

    public synchronized Object get() {
        int size = this.queue.size();
        if (size == 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.reachedLimit && size < this.resumeLimit) {
            this.threshold.reachedResumeLimit();
            this.reachedLimit = false;
        }
        Object o = this.queue.get(0);
        this.queue.remove(0);
        return o;
    }

    public boolean isEmpty() {
        return this.queue.size() == 0;
    }

    public synchronized void empty() {
        this.queue.clear();
        this.reachedLimit = false;
    }

    public static interface Threshold {
        public void reachedStopLimit();

        public void reachedResumeLimit();
    }
}

