/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.util.LDAPXMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventMultiplexer
extends DefaultHandler {
    private LDAPXMLHandler defaulthandler;
    private LDAPXMLHandler currenthandler;
    private Stack Handlerstack = new Stack();
    private StringBuffer buffer = new StringBuffer();

    public void setLDAPXMLHandler(LDAPXMLHandler adefault) {
        this.defaulthandler = adefault;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void endDocument() throws SAXException {
        if (this.currenthandler != null) {
            throw new SAXException("Invalid System State,currenthandler not null in endDocument");
        }
        super.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!localName.equals(this.currenthandler.getName())) {
            throw new SAXException("Invalid System State");
        }
        this.currenthandler.value(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.currenthandler.endElement();
        this.currenthandler = (LDAPXMLHandler)this.Handlerstack.pop();
        super.endElement(uri, localName, qName);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.defaulthandler == null) {
            throw new IllegalArgumentException("Illegal Argument , Default Handler not set");
        }
        this.currenthandler = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.Handlerstack.push(this.currenthandler);
        this.currenthandler = this.currenthandler == null ? this.defaulthandler : this.currenthandler.nextHandler(localName);
        if (!localName.equals(this.currenthandler.getName())) {
            throw new SAXException("Unknown tag:" + localName);
        }
        this.currenthandler.startElement();
        this.currenthandler.handleAttributes(attributes);
    }

    public Object parseXML(InputStream inputStream) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            InputSource is = new InputSource(new InputStreamReader(inputStream));
            saxParser.parse(is, (DefaultHandler)this);
        }
        catch (FactoryConfigurationError e) {
            throw new IOException("The SAX parser factory is configured incorrectly:" + e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("The SAX parser is configured incorrectly:" + e);
        }
        catch (SAXNotRecognizedException e) {
            throw new IOException("The XML cannot be parsed is configured incorrectly:" + e);
        }
        catch (SAXException e) {
            throw new IOException("The XML cannot be parsed is configured incorrectly:" + e);
        }
        return this.defaulthandler.getObject();
    }
}

