/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.pdc.pdc.model.PdcRuntimeException;
import org.silverpeas.core.pdc.pdc.model.constraints.UniquePositions;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="pdcclassification")
@NamedQueries(value={@NamedQuery(name="findByComponentInstanceId", query="select p from PdcClassification p where p.instanceId=:instanceId and p.contentId is null and p.nodeId is null"), @NamedQuery(name="findByNodeId", query="select p from PdcClassification p where p.instanceId=:instanceId and p.contentId is null and p.nodeId=:nodeId"), @NamedQuery(name="findByPdcAxisValues", query="select distinct c from PdcClassification c join c.positions p join p.axisValues v where v in :values")})
public class PdcClassification
extends BasicJpaEntity<PdcClassification, UniqueLongIdentifier> {
    public static final PdcClassification NONE_CLASSIFICATION = new PdcClassification();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @NotNull
    @Size(min=1)
    @UniquePositions
    @Valid
    private final @NotNull @Size(min=1) @Valid Set<PdcPosition> positions = new HashSet<PdcPosition>();
    private boolean modifiable = true;
    @Column(nullable=false)
    @NotNull
    @Size(min=2)
    private @NotNull @Size(min=2) String instanceId = "";
    private String contentId = null;
    private String nodeId = null;

    protected PdcClassification() {
    }

    public static PdcClassification aPredefinedPdcClassificationForComponentInstance(String instanceId) {
        return new PdcClassification().unmodifiable().inComponentInstance(instanceId);
    }

    public static PdcClassification aPdcClassificationOfContent(String contentId, String inComponentInstanceId) {
        return new PdcClassification().modifiable().ofContent(contentId).inComponentInstance(inComponentInstanceId);
    }

    public static PdcClassification aPdcClassificationOfContent(Contribution contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        return PdcClassification.aPdcClassificationOfContent(contributionId.getLocalId(), contributionId.getComponentInstanceId());
    }

    public Set<PdcPosition> getPositions() {
        return this.positions;
    }

    public boolean isEmpty() {
        return this.getPositions().isEmpty();
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public PdcClassification modifiable() {
        this.modifiable = true;
        return this;
    }

    public PdcClassification unmodifiable() {
        this.modifiable = false;
        return this;
    }

    private PdcClassification ofContent(String contentId) {
        if (StringUtil.isDefined((String)contentId)) {
            this.contentId = contentId;
            this.nodeId = null;
        }
        return this;
    }

    public PdcClassification forNode(String nodeId) {
        if (StringUtil.isDefined((String)nodeId)) {
            this.nodeId = nodeId;
            this.contentId = null;
        }
        return this;
    }

    public PdcClassification inComponentInstance(String instanceId) {
        if (!StringUtil.isDefined((String)instanceId)) {
            throw new NullPointerException("The component instance identifier cannot be null!");
        }
        this.instanceId = instanceId;
        return this;
    }

    public String getComponentInstanceId() {
        return this.instanceId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isPredefined() {
        return this.contentId == null;
    }

    public boolean isPredefinedForTheWholeComponentInstance() {
        return this.isPredefined() && this.nodeId == null;
    }

    public boolean isPredefinedForANode() {
        return this.isPredefined() && this.nodeId != null;
    }

    public void updateForPdcAxisValuesDeletion(List<PdcAxisValue> deletedValues) {
        ArrayList<PdcPosition> positionsToDelete = new ArrayList<PdcPosition>();
        for (PdcPosition pdcPosition : this.getPositions()) {
            for (PdcAxisValue aDeletedValue : deletedValues) {
                if (!pdcPosition.getValues().contains((Object)aDeletedValue)) continue;
                pdcPosition.getValues().remove((Object)aDeletedValue);
                if (!aDeletedValue.isBaseValue()) {
                    this.getDeletedValueInPosition(pdcPosition, deletedValues, aDeletedValue);
                }
                if (!pdcPosition.isEmpty() && !this.alreadyExists(pdcPosition)) continue;
                positionsToDelete.add(pdcPosition);
            }
        }
        this.getPositions().removeAll(positionsToDelete);
    }

    private void getDeletedValueInPosition(PdcPosition pdcPosition, List<PdcAxisValue> deletedValues, PdcAxisValue aDeletedValue) {
        PdcAxisValue parentValue = aDeletedValue.getParentValue();
        while (deletedValues.contains((Object)parentValue) && !parentValue.isBaseValue()) {
            parentValue = parentValue.getParentValue();
        }
        if (!deletedValues.contains((Object)parentValue)) {
            pdcPosition.getValues().add(parentValue);
        }
    }

    public PdcClassification withPositions(Collection<PdcPosition> thePositions) {
        this.positions.clear();
        this.positions.addAll(thePositions);
        return this;
    }

    public PdcClassification withPosition(PdcPosition aPosition) {
        this.positions.add(aPosition);
        return this;
    }

    public String toString() {
        return "PdcClassification{id=" + this.getId() + ", positions=" + String.valueOf(this.positions) + ", modifiable=" + this.modifiable + ", instanceId=" + this.instanceId + ", contentId=" + this.contentId + ", nodeId=" + this.nodeId + "}";
    }

    public PdcClassification copy() {
        PdcClassification classification = new PdcClassification().ofContent(this.contentId).forNode(this.nodeId).inComponentInstance(this.instanceId);
        classification.modifiable = this.modifiable;
        for (PdcPosition pdcPosition : this.positions) {
            classification.getPositions().add(pdcPosition.copy());
        }
        return classification;
    }

    public List<ClassifyPosition> getClassifyPositions() {
        ArrayList<ClassifyPosition> classifyPositions = new ArrayList<ClassifyPosition>(this.getPositions().size());
        try {
            for (PdcPosition position : this.getPositions()) {
                classifyPositions.add(position.toClassifyPosition());
            }
        }
        catch (PdcException ex) {
            throw new PdcRuntimeException((Throwable)((Object)ex));
        }
        return classifyPositions;
    }

    public void classifyContent(Contribution content) {
        this.classifyContent(content, true);
    }

    public void classifyContent(Contribution content, boolean alertSubscribers) {
        this.classifyContent(content, alertSubscribers, false);
    }

    public void classifyContentOrClearClassificationIfEmpty(Contribution content, boolean alertSubscribers) {
        this.classifyContent(content, alertSubscribers, true);
    }

    private void classifyContent(Contribution content, boolean alertSubscribers, boolean clearIfEmpty) {
        if (!this.isEmpty() || clearIfEmpty) {
            PdcClassificationService service = PdcClassificationService.get();
            service.classifyContent(content, this, alertSubscribers);
        }
    }

    private boolean alreadyExists(PdcPosition pdcPosition) {
        boolean alreadyExist = false;
        for (PdcPosition aPosition : this.getPositions()) {
            if (aPosition.getId().equals(pdcPosition.getId()) || !aPosition.getValues().equals(pdcPosition.getValues())) continue;
            alreadyExist = true;
            break;
        }
        return alreadyExist;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

