/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.kernel.cache.model.SimpleCache;

public class AuthorizationRequestCache {
    private static final String CAN_BE = "canBe";
    static final String CAN_BE_ACCESSED_BY_KEY_SUFFIX = "canBeAccessedBy";
    static final String CAN_BE_MODIFIED_BY_KEY_SUFFIX = "canBeModifiedBy";
    static final String CAN_BE_DELETED_BY_KEY_SUFFIX = "canBeDeletedBy";
    private static final Object ALL_KEYS = "AuthorizationRequestCache@@@allKeys";
    private static final int DEFAULT_NB_HANDLED_KEYS = 100;

    private AuthorizationRequestCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handle(User user, String uniqueIdentifier, Predicate<User> authorization, String keySuffix) {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        String cacheKey = AuthorizationRequestCache.getCacheKey(user, uniqueIdentifier, keySuffix);
        Object object = ALL_KEYS;
        synchronized (object) {
            Boolean result = (Boolean)cache.get((Object)cacheKey, Boolean.class);
            if (result == null) {
                result = authorization.test(user);
                cache.put((Object)cacheKey, (Object)result);
                AuthorizationRequestCache.getHandledKeys().add(cacheKey);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getHandledKeys() {
        Object object = ALL_KEYS;
        synchronized (object) {
            SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
            HashSet handledKeys = (HashSet)cache.get(ALL_KEYS, Set.class);
            if (handledKeys == null) {
                handledKeys = new HashSet(100);
                cache.put(ALL_KEYS, handledKeys);
            }
            return handledKeys;
        }
    }

    public static boolean canBeAccessedBy(User user, String uniqueIdentifier, Predicate<User> canBeAccessedBy) {
        return AuthorizationRequestCache.handle(user, uniqueIdentifier, canBeAccessedBy, CAN_BE_ACCESSED_BY_KEY_SUFFIX);
    }

    public static boolean canBeModifiedBy(User user, String uniqueIdentifier, Predicate<User> canBeModifiedBy) {
        return AuthorizationRequestCache.handle(user, uniqueIdentifier, canBeModifiedBy, CAN_BE_MODIFIED_BY_KEY_SUFFIX);
    }

    public static boolean canBeDeletedBy(User user, String uniqueIdentifier, Predicate<User> canBeDeletedBy) {
        return AuthorizationRequestCache.handle(user, uniqueIdentifier, canBeDeletedBy, CAN_BE_DELETED_BY_KEY_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(String uniqueIdentifier) {
        String keyPart = "@@@" + uniqueIdentifier + "@@@canBe";
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        Object object = ALL_KEYS;
        synchronized (object) {
            AuthorizationRequestCache.getHandledKeys().removeIf(handledKey -> {
                boolean hasToBeRemoved = handledKey.contains(keyPart);
                if (hasToBeRemoved) {
                    cache.remove(handledKey);
                }
                return hasToBeRemoved;
            });
        }
    }

    static String getCacheKey(User user, String uniqueIdentifier, String keySuffix) {
        return "AuthorizationRequestCache@@@user_" + user.getId() + "@@@" + uniqueIdentifier + "@@@" + keySuffix;
    }
}

