/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.silverpeas.core.date.AbstractDateTemporal;
import org.silverpeas.core.util.DateUtil;

@Deprecated
public class Date
extends AbstractDateTemporal<Date> {
    private static final long serialVersionUID = 7970735205076340522L;
    private TimeZone timeZone = TimeZone.getDefault();

    public static Date today() {
        Calendar today = Calendar.getInstance();
        return Date.dateOn(today.get(1), today.get(2) + 1, today.get(5));
    }

    public static Date tomorrow() {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        return Date.dateOn(tomorrow.get(1), tomorrow.get(2) + 1, tomorrow.get(5));
    }

    public static Date yesterday() {
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        return Date.dateOn(yesterday.get(1), yesterday.get(2) + 1, yesterday.get(5));
    }

    public static Date dateOn(int year, int month, int dayOfMonth) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.set(5, dayOfMonth);
        date.set(2, month - 1);
        date.set(1, year);
        return new Date(date.getTime());
    }

    public Date(java.util.Date aDate) {
        super(aDate.getTime());
    }

    @Override
    protected Date newInstanceFrom(java.util.Date aDate) {
        return new Date(aDate);
    }

    @Override
    public Date clone() {
        return this.newInstanceFrom(this);
    }

    @Override
    public java.util.Date asDate() {
        return new java.util.Date(this.getTime());
    }

    @Override
    public Date inTimeZone(TimeZone timeZone) {
        this.timeZone = (TimeZone)timeZone.clone();
        return this;
    }

    @Override
    public String toISO8601() {
        return DateUtil.formatAsISO8601Day(this);
    }

    @Override
    public String toShortISO8601() {
        return DateUtil.formatAsISO8601Day(this);
    }

    @Override
    public String toICal() {
        return DateUtil.formatAsICalDay(this);
    }

    @Override
    public String toICalInUTC() {
        return this.toICal();
    }

    public LocalDate toLocalDate() {
        return LocalDateTime.ofInstant(this.toInstant(), this.getTimeZone().toZoneId()).toLocalDate();
    }

    @Override
    public TimeZone getTimeZone() {
        return (TimeZone)this.timeZone.clone();
    }

    @Override
    public boolean isTimeSupported() {
        return false;
    }

    public Date next() {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(this);
        tomorrow.add(5, 1);
        return new Date(tomorrow.getTime());
    }

    public Date previous() {
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(this);
        yesterday.add(5, -1);
        return new Date(yesterday.getTime());
    }

    @Override
    public boolean isBefore(Date anotherDatable) {
        Calendar self = Calendar.getInstance();
        self.setTime(this);
        Calendar other = Calendar.getInstance();
        other.setTime(anotherDatable);
        return self.get(1) < other.get(1) || this.isInSameYear(self, other) && self.get(2) < other.get(2) || this.isInSameMonthInYear(self, other) && self.get(5) < other.get(5);
    }

    @Override
    public boolean isAfter(Date anotherDatable) {
        Calendar self = Calendar.getInstance();
        self.setTime(this);
        Calendar other = Calendar.getInstance();
        other.setTime(anotherDatable);
        return self.get(1) > other.get(1) || this.isInSameYear(self, other) && self.get(2) > other.get(2) || this.isInSameMonthInYear(self, other) && self.get(5) > other.get(5);
    }

    @Override
    public boolean isEqualTo(Date anotherDatable) {
        Calendar self = Calendar.getInstance();
        self.setTime(this);
        Calendar other = Calendar.getInstance();
        other.setTime(anotherDatable);
        return this.isInSameMonthInYear(self, other) && self.get(5) == other.get(5);
    }

    @Override
    public boolean equals(Object obj) {
        Date other;
        if (obj == null) {
            return false;
        }
        if (obj instanceof java.util.Date) {
            other = new Date((java.util.Date)obj);
        } else {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            other = (Date)obj;
        }
        return this.isEqualTo(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private boolean isInSameYear(Calendar date1, Calendar date2) {
        return date1.get(1) == date2.get(1);
    }

    private boolean isInSameMonthInYear(Calendar date1, Calendar date2) {
        return date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2);
    }
}

