/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.service.GroupProvider;

public interface Group
extends Serializable,
Comparable<Group> {
    public static Group getById(String groupId) {
        return GroupProvider.get().getGroup(groupId);
    }

    public static List<Group> getAllRoots() {
        return GroupProvider.get().getAllRootGroups();
    }

    public static List<Group> getAllRootsInDomain(String domainId) {
        return GroupProvider.get().getAllRootGroupsInDomain(domainId);
    }

    public String getId();

    public String getDomainId();

    public String getSuperGroupId();

    public String getName();

    public String getDescription();

    public String[] getUserIds();

    public String getRule();

    public boolean isSynchronized();

    public int getDirectUsersCount();

    public int getTotalUsersCount();

    public boolean isRoot();

    public <T extends Group> List<T> getSubGroups();

    public <T extends User> List<T> getUsers();

    public <T extends User> List<T> getAllUsers();

    public Date getCreationDate();

    public Date getSaveDate();

    public GroupState getState();

    public boolean isValidState();

    public boolean isRemovedState();

    public Date getStateSaveDate();

    public boolean isCommunityGroup();
}

