/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.services;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.sharing.model.DownloadDetail;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.repository.DownloadDetailRepository;
import org.silverpeas.core.sharing.repository.TicketRepository;
import org.silverpeas.core.sharing.services.SharingTicketService;
import org.silverpeas.core.util.SilverpeasList;

@Service
@Singleton
@Transactional
public class JpaSharingTicketService
implements SharingTicketService,
ComponentInstanceDeletion {
    @Inject
    TicketRepository repository;
    @Inject
    DownloadDetailRepository historyRepository;

    @Override
    public long countTicketsByUser(String userId) {
        return this.repository.countAllReservationsForUser(userId);
    }

    @Override
    public SilverpeasList<Ticket> getTicketsByUser(String userId, PaginationPage paginationPage, Ticket.QUERY_ORDER_BY orderBy) {
        SilverpeasList<Ticket> tickets = this.repository.findAllReservationsForUser(userId, paginationPage != null ? paginationPage.asCriterion() : null, orderBy);
        BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new CleanUserTicketRequest(userId, this));
        return tickets;
    }

    @Override
    public void deleteTicketsForSharedObject(Long sharedObjectId, String type) {
        List<Ticket> tickets = this.repository.findAllTicketForSharedObjectId(sharedObjectId, type);
        tickets.forEach(t -> this.historyRepository.deleteDownloadsByTicket((Ticket)t));
        this.historyRepository.flush();
        this.repository.delete(tickets);
        this.repository.flush();
    }

    @Override
    public Ticket getTicket(String key) {
        return (Ticket)this.repository.getById(key);
    }

    @Override
    public String createTicket(Ticket ticket) {
        Ticket result = (Ticket)this.repository.saveAndFlush((IdentifiableEntity)ticket);
        return result.getToken();
    }

    @Override
    public void addDownload(DownloadDetail download) {
        Ticket ticket = (Ticket)this.repository.getById(download.getKeyFile());
        if (ticket != null) {
            this.historyRepository.saveAndFlush((IdentifiableEntity)download);
            ticket.addDownload();
            this.repository.saveAndFlush((IdentifiableEntity)ticket);
        }
    }

    @Override
    public void updateTicket(Ticket ticket) {
        this.repository.saveAndFlush((IdentifiableEntity)ticket);
    }

    @Override
    public void deleteTicket(String key) {
        Ticket ticket = (Ticket)this.repository.getById(key);
        this.repository.delete((IdentifiableEntity[])new Ticket[]{ticket});
        this.historyRepository.deleteDownloadsByTicket(ticket);
    }

    @Transactional
    public void delete(String componentInstanceId) {
        this.repository.deleteAllTicketsForComponentInstance(componentInstanceId);
    }

    @Override
    public SilverpeasList<DownloadDetail> getTicketDownloads(Ticket ticket, PaginationPage paginationPage, DownloadDetail.QUERY_ORDER_BY orderBy) {
        return this.historyRepository.getDownloadsByTicket(ticket, paginationPage != null ? paginationPage.asCriterion() : null, orderBy);
    }

    private static class CleanUserTicketRequest
    extends AbstractBackgroundProcessRequest {
        private final String userId;
        private final SharingTicketService service;

        CleanUserTicketRequest(String userId, SharingTicketService service) {
            super("CleanUserTicketRequest_" + userId, BackgroundProcessTask.LOCK_DURATION.A_DAY);
            this.userId = userId;
            this.service = service;
        }

        protected void process() {
            int pageIndex = 1;
            int pageSize = 10000;
            while (true) {
                PaginationPage paginationPage = new PaginationPage(pageIndex, pageSize);
                SilverpeasList<Ticket> tickets = this.service.getTicketsByUser(this.userId, paginationPage, null);
                for (Ticket ticket : tickets) {
                    if (ticket.getResource() != null) continue;
                    this.service.deleteTicket(ticket.getToken());
                    pageIndex = paginationPage.getPageNumber() - 1;
                }
                if (tickets.size() < pageSize) break;
                ++pageIndex;
            }
        }
    }
}

