/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contact.info;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contact.info.model.InfoPK;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Repository
public class InfoDAO {
    private static final String UNKNOWN = "unknown";

    private boolean hasInfo(Connection con, ContactPK contactPK, String modelId) throws SQLException {
        boolean result;
        InfoPK infoPK = new InfoPK(UNKNOWN, (WAPrimaryKey)contactPK);
        String tableName = infoPK.getTableName();
        String selectStatement = "select infoId FROM " + tableName + " WHERE contactId = ? and instanceId = ? and modelId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
            prepStmt.setString(2, contactPK.getComponentName());
            prepStmt.setString(3, modelId);
            try (ResultSet rs = prepStmt.executeQuery();){
                result = rs.next();
            }
        }
        return result;
    }

    public InfoPK createInfo(Connection con, String modelId, ContactPK contactPK) throws SQLException {
        InfoPK infoPK = new InfoPK(UNKNOWN, (WAPrimaryKey)contactPK);
        String tableName = infoPK.getTableName();
        int newId = DBUtil.getNextId((String)tableName, (String)"infoId");
        infoPK.setId(Integer.toString(newId));
        if (!this.hasInfo(con, contactPK, modelId)) {
            String insertStatement = "INSERT INTO " + tableName + " values ( ? , ? , ? , ? )";
            try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
                prepStmt.setInt(1, Integer.parseInt(infoPK.getId()));
                prepStmt.setInt(2, Integer.parseInt(contactPK.getId()));
                prepStmt.setString(3, modelId);
                prepStmt.setString(4, contactPK.getComponentName());
                prepStmt.executeUpdate();
            }
        }
        return infoPK;
    }

    private void deleteInfo(Connection con, InfoPK infoPK) throws SQLException {
        String deleteStatement = "delete from " + infoPK.getTableName() + " where infoId=?";
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.setInt(1, Integer.parseInt(infoPK.getId()));
        }
    }

    public void deleteInfoDetailByContactPK(Connection con, ContactPK contactPK) throws SQLException {
        InfoPK infoPK = new InfoPK(UNKNOWN, (WAPrimaryKey)contactPK);
        String tableName = infoPK.getTableName();
        String selectStatement = "select * from " + tableName + " where contactId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
            prepStmt.setString(2, infoPK.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    String id = Integer.toString(rs.getInt(1));
                    infoPK = new InfoPK(id, (WAPrimaryKey)contactPK);
                    this.deleteInfo(con, infoPK);
                }
            }
        }
    }

    public void deleteAllInfoByInstanceId(Connection con, String instanceId) throws SQLException {
        String sql = "DELETE FROM SB_Contact_Info WHERE instanceId = ?";
        try (PreparedStatement deletion = con.prepareStatement("DELETE FROM SB_Contact_Info WHERE instanceId = ?");){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    public List<String> getInfo(Connection con, ContactPK pubPK) throws SQLException {
        ArrayList<String> modelIds = new ArrayList<String>();
        InfoPK infoPK = new InfoPK(UNKNOWN, (WAPrimaryKey)pubPK);
        String tableName = infoPK.getTableName();
        String selectStatement = "select modelId FROM " + tableName + " WHERE contactId = ? and instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
            prepStmt.setString(2, pubPK.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    modelIds.add(rs.getString("modelId"));
                }
            }
        }
        return modelIds;
    }
}

