/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.calendar.DayOfWeekOccurrence;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.RecurrencePeriod;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CalendarEventRecurrenceEntity
implements Serializable {
    private FrequencyEntity frequency;
    private int count = 0;
    private String endDate = null;
    private List<DayOfWeekOccurrenceEntity> daysOfWeek = new ArrayList<DayOfWeekOccurrenceEntity>(7);

    protected CalendarEventRecurrenceEntity() {
    }

    public static CalendarEventRecurrenceEntity from(CalendarEvent event, ZoneId zoneId) {
        if (event.getRecurrence() == Recurrence.NO_RECURRENCE) {
            return null;
        }
        return new CalendarEventRecurrenceEntity().decorate(event, zoneId);
    }

    public FrequencyEntity getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyEntity frequency) {
        this.frequency = frequency;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public List<DayOfWeekOccurrenceEntity> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<DayOfWeekOccurrenceEntity> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    @XmlTransient
    Recurrence applyOn(CalendarEvent event, Period occurrencePeriod) {
        Recurrence recurrence = event.getRecurrence();
        if (event.getRecurrence() != null) {
            recurrence.withFrequency(this.getFrequency().getModel());
        } else {
            recurrence = event.recur(Recurrence.from((RecurrencePeriod)this.getFrequency().getModel())).getRecurrence();
        }
        if (this.count > 0) {
            recurrence.until(this.count);
        } else if (StringUtil.isDefined((String)this.endDate)) {
            boolean onAllDay;
            boolean bl = onAllDay = occurrencePeriod == null ? event.isOnAllDay() : occurrencePeriod.isInDays();
            if (onAllDay) {
                recurrence.until((Temporal)LocalDate.parse(this.endDate));
            } else {
                recurrence.until((Temporal)OffsetDateTime.parse(this.endDate));
            }
        } else {
            recurrence.endless();
        }
        if (!this.daysOfWeek.isEmpty()) {
            recurrence.on(this.daysOfWeek.stream().map(DayOfWeekOccurrenceEntity::getModel).collect(Collectors.toList()));
        } else {
            recurrence.onNoSpecificDay();
        }
        return recurrence;
    }

    protected CalendarEventRecurrenceEntity decorate(CalendarEvent event, ZoneId zoneId) {
        Recurrence recurrence = event.getRecurrence();
        this.frequency = FrequencyEntity.from(recurrence.getFrequency());
        this.count = recurrence.getRecurrenceCount();
        Optional optionalDateTime = recurrence.getRecurrenceEndDate();
        this.endDate = null;
        optionalDateTime.ifPresent(t -> {
            this.endDate = (String)TemporalConverter.applyByType((Temporal)t, (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{TemporalConverter.Conversion.of(LocalDate.class, LocalDate::toString), TemporalConverter.Conversion.of(OffsetDateTime.class, dt -> CalendarEventUtil.formatDateWithOffset((CalendarComponent)event.asCalendarComponent(), (Temporal)dt, (ZoneId)zoneId))});
        });
        this.daysOfWeek = recurrence.getDaysOfWeek().stream().sorted(Comparator.comparing(DayOfWeekOccurrence::dayOfWeek)).map(DayOfWeekOccurrenceEntity::from).collect(Collectors.toList());
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("frequency", (Object)this.getFrequency());
        builder.append("count", this.getCount());
        builder.append("daysOfWeek", this.getDaysOfWeek());
        builder.append("endDate", (Object)this.getEndDate());
        return builder.toString();
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DayOfWeekOccurrenceEntity {
        private int nth = 0;
        private DayOfWeek dayOfWeek;

        protected DayOfWeekOccurrenceEntity() {
        }

        public static DayOfWeekOccurrenceEntity from(DayOfWeekOccurrence dayOfWeekOccurrence) {
            return new DayOfWeekOccurrenceEntity().decorate(dayOfWeekOccurrence);
        }

        public int getNth() {
            return this.nth;
        }

        public void setNth(int nth) {
            this.nth = nth;
        }

        public DayOfWeek getDayOfWeek() {
            return this.dayOfWeek;
        }

        public void setDayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @XmlTransient
        public DayOfWeekOccurrence getModel() {
            if (this.getNth() == 0) {
                return DayOfWeekOccurrence.all((DayOfWeek)this.getDayOfWeek());
            }
            return DayOfWeekOccurrence.nth((int)this.getNth(), (DayOfWeek)this.getDayOfWeek());
        }

        protected DayOfWeekOccurrenceEntity decorate(DayOfWeekOccurrence dayOfWeekOccurrence) {
            this.nth = dayOfWeekOccurrence.nth();
            this.dayOfWeek = dayOfWeekOccurrence.dayOfWeek();
            return this;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("nth", this.getNth());
            builder.append("dayOfWeek", (Object)this.getDayOfWeek());
            return builder.toString();
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FrequencyEntity {
        private int interval;
        private TimeUnit timeUnit;

        protected FrequencyEntity() {
        }

        public static FrequencyEntity from(RecurrencePeriod recurrencePeriod) {
            return new FrequencyEntity().decorate(recurrencePeriod);
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        @XmlTransient
        public RecurrencePeriod getModel() {
            return RecurrencePeriod.every((int)this.getInterval(), (TimeUnit)this.getTimeUnit());
        }

        protected FrequencyEntity decorate(RecurrencePeriod recurrencePeriod) {
            this.interval = recurrencePeriod.getInterval();
            this.timeUnit = recurrencePeriod.getUnit();
            return this;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("interval", this.getInterval());
            builder.append("timUnit", (Object)this.getTimeUnit());
            return builder.toString();
        }
    }
}

