/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.VolatileCacheServiceProvider;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.contribution.content.renderer.ContributionContentRenderer;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.security.html.HtmlSanitizer;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.attachment.AttachmentParameterEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttendeeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttributeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventRecurrenceEntity;
import org.silverpeas.core.webapi.pdc.PdcClassificationEntity;
import org.silverpeas.core.webapi.reminder.ReminderEntity;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CalendarEventEntity
implements WebEntity {
    private URI eventUri;
    private URI calendarUri;
    private URI eventPermalinkUrl;
    private String eventId;
    private String calendarId;
    private String calendarZoneId;
    private boolean calendarSync;
    private String id;
    private String type;
    private String title;
    private String description;
    private String content;
    private String location;
    private boolean onAllDay;
    private String startDate;
    private String endDate;
    private VisibilityLevel visibility;
    private Priority priority;
    private CalendarEventRecurrenceEntity recurrence;
    private List<CalendarEventAttendeeEntity> attendees = new ArrayList<CalendarEventAttendeeEntity>();
    private List<CalendarEventAttributeEntity> attributes = new ArrayList<CalendarEventAttributeEntity>();
    private String ownerName;
    private Date createDate;
    private String createdById;
    private Date lastUpdateDate;
    private String lastUpdatedById;
    private boolean canBeAccessed;
    private boolean canBeModified;
    private boolean canBeDeleted;
    private final List<AttachmentParameterEntity> attachmentParameters = new ArrayList<AttachmentParameterEntity>();
    private ReminderEntity reminder;
    private PdcClassificationEntity pdcClassification;

    protected CalendarEventEntity() {
    }

    public static CalendarEventEntity fromEvent(CalendarEvent event, String componentInstanceId, ZoneId zoneId, boolean isEditionMode) {
        return new CalendarEventEntity().decorate(event, componentInstanceId, zoneId, isEditionMode);
    }

    public CalendarEventEntity withEventURI(URI eventUri) {
        this.eventUri = eventUri;
        return this;
    }

    public CalendarEventEntity withCalendarURI(URI calendarUri) {
        this.calendarUri = calendarUri;
        return this;
    }

    public CalendarEventEntity withEventPermalinkURL(URI permalinkUrl) {
        this.eventPermalinkUrl = permalinkUrl;
        return this;
    }

    public CalendarEventEntity withAttendees(List<CalendarEventAttendeeEntity> attendees) {
        this.attendees = attendees;
        return this;
    }

    public CalendarEventEntity withAttributes(List<CalendarEventAttributeEntity> attributes) {
        this.attributes = attributes;
        return this;
    }

    public URI getURI() {
        return this.getEventUri();
    }

    protected void setURI(URI uri) {
        this.setEventUri(uri);
    }

    public URI getEventUri() {
        return this.eventUri;
    }

    protected void setEventUri(URI eventUri) {
        this.eventUri = eventUri;
    }

    public URI getCalendarUri() {
        return this.calendarUri;
    }

    protected void setCalendarUri(URI calendarUri) {
        this.calendarUri = calendarUri;
    }

    public URI getEventPermalinkUrl() {
        return this.eventPermalinkUrl;
    }

    public void setEventPermalinkUrl(URI eventPermalinkUrl) {
        this.eventPermalinkUrl = eventPermalinkUrl;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getContributionType() {
        return this.type;
    }

    protected void setContributionType(String type) {
        this.type = type;
    }

    public String getEventId() {
        return this.eventId;
    }

    protected void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    protected void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public String getCalendarZoneId() {
        return this.calendarZoneId;
    }

    protected void setCalendarZoneId(String calendarZoneId) {
        this.calendarZoneId = calendarZoneId;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = this.normalizeDescription(description);
    }

    public String getContent() {
        return this.content;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    public String getLocation() {
        return this.location;
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    public boolean isOnAllDay() {
        return this.onAllDay;
    }

    protected void setOnAllDay(boolean onAllDay) {
        this.onAllDay = onAllDay;
    }

    public String getStartDate() {
        return this.startDate;
    }

    protected void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    protected void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public VisibilityLevel getVisibility() {
        return this.visibility;
    }

    protected void setVisibility(VisibilityLevel visibility) {
        this.visibility = visibility;
    }

    public Priority getPriority() {
        return this.priority;
    }

    protected void setPriority(Priority priority) {
        this.priority = priority;
    }

    public CalendarEventRecurrenceEntity getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(CalendarEventRecurrenceEntity recurrence) {
        this.recurrence = recurrence;
    }

    public List<CalendarEventAttendeeEntity> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(List<CalendarEventAttendeeEntity> attendees) {
        this.withAttendees(attendees);
    }

    public List<CalendarEventAttributeEntity> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<CalendarEventAttributeEntity> attributes) {
        this.withAttributes(attributes);
    }

    @XmlElement
    public String getOwnerName() {
        return this.ownerName;
    }

    @XmlElement
    public Date getCreateDate() {
        return this.createDate;
    }

    @XmlElement
    public String getCreatedById() {
        return this.createdById;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    protected void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getLastUpdatedById() {
        return this.lastUpdatedById;
    }

    public void setLastUpdatedById(String lastUpdatedById) {
        this.lastUpdatedById = lastUpdatedById;
    }

    @XmlElement
    public boolean calendarSync() {
        return this.calendarSync;
    }

    @XmlElement
    public boolean canBeAccessed() {
        return this.canBeAccessed;
    }

    @XmlElement
    public boolean canBeModified() {
        return this.canBeModified;
    }

    @XmlElement
    public boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    /*
     * Exception decompiling
     */
    @XmlElement
    public Map<String, String[]> getAttachmentParameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @XmlElement
    public PdcClassificationEntity getPdcClassification() {
        return this.pdcClassification != null ? this.pdcClassification : PdcClassificationEntity.undefinedClassification();
    }

    @XmlElement
    public ReminderEntity getReminder() {
        return this.reminder;
    }

    @XmlTransient
    Period getPeriod() {
        Period eventPeriod = this.isOnAllDay() ? Period.between((LocalDate)LocalDate.parse(this.startDate), (LocalDate)LocalDate.parse(this.endDate)) : Period.between((OffsetDateTime)OffsetDateTime.parse(this.startDate), (OffsetDateTime)OffsetDateTime.parse(this.endDate));
        return eventPeriod;
    }

    @XmlTransient
    CalendarEvent getMergedEvent() {
        CalendarEvent event = StringUtil.isDefined((String)this.getEventId()) && !VolatileCacheServiceProvider.getSessionVolatileResourceCacheService().couldBeVolatileId(this.getEventId()) ? CalendarEvent.getById((String)this.getEventId()) : CalendarEvent.on((Period)this.getPeriod());
        this.applyOn(event);
        this.applyOn(event.asCalendarComponent());
        return event;
    }

    @XmlTransient
    void applyOn(CalendarEvent event) {
        String currentText = this.getContent() == null ? "" : this.getContent();
        event.getContent().ifPresentOrElse(c -> c.setData(currentText), () -> {
            if (!currentText.isEmpty()) {
                WysiwygContent wysiwygContent = new WysiwygContent(LocalizedContribution.from((Contribution)event));
                wysiwygContent.setData(currentText);
                event.setContent(wysiwygContent);
            }
        });
        event.withVisibilityLevel(this.getVisibility());
        if (this.getRecurrence() != null) {
            this.getRecurrence().applyOn(event, this.getPeriod());
        } else {
            event.unsetRecurrence();
        }
    }

    @XmlTransient
    void applyOn(CalendarComponent component) {
        component.setPeriod(this.getPeriod());
        component.setTitle(this.getTitle());
        component.setDescription(this.getDescription());
        component.setLocation(this.getLocation());
        component.setPriority(this.getPriority());
        ArrayList<String> newAttendeeIds = new ArrayList<String>(this.getAttendees().size());
        for (CalendarEventAttendeeEntity attendeeEntity : this.getAttendees()) {
            attendeeEntity.addTo(component);
            newAttendeeIds.add(attendeeEntity.getId());
        }
        component.getAttendees().removeIf(attendee -> !newAttendeeIds.contains(attendee.getId()));
        ArrayList<String> newAttributeNames = new ArrayList<String>(this.getAttributes().size());
        for (CalendarEventAttributeEntity attributeEntity : this.getAttributes()) {
            if (!StringUtil.isDefined((String)attributeEntity.getValue())) continue;
            component.getAttributes().set(attributeEntity.getName(), attributeEntity.getValue());
            newAttributeNames.add(attributeEntity.getName());
        }
        component.getAttributes().removeIf(attribute -> !newAttributeNames.contains(attribute.getKey()));
    }

    protected CalendarEventEntity decorate(CalendarEvent calendarEvent, String componentInstanceId, ZoneId zoneId, boolean isEditionMode) {
        User currentUser = User.getCurrentRequester();
        Calendar calendar = calendarEvent.getCalendar();
        CalendarComponent component = calendarEvent.asCalendarComponent();
        this.id = calendarEvent.getIdentifier().asString();
        this.type = calendarEvent.getContributionType();
        this.eventId = calendarEvent.getId();
        this.calendarId = calendar.getId();
        this.calendarZoneId = calendar.getZoneId().toString();
        this.calendarSync = calendar.isSynchronized();
        this.onAllDay = calendarEvent.isOnAllDay();
        this.startDate = CalendarEventUtil.formatDateWithOffset((CalendarComponent)component, (Temporal)calendarEvent.getStartDate(), (ZoneId)zoneId);
        this.endDate = CalendarEventUtil.formatDateWithOffset((CalendarComponent)component, (Temporal)calendarEvent.getEndDate(), (ZoneId)zoneId);
        this.createDate = component.getCreationDate();
        this.createdById = component.getCreatorId();
        this.lastUpdateDate = component.getLastUpdateDate();
        this.lastUpdatedById = component.getLastUpdaterId();
        this.ownerName = calendarEvent.getCreator().getDisplayedName();
        this.canBeAccessed = calendarEvent.canBeAccessedBy(currentUser);
        this.title = CalendarEventUtil.formatTitle((CalendarComponent)component, (String)componentInstanceId, (boolean)this.canBeAccessed);
        if (this.canBeAccessed) {
            this.description = this.normalizeDescription(calendarEvent.getDescription());
            Optional wysiwyg = calendarEvent.getContent();
            if (wysiwyg.isPresent()) {
                ContributionContentRenderer wysiwygRenderer = ((WysiwygContent)wysiwyg.get()).getRenderer();
                this.content = isEditionMode ? wysiwygRenderer.renderEdition() : wysiwygRenderer.renderView();
            } else {
                this.content = "";
            }
            this.location = calendarEvent.getLocation();
            this.visibility = calendarEvent.getVisibilityLevel();
            this.priority = calendarEvent.getPriority();
            this.recurrence = CalendarEventRecurrenceEntity.from(calendarEvent, zoneId);
            this.canBeModified = calendarEvent.canBeModifiedBy(currentUser);
            this.canBeDeleted = calendarEvent.canBeDeletedBy(currentUser);
        } else {
            this.canBeModified = false;
            this.canBeDeleted = false;
        }
        return this;
    }

    private String normalizeDescription(String description) {
        return this.calendarSync && StringUtil.isDefined((String)description) ? HtmlSanitizer.get().sanitize(description) : description;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected ToStringBuilder toStringBuilder() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("eventUri", (Object)this.getURI());
        builder.append("eventId", (Object)this.getEventId());
        builder.append("calendarId", (Object)this.getCalendarId());
        builder.append("calendarZoneId", (Object)this.getCalendarZoneId());
        builder.append("title", (Object)this.getTitle());
        builder.append("description", (Object)this.getDescription());
        builder.append("startDate", (Object)this.getStartDate());
        builder.append("endDate", (Object)this.getEndDate());
        builder.append("onAllDay", this.isOnAllDay());
        builder.append("visibility", (Object)this.getVisibility());
        builder.append("priority", (Object)this.getPriority());
        builder.append("recurrence", (Object)this.getRecurrence());
        builder.append("ownerName", (Object)this.getOwnerName());
        builder.append("createDate", (Object)this.getCreateDate());
        builder.append("createdById", (Object)this.getCreatedById());
        builder.append("lastUpdateDate", (Object)this.getLastUpdateDate());
        builder.append("lastUpdatedById", (Object)this.getLastUpdatedById());
        return builder;
    }
}

