/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.delegate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.PersonalSpaceManager;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.webapi.admin.tools.AbstractTool;
import org.silverpeas.core.webapi.admin.tools.ToolDelegate;
import org.silverpeas.core.webapi.look.delegate.LookWebDelegate;
import org.silverpeas.kernel.util.StringUtil;

public class AdminPersonalWebDelegate {
    private OrganizationController organizationController;
    private final User user;
    private final UserPreferences userPreference;
    private final LookWebDelegate lookDelegate;
    private ToolDelegate toolDelegate;
    private PersonalSpaceManager psc = null;
    private Map<String, WAComponent> indexedNotUsedComponents = null;
    private Map<String, ComponentInst> indexedUsedComponents = null;
    private Map<String, AbstractTool> indexedUsedTools = null;

    public String getComponentLabel(SilverpeasComponent component) {
        String label = this.getLookDelegate().getHelper().getString("lookSilverpeasV5.personalSpace." + component.getName());
        if (!StringUtil.isDefined((String)label)) {
            label = component.getName();
        }
        return label;
    }

    public Collection<WAComponent> getNotUsedComponents() {
        return this.getCachedNotUsedComponents().values();
    }

    public Collection<ComponentInst> getUsedComponents() {
        return this.getCachedUsedComponents().values();
    }

    public Collection<AbstractTool> getUsedTools() {
        return this.getCachedUsedTools().values();
    }

    public ComponentInst useComponent(String componentName) throws Exception {
        WAComponent component = this.getCachedNotUsedComponents().get(componentName.toLowerCase());
        if (component == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"component", (Object)componentName), new String[0]);
        }
        this.getPersonalSpaceManager().addComponent(this.getUser(), component.getName());
        this.clearCache();
        return this.getCachedUsedComponents().get(componentName.toLowerCase());
    }

    public WAComponent discardComponent(String componentName) throws Exception {
        ComponentInst component = this.getCachedUsedComponents().get(componentName.toLowerCase());
        if (component == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"component", (Object)componentName), new String[0]);
        }
        this.getPersonalSpaceManager().removeComponent(this.getUserId(), component.getId());
        this.clearCache();
        return this.getCachedNotUsedComponents().get(componentName.toLowerCase());
    }

    private Map<String, WAComponent> getCachedNotUsedComponents() {
        if (this.indexedNotUsedComponents == null) {
            this.indexedNotUsedComponents = new LinkedHashMap<String, WAComponent>();
            for (WAComponent component : this.getPersonalSpaceManager().getVisibleComponents()) {
                if (this.isComponentUsed(component)) continue;
                this.indexedNotUsedComponents.put(component.getName().toLowerCase(), component);
            }
        }
        return this.indexedNotUsedComponents;
    }

    private Map<String, ComponentInst> getCachedUsedComponents() {
        if (this.indexedUsedComponents == null) {
            this.indexedUsedComponents = new LinkedHashMap<String, ComponentInst>();
            SpaceInst space = this.getPersonalSpaceManager().getPersonalSpace(this.getUserId());
            if (space != null) {
                for (ComponentInst component : space.getAllComponentsInst()) {
                    this.indexedUsedComponents.put(component.getName().toLowerCase(), component);
                }
            }
        }
        return this.indexedUsedComponents;
    }

    private Map<String, AbstractTool> getCachedUsedTools() {
        if (this.indexedUsedTools == null) {
            this.indexedUsedTools = new LinkedHashMap<String, AbstractTool>();
            if (!this.getLookDelegate().getHelper().isAnonymousAccess() && this.getLookDelegate().getHelper().getSettings("personnalSpaceVisible", true)) {
                for (AbstractTool tool : this.getToolDelegate().getAllTools()) {
                    if (!tool.isVisible()) continue;
                    this.indexedUsedTools.put(tool.getId().toLowerCase(), tool);
                }
            }
        }
        return this.indexedUsedTools;
    }

    private boolean isComponentUsed(WAComponent component) {
        return this.getCachedUsedComponents().containsKey(component.getName().toLowerCase());
    }

    private void clearCache() {
        this.indexedNotUsedComponents = null;
        this.indexedUsedComponents = null;
        this.indexedUsedTools = null;
    }

    public static AdminPersonalWebDelegate getInstance(User user, UserPreferences userPreference, LookWebDelegate lookDelegate) {
        return new AdminPersonalWebDelegate(user, userPreference, lookDelegate);
    }

    private AdminPersonalWebDelegate(User user, UserPreferences userPreference, LookWebDelegate lookDelegate) {
        this.user = user;
        this.userPreference = userPreference;
        this.lookDelegate = lookDelegate;
    }

    private User getUser() {
        return this.user;
    }

    private String getUserId() {
        return this.user.getId();
    }

    private OrganizationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganizationControllerProvider.getOrganisationController();
        }
        return this.organizationController;
    }

    private LookWebDelegate getLookDelegate() {
        return this.lookDelegate;
    }

    private ToolDelegate getToolDelegate() {
        if (this.toolDelegate == null) {
            this.toolDelegate = ToolDelegate.getInstance(this.userPreference.getLanguage(), this.getLookDelegate().getHelper());
        }
        return this.toolDelegate;
    }

    private PersonalSpaceManager getPersonalSpaceManager() {
        if (this.psc == null) {
            this.psc = PersonalSpaceManager.get();
        }
        return this.psc;
    }
}

