/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.util.StringUtil;

public class JavascriptSettingProducer {
    private String jsSettingVariableName = "Settings";
    private Map<String, String> keySettings = new LinkedHashMap<String, String>();

    private JavascriptSettingProducer() {
    }

    public static JavascriptSettingProducer settingVariableName(String jsSettingVariableName) {
        return new JavascriptSettingProducer().withSettingVariableName(jsSettingVariableName);
    }

    private JavascriptSettingProducer withSettingVariableName(String jsSettingVariableName) {
        this.jsSettingVariableName = jsSettingVariableName;
        return this;
    }

    public JavascriptSettingProducer add(SilverpeasBundle bundle, String ... keys) {
        for (String key : keys) {
            this.add(key, bundle.getString(key));
        }
        return this;
    }

    protected <T> JavascriptSettingProducer add(String key, Stream<T> values, boolean valuesAreStrings) {
        Stream<Object> decodedValues = values.map(String::valueOf).filter(StringUtil::isDefined).flatMap(v -> Arrays.stream(v.split(",")));
        if (valuesAreStrings) {
            decodedValues = decodedValues.map(JavascriptSettingProducer::stringValue);
        }
        this.keySettings.put(key, decodedValues.collect(Collectors.joining(",", "[", "]")));
        return this;
    }

    public JavascriptSettingProducer add(String key, String value) {
        this.keySettings.put(key, JavascriptSettingProducer.stringValue(value));
        return this;
    }

    public JavascriptSettingProducer add(String key, boolean value) {
        this.keySettings.put(key, String.valueOf(value));
        return this;
    }

    public JavascriptSettingProducer add(String key, Number value) {
        this.keySettings.put(key, String.valueOf(value));
        return this;
    }

    public String produce() {
        StringBuilder js = new StringBuilder();
        js.append("window.").append(this.jsSettingVariableName).append("=new SilverpeasPluginSettings({");
        Iterator<Map.Entry<String, String>> keyMessageIt = this.keySettings.entrySet().iterator();
        while (keyMessageIt.hasNext()) {
            Map.Entry<String, String> keyMessage = keyMessageIt.next();
            js.append("\"").append(keyMessage.getKey()).append("\":");
            js.append(keyMessage.getValue());
            if (!keyMessageIt.hasNext()) continue;
            js.append(",");
        }
        js.append("});");
        return js.toString();
    }

    private static String stringValue(String value) {
        return "'" + WebEncodeHelper.javaStringToJsString((String)value) + "'";
    }
}

