/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordException;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordMailManager;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandlerRegistering;
import org.silverpeas.core.web.token.SynchronizerTokenService;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public abstract class CredentialsFunctionHandler
implements HttpFunctionHandler {
    private final SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.peasCore.SessionManager");
    private LocalizationBundle multilang;
    private final SettingBundle general = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
    private final SettingBundle authenticationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.authenticationSettings");
    @Inject
    private Administration admin;
    @Inject
    private ForgottenPasswordMailManager forgottenPasswordMailManager;

    @PostConstruct
    protected void loadSettings() {
        String language = this.resources.getString("language", "");
        if (!StringUtil.isDefined((String)language)) {
            language = "fr";
        }
        this.multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.peasCore.multilang.peasCoreBundle", (String)language);
    }

    protected ForgottenPasswordMailParameters getMailParameters(String userId) throws AdminException {
        ForgottenPasswordMailParameters parameters = new ForgottenPasswordMailParameters();
        UserDetail userDetail = this.getAdminService().getUserDetail(userId);
        parameters.setUserName(userDetail.getDisplayedName());
        parameters.setLogin(userDetail.getLogin());
        parameters.setDomainId(userDetail.getDomainId());
        parameters.setToAddress(userDetail.getEmailAddress());
        parameters.setUserLanguage(userDetail.getUserPreferences().getLanguage());
        return parameters;
    }

    protected String getContextPath(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String servletPath = request.getServletPath();
        return requestUrl.substring(0, requestUrl.indexOf(servletPath) + servletPath.length());
    }

    protected String forgottenPasswordError(HttpServletRequest request, ForgottenPasswordException fpe) {
        String error = fpe.getMessage() + " - " + fpe.getExtraInfos();
        ForgottenPasswordMailParameters parameters = new ForgottenPasswordMailParameters();
        parameters.setError(error);
        this.getForgottenPasswordMailManager().sendErrorMail(parameters);
        request.setAttribute("error", (Object)error);
        return this.getGeneral().getString("forgottenPasswordError");
    }

    protected SettingBundle getResources() {
        return this.resources;
    }

    protected LocalizationBundle getMultilang() {
        return this.multilang;
    }

    protected ForgottenPasswordMailManager getForgottenPasswordMailManager() {
        return this.forgottenPasswordMailManager;
    }

    protected Administration getAdminService() {
        return this.admin;
    }

    protected SettingBundle getGeneral() {
        return this.general;
    }

    public SettingBundle getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    protected void renewSecurityToken(HttpServletRequest request) {
        SynchronizerTokenService tokenService = SynchronizerTokenService.getInstance();
        tokenService.setUpNavigationTokens(request);
    }

    @Override
    public void registerWith(HttpFunctionHandlerRegistering registering) {
        registering.register(this, false);
    }
}

