/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertyElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.Control;
import org.odftoolkit.simple.draw.ControlContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FormControl
extends Component {
    protected Control drawingShape;
    protected FormFormElement formElement;
    protected FormPropertiesElement mFormProperties;
    protected OdfElement mElement;

    Control createDrawControl(ControlContainer parent) {
        this.drawingShape = parent.createDrawControl();
        this.drawingShape.setControl(this.getId());
        return this.drawingShape;
    }

    public boolean remove() {
        try {
            Document mOwnerDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
            if (this.getDrawControl() == null) {
                this.loadDrawControl(mOwnerDocument.getContentRoot());
            }
            this.getDrawControl().remove();
            this.formElement.removeChild((Node)this.getOdfElement());
            mOwnerDocument.removeElementLinkedResource(this.getOdfElement());
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(FormControl.class.getName()).log(Level.SEVERE, "fail to remove this element.");
            return false;
        }
    }

    boolean loadDrawControl(OdfElement root) {
        NodeList controls = root.getElementsByTagName("draw:control");
        for (int i = 0; i < controls.getLength(); ++i) {
            DrawControlElement control = (DrawControlElement)controls.item(i);
            if (!control.getDrawControlAttribute().equals(this.getId())) continue;
            this.drawingShape = (Control)Component.getComponentByElement((OdfElement)control);
            if (this.drawingShape == null) {
                this.drawingShape = new Control(control);
                Component.registerComponent(this.drawingShape, (OdfElement)control);
            }
            return true;
        }
        return false;
    }

    @Override
    public OdfElement getOdfElement() {
        return this.mElement;
    }

    public Control getDrawControl() {
        return this.drawingShape;
    }

    public abstract void setId(String var1);

    public abstract String getId();

    public abstract void setName(String var1);

    public abstract String getName();

    public abstract void setControlImplementation(String var1);

    public void setAnchorType(StyleTypeDefinitions.AnchorType anchorType) {
        if (this.drawingShape == null) {
            throw new IllegalStateException("No drawing shape is binding to this control. Please call createDrawControl() or loadDrawControl() first.");
        }
        this.drawingShape.setAchorType(anchorType);
    }

    public FrameRectangle getRectangle() {
        return this.getDrawControl().getRectangle();
    }

    public void setRectangle(FrameRectangle rectangle) {
        this.getDrawControl().setRectangle(rectangle);
    }

    abstract FormPropertiesElement getFormPropertiesElementForWrite();

    FormPropertiesElement getFormPropertiesElementForRead() {
        return this.mFormProperties;
    }

    protected void setFormProperty(String formPropertyName, String officeValueType, String officeStringValue, Boolean officeBooleanValue, String officeDateValue, String officeTimeValue, Double officeValue, String officeCurrency) {
        FormPropertiesElement parentEle = this.getFormPropertiesElementForWrite();
        NodeList properties = parentEle.getChildNodes();
        FormPropertyElement formProperty = null;
        for (int i = 0; i < properties.getLength(); ++i) {
            FormPropertyElement property = (FormPropertyElement)properties.item(i);
            if (!property.getFormPropertyNameAttribute().equals(formPropertyName)) continue;
            formProperty = (FormPropertyElement)properties.item(i);
            break;
        }
        if (formProperty == null) {
            org.w3c.dom.Document ownerDocument = parentEle.getOwnerDocument();
            formProperty = (FormPropertyElement)((OdfFileDom)ownerDocument).newOdfElement(FormPropertyElement.class);
            formProperty.setFormPropertyNameAttribute(formPropertyName);
            formProperty.setOfficeValueTypeAttribute(officeValueType);
        }
        if (officeStringValue != null) {
            formProperty.setOfficeStringValueAttribute(officeStringValue);
        }
        if (officeBooleanValue != null) {
            formProperty.setOfficeBooleanValueAttribute(officeBooleanValue);
        }
        if (officeDateValue != null) {
            formProperty.setOfficeDateValueAttribute(officeDateValue);
        }
        if (officeTimeValue != null) {
            formProperty.setOfficeTimeValueAttribute(officeTimeValue);
        }
        if (officeValue != null) {
            formProperty.setOfficeValueAttribute(officeValue);
        }
        if (officeCurrency != null) {
            formProperty.setOfficeCurrencyAttribute(officeCurrency);
        }
        parentEle.appendChild((Node)formProperty);
    }
}

