/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.filter;

import edu.psu.swe.commons.jaxrs.filter.AddNoCacheHeader;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@AddNoCacheHeader
public class NoCacheResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(NoCacheResponseFilter.class);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
        cc.setMustRevalidate(true);
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)cc);
        responseContext.getHeaders().add((Object)"Pragma", (Object)"no-cache");
        responseContext.getHeaders().add((Object)"Expires", (Object)"0");
        log.debug("***************Response Headers Added for no-cache: Cache-Control, Pragma, Expires**********");
    }
}

