/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.jcr.security.JCRNode;

public class JCRAccessController {
    private final User user;
    private final AccessContext accessContext;

    public JCRAccessController(User user, AccessContext context) {
        this.user = user;
        this.accessContext = context;
    }

    public boolean isGranted(JCRNode<?> node, long permissions) {
        if (this.user == null) {
            return false;
        }
        if (this.isSystemOrAdminAccess()) {
            return true;
        }
        boolean granted = node.isFolder() ? this.isFolderAccessGranted(node, permissions) : (node.isFile() && node.isLocked() ? this.isFileAccessGranted(node, permissions) : this.isNodeAccessGranted(node, permissions));
        return granted;
    }

    public User getUser() {
        return this.user;
    }

    public AccessContext getAccessContext() {
        return this.accessContext;
    }

    private boolean isNodeAccessGranted(JCRNode<?> node, long permissions) {
        return permissions == 3L || this.isFolderAccessGranted(node, permissions);
    }

    private boolean isFileAccessGranted(JCRNode<?> tree, long permissions) {
        User usr = this.getUser();
        AccessContext ctx = this.getAccessContext();
        return usr.isAccessAdmin() || tree.isOwnedByUser(usr) || ctx.isGranted(tree.getPath(), permissions);
    }

    private boolean isFolderAccessGranted(JCRNode<?> tree, long permissions) {
        User usr = this.getUser();
        AccessContext ctx = this.getAccessContext();
        return usr.isAccessAdmin() || ctx.isGranted(tree.getPath(), permissions);
    }

    private boolean isSystemOrAdminAccess() {
        User usr = this.getUser();
        return usr.isSystem() || usr.isAccessAdmin();
    }
}

