/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.security;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasCallbackHandler;
import org.silverpeas.core.jcr.security.LoginModuleRegistry;
import org.silverpeas.core.jcr.security.SilverpeasJCRLoginModule;
import org.silverpeas.core.jcr.security.SilverpeasUserPrincipal;

public class SilverpeasLoginContext
implements LoginContext {
    private final Subject subject;
    private final SilverpeasCallbackHandler callbackHandler;
    private Set<SilverpeasJCRLoginModule> modules;

    SilverpeasLoginContext(Subject subject, SilverpeasCallbackHandler callbackHandler) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void login() throws LoginException {
        this.applyOnLoginModule(l -> {
            Set<SilverpeasUserPrincipal> principals;
            boolean status;
            boolean bl = status = l.login() && l.commit();
            if (status && !(principals = this.getSubject().getPrincipals(SilverpeasUserPrincipal.class)).isEmpty()) {
                SilverpeasUserPrincipal principal = principals.iterator().next();
                AuthInfoImpl authInfo = new AuthInfoImpl(principal.getUser().getId(), null, principals);
                this.getSubject().getPublicCredentials().add(authInfo);
            }
            return status;
        });
    }

    public void logout() throws LoginException {
        this.applyOnLoginModule(LoginModule::logout);
    }

    private void applyOnLoginModule(AuthOp operation) throws LoginException {
        Credentials credentials = this.getCredentials();
        Iterator<SilverpeasJCRLoginModule> iterator = this.getLoginModules(credentials.getClass()).iterator();
        HashMap sharedState = new HashMap();
        HashMap options = new HashMap();
        boolean succeeded = false;
        while (iterator.hasNext() && !succeeded) {
            SilverpeasJCRLoginModule module = iterator.next();
            if (!module.isInitialized()) {
                module.initialize(this.getSubject(), this.callbackHandler, sharedState, options);
            }
            succeeded = operation.check((LoginModule)((Object)module));
        }
        if (!succeeded) {
            throw new LoginException("No authentication mechanism matches the credentials " + String.valueOf(credentials));
        }
    }

    @Nonnull
    private Credentials getCredentials() throws LoginException {
        Credentials credentials = this.callbackHandler.getCredentials();
        if (credentials == null) {
            throw new LoginException("No credentials!");
        }
        return credentials;
    }

    @Nonnull
    private LoginModuleRegistry getLoginModuleRegistry() {
        return LoginModuleRegistry.getInstance();
    }

    @Nonnull
    private Set<SilverpeasJCRLoginModule> getLoginModules(@Nonnull Class<? extends Credentials> credentialsType) throws LoginException {
        if (this.modules == null) {
            this.modules = this.getLoginModuleRegistry().getLoginModule(credentialsType);
            if (this.modules.isEmpty()) {
                this.modules = null;
                throw new LoginException("Unsupported credentials: " + credentialsType.getName());
            }
        }
        return this.modules;
    }

    @FunctionalInterface
    private static interface AuthOp {
        public boolean check(LoginModule var1) throws LoginException;
    }
}

