/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.jcr.SilverpeasRepository;
import org.silverpeas.core.jcr.SilverpeasRepositoryFactory;
import org.silverpeas.core.jcr.impl.RepositorySettings;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Provider
public class RepositoryProvider {
    private SilverpeasRepository repository;

    public static RepositoryProvider get() {
        return (RepositoryProvider)ServiceProvider.getService(RepositoryProvider.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    private void openRepository() {
        Function<RepositoryFactory, Repository> repositoryCreator = RepositoryProvider.getRepositoryCreator();
        SilverpeasRepositoryFactory factory = ServiceLoader.load(RepositoryFactory.class).stream().map(ServiceLoader.Provider::get).filter(SilverpeasRepositoryFactory.class::isInstance).map(SilverpeasRepositoryFactory.class::cast).findFirst().orElseThrow(() -> new SilverpeasRuntimeException("No JCR backend found!"));
        Repository jcr = Optional.ofNullable(repositoryCreator.apply(factory)).orElseThrow(() -> new SilverpeasRuntimeException("No JCR backend found!"));
        SilverLogger.getLogger((Object)this).info("Open connection to the JCR", new Object[0]);
        this.repository = SilverpeasRepository.wrap(jcr);
    }

    @NonNull
    private static Function<RepositoryFactory, Repository> getRepositoryCreator() {
        RepositorySettings settings = new RepositorySettings();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("jcr.home", settings.getJCRHomeDirectory());
        parameters.put("jcr.conf", settings.getJCRConfigurationFile());
        return f -> {
            try {
                return f.getRepository(parameters);
            }
            catch (RepositoryException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        };
    }

    @Produces
    public SilverpeasRepository getRepository() {
        return this.repository;
    }
}

