/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.util.BiStatsConsumer;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

public final class ModifyMetricUpdater {
    private final MeterStats createNodeUpsertMeter;
    private final TimerStats createNodeUpsertTimer;
    private final MeterStats updateNodeMeter;
    private final TimerStats updateNodeTimer;
    private final MeterStats updateNodeRetryCountMeter;
    private final MeterStats updateNodeFailureMeter;

    public ModifyMetricUpdater(MeterStats createNodeUpsertMeter, TimerStats createNodeUpsertTimer, MeterStats updateNodeMeter, TimerStats updateNodeTimer, MeterStats updateNodeRetryCountMeter, MeterStats updateNodeFailureMeter) {
        this.createNodeUpsertMeter = createNodeUpsertMeter;
        this.createNodeUpsertTimer = createNodeUpsertTimer;
        this.updateNodeMeter = updateNodeMeter;
        this.updateNodeTimer = updateNodeTimer;
        this.updateNodeRetryCountMeter = updateNodeRetryCountMeter;
        this.updateNodeFailureMeter = updateNodeFailureMeter;
    }

    public void update(Collection<? extends Document> collection, int retryCount, long timeTakenNanos, boolean isSuccess, boolean newEntry, List<String> ids, BiPredicate<Collection<? extends Document>, Integer> isNodesCollectionUpdated, BiStatsConsumer createBiStatsConsumer, BiStatsConsumer updateBiStatsConsumer, ObjIntConsumer<MeterStats> retryNodesConsumer, Consumer<MeterStats> failureNodesConsumer) {
        Objects.requireNonNull(isNodesCollectionUpdated);
        Objects.requireNonNull(createBiStatsConsumer);
        Objects.requireNonNull(updateBiStatsConsumer);
        Objects.requireNonNull(retryNodesConsumer);
        Objects.requireNonNull(failureNodesConsumer);
        if (isNodesCollectionUpdated.negate().test(collection, ids.size())) {
            return;
        }
        if (isSuccess) {
            if (newEntry) {
                createBiStatsConsumer.accept(this.createNodeUpsertMeter, this.createNodeUpsertTimer, ids.size(), timeTakenNanos);
            } else {
                updateBiStatsConsumer.accept(this.updateNodeMeter, this.updateNodeTimer, ids.size(), timeTakenNanos);
            }
            if (retryCount > 0) {
                retryNodesConsumer.accept(this.updateNodeRetryCountMeter, retryCount);
            }
        } else {
            retryNodesConsumer.accept(this.updateNodeRetryCountMeter, retryCount);
            failureNodesConsumer.accept(this.updateNodeFailureMeter);
        }
    }
}

