/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.io.Closeable;
import java.util.Iterator;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterator;
import org.bson.conversions.Bson;

public class MongoBlobReferenceIterator
extends BlobReferenceIterator {
    private final MongoDocumentStore documentStore;

    public MongoBlobReferenceIterator(DocumentNodeStore nodeStore, MongoDocumentStore documentStore) {
        super(nodeStore);
        this.documentStore = documentStore;
    }

    @Override
    public Iterator<NodeDocument> getIteratorOverDocsWithBinaries() {
        Bson query = Filters.eq((String)"_bin", (Object)1L);
        MongoCursor cursor = this.documentStore.getDBCollection(Collection.NODES).find(query).iterator();
        return CloseableIterator.wrap(IteratorUtils.transform((Iterator)cursor, input -> this.documentStore.convertFromDBObject(Collection.NODES, (DBObject)input)), (Closeable)cursor);
    }
}

