/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.util.StringUtil;

public class MultiSilverpeasBundle {
    private final LocalizationBundle specificMultilang;
    private SettingBundle specificIcons = null;
    private SettingBundle specificSettings = null;
    private final String language;

    public MultiSilverpeasBundle(LocalizationBundle specificMultilang, SettingBundle specificIcons, String language) {
        this.specificMultilang = specificMultilang;
        this.specificIcons = specificIcons;
        this.language = language;
    }

    public MultiSilverpeasBundle(LocalizationBundle specificMultilang, SettingBundle specificIcons, SettingBundle specificSettings, String language) {
        this.specificMultilang = specificMultilang;
        this.specificIcons = specificIcons;
        this.language = language;
        this.specificSettings = specificSettings;
    }

    public MultiSilverpeasBundle(LocalizationBundle specificMultilang, String language) {
        this.specificMultilang = specificMultilang;
        this.language = language;
    }

    public ResourceBundle getMultilangBundle() {
        return this.specificMultilang;
    }

    public SettingBundle getIconsBundle() {
        return this.specificIcons;
    }

    public String getString(String key) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (this.specificMultilang != null) {
                valret = this.specificMultilang.getString(key);
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getStringWithParams(String key, String param) {
        String[] params = new String[]{param};
        return this.getStringWithParams(key, params);
    }

    public String getStringWithParams(String key, String[] params) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (this.specificMultilang != null) {
                valret = this.specificMultilang.getStringWithParams(key, (Object[])params);
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getIcon(String key) {
        return URLUtil.getApplicationURL() + this.getValue(key, (SilverpeasBundle)this.specificIcons);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSetting(String key) {
        return this.getSetting(key, null);
    }

    public String getSetting(String key, String defaultValue) {
        return this.specificSettings.getString(key, defaultValue);
    }

    public boolean getSetting(String key, boolean defaultValue) {
        return this.specificSettings.getBoolean(key, defaultValue);
    }

    public int getSetting(String key, int defaultValue) {
        return this.specificSettings.getInteger(key, defaultValue);
    }

    public String getOutputDate(Date date) {
        return DateUtil.getOutputDate((Date)date, (String)this.language);
    }

    public String getOutputDate(LocalDate date) {
        return this.getOutputDate(Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    public String getOutputDate(String dateDB) throws ParseException {
        return DateUtil.getOutputDate((String)dateDB, (String)this.language);
    }

    public String getOutputDateAndHour(Date date) {
        return DateUtil.getOutputDateAndHour((Date)date, (String)this.language);
    }

    public String getOutputDateAndHour(Date date, Date defaultDate) {
        String formatedDate = DateUtil.getOutputDateAndHour((Date)date, (String)this.language);
        if (!StringUtil.isDefined((String)formatedDate)) {
            formatedDate = DateUtil.getOutputDateAndHour((Date)defaultDate, (String)this.language);
        }
        return formatedDate;
    }

    public String getInputDate(Date date) {
        return DateUtil.getInputDate((Date)date, (String)this.language);
    }

    public String getInputDate(String dateDB) throws ParseException {
        return DateUtil.getInputDate((String)dateDB, (String)this.language);
    }

    public String getDBDate(String date) throws ParseException {
        return DateUtil.date2SQLDate((String)date, (String)this.language);
    }

    public String getDBDate(Date date) {
        return DateUtil.date2SQLDate((Date)date);
    }

    public Date getDate(String date) throws ParseException {
        return DateUtil.stringToDate((String)date, (String)this.language);
    }

    private String getValue(String key, SilverpeasBundle bundle) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (bundle != null && bundle.exists()) {
                try {
                    valret = bundle.getString(key);
                }
                catch (MissingResourceException ex) {
                    valret = null;
                }
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }
}

