/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasDialectResolver
implements DialectResolver {
    private static final long serialVersionUID = 901024770482418345L;

    public Dialect resolveDialect(DialectResolutionInfo info) {
        String dialect = System.getProperty("silverpeas.jpa.dialect");
        if (StringUtil.isDefined((String)dialect)) {
            Logger logger = Logger.getLogger(Dialect.class.getName());
            try {
                Class<?> dialectClass = Class.forName(dialect);
                Constructor<?> constructor = dialectClass.getConstructor(new Class[0]);
                Dialect dialectInstance = (Dialect)constructor.newInstance(new Object[0]);
                logger.log(Level.SEVERE, "SilverpeasDialectResolver - Using dialect: {0}", dialectClass.getName());
                return dialectInstance;
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.severe(e.getMessage());
            }
        }
        return null;
    }
}

