/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.server;

import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.silverpeas.core.notification.user.client.NotificationParameterNames;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.channel.AbstractListener;
import org.silverpeas.core.notification.user.server.channel.server.ServerMessageService;
import org.silverpeas.kernel.logging.SilverLogger;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="CHANNEL='SERVER'"), @ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/queue/notificationsQueue")}, description="Message driven bean to silverpeas notification")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SERVERListener
extends AbstractListener
implements MessageListener {
    public void onMessage(Message msg) {
        try {
            this.processMessage(msg);
        }
        catch (NotificationServerException e) {
            SilverLogger.getLogger((Object)this).error("Processing server notification error!", (Throwable)((Object)e));
        }
    }

    @Override
    public void send(NotificationData notification) {
        Map params = notification.getTargetParam();
        String sessionId = (String)params.get(NotificationParameterNames.SESSIONID.toString());
        ServerMessageService.get().push(notification.getTargetReceipt(), notification.getMessage(), sessionId);
    }
}

