/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FieldValuesTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.FormFatalException;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.record.Label;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Pair;

@XmlRootElement(name="fieldTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GenericFieldTemplate
implements FieldTemplate {
    private static final long serialVersionUID = 1L;
    @XmlElement(required=true)
    private String fieldName;
    private Class<? extends Field> fieldImpl;
    private String typeName;
    @XmlElement(required=true)
    private String displayerName = "";
    @XmlElement(name="isMandatory", required=true, defaultValue="false")
    private boolean mandatory;
    @XmlElement(name="isReadOnly", required=true, defaultValue="false")
    private boolean readOnly;
    @XmlElement(name="isDisabled", required=true, defaultValue="false")
    private boolean disabled;
    @XmlElement(name="isHidden", required=true, defaultValue="false")
    private boolean hidden;
    private String defaultLabel;
    private Map<String, String> labels = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    @XmlElement(name="label")
    private List<Label> labelsObj = new ArrayList<Label>();
    @XmlElement(name="parameter")
    private List<Parameter> parametersObj = new ArrayList<Parameter>();
    @XmlElement(name="isSearchable", required=true, defaultValue="false")
    private boolean searchable;
    private String templateName;
    @XmlElement(name="isFacet", required=true, defaultValue="false")
    private boolean usedAsFacet;
    @XmlElement(defaultValue="1")
    private int maximumNumberOfOccurrences = 1;

    public GenericFieldTemplate() {
    }

    public GenericFieldTemplate(String fieldName, String typeName) throws FormException {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.init();
    }

    public GenericFieldTemplate(String fieldName, Class<? extends Field> fieldImpl) throws FormException {
        this.fieldName = fieldName;
        this.fieldImpl = fieldImpl;
        this.init();
    }

    private void init() throws FormException {
        if (this.fieldImpl == null) {
            this.fieldImpl = TypeManager.getInstance().getFieldImplementation(this.typeName);
        }
        Field dummyField = this.getEmptyField();
        if (this.typeName == null) {
            this.typeName = dummyField.getTypeName();
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    @XmlElement(required=true)
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) throws FormException {
        this.typeName = typeName;
        this.fieldImpl = TypeManager.getInstance().getFieldImplementation(typeName);
    }

    @Override
    public String getDisplayerName() {
        return this.displayerName;
    }

    public void setDisplayerName(String displayerName) {
        this.displayerName = displayerName;
    }

    @Override
    public String getLabel() {
        if (this.defaultLabel != null) {
            return this.defaultLabel;
        }
        return "";
    }

    @Override
    public String getLabel(String language) {
        String label = null;
        if (this.getLabels() != null) {
            label = this.getLabels().get(language);
        }
        if (label == null) {
            return this.getLabel();
        }
        return label;
    }

    public String getParameter(String name, String language) {
        String parameter = null;
        if (this.getParameters(language) != null) {
            parameter = this.getParameters(language).get(name);
        }
        return Objects.requireNonNullElse(parameter, "");
    }

    public void setLabel(String label) {
        this.defaultLabel = label;
    }

    public void addLabel(String label, String language) {
        if (language == null || language.trim().isEmpty()) {
            this.setLabel(label);
        } else {
            if (this.labels == null) {
                this.labels = new HashMap<String, String>();
            }
            this.labels.put(language, label);
        }
    }

    public void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    public void setMandatory(Boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.readOnly = isReadOnly;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean isHidden) {
        this.hidden = isHidden;
    }

    @Override
    public Map<String, String> getParameters(String language) {
        for (Parameter parameter : this.parametersObj) {
            this.addParameter(parameter.getName(), parameter.getValue(language));
        }
        return this.parameters;
    }

    @Override
    public FieldValuesTemplate getFieldValuesTemplate(String language) {
        List<Pair<String, String>> keyValuePairs = this.computeKeyValuePairs(language);
        FieldValuesTemplate valuesTemplate = new FieldValuesTemplate(language);
        keyValuePairs.forEach(p -> valuesTemplate.withAsValue((String)p.getFirst(), (String)p.getSecond()));
        return valuesTemplate;
    }

    private List<Pair<String, String>> computeKeyValuePairs(String language) {
        Map<String, String> theParameters = this.getParameters(language);
        if (theParameters == null) {
            return Collections.emptyList();
        }
        String keys = theParameters.get("keys");
        String values = theParameters.get("values");
        return GenericFieldTemplate.computeOrderedKeyValuePairs(keys, values);
    }

    public static Map<String, String> computeKeyValuePairs(String keys, String values) {
        return GenericFieldTemplate.computeOrderedKeyValuePairs(keys, values).stream().collect(HashMap::new, (m, kv) -> m.put((String)kv.getFirst(), (String)kv.getSecond()), HashMap::putAll);
    }

    public static List<Pair<String, String>> computeOrderedKeyValuePairs(String keys, String values) {
        ArrayList<Pair<String, String>> keyValuePairs = new ArrayList<Pair<String, String>>();
        if (keys != null && values != null) {
            List<String> decodedKeys = Parameter.decode(keys);
            List<String> decodedValues = Parameter.decode(values);
            for (int i = 0; i < decodedKeys.size(); ++i) {
                keyValuePairs.add((Pair<String, String>)Pair.of((Object)decodedKeys.get(i), (Object)decodedValues.get(i)));
            }
        } else if (keys != null) {
            Parameter.decode(keys).forEach(k -> keyValuePairs.add(Pair.of((Object)k, (Object)k)));
        } else if (values != null) {
            Parameter.decode(values).forEach(v -> keyValuePairs.add(Pair.of((Object)v, (Object)v)));
        }
        return keyValuePairs;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null || this.labels.isEmpty()) {
            for (Label label : this.labelsObj) {
                this.addLabel(label.getName(), label.getLanguage());
            }
        }
        return this.labels;
    }

    @Override
    public Field getEmptyField() throws FormException {
        return this.getEmptyField(0);
    }

    @Override
    public Field getEmptyField(int occurrence) throws FormException {
        try {
            Constructor<? extends Field> constructor = this.fieldImpl.getConstructor(new Class[0]);
            Field field = constructor.newInstance(new Object[0]);
            field.setName(this.fieldName);
            field.setOccurrence(occurrence);
            return field;
        }
        catch (Exception e) {
            throw new FormFatalException(e);
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof String) {
                return obj.equals(this.getFieldName());
            }
            if (obj instanceof GenericFieldTemplate) {
                return ((GenericFieldTemplate)obj).getFieldName().equals(this.getFieldName());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.getFieldName().hashCode();
    }

    @Override
    public String[] getLanguages() {
        if (this.labels == null) {
            return ArrayUtil.emptyStringArray();
        }
        return (String[])this.labels.keySet().stream().map(this.labels::get).toArray(String[]::new);
    }

    public List<Label> getLabelsObj() {
        return this.labelsObj;
    }

    public void setLabelsObj(List<Label> labelsObj) {
        this.labelsObj = labelsObj;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parametersObj;
    }

    public void setParametersObj(List<Parameter> parametersObj) {
        this.parametersObj = parametersObj;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public boolean isUsedAsFacet() {
        return this.usedAsFacet;
    }

    public void setUsedAsFacet(boolean usedAsFacet) {
        this.usedAsFacet = usedAsFacet;
    }

    public GenericFieldTemplate copy() {
        GenericFieldTemplate copy;
        try {
            copy = new GenericFieldTemplate();
            copy.setDisabled(this.isDisabled());
            copy.setDisplayerName(this.getDisplayerName());
            copy.setFieldName(this.getFieldName());
            copy.setHidden(this.isHidden());
            copy.setLabel(this.getLabel());
            copy.setLabelsObj(this.getLabelsObj());
            copy.setMandatory(this.isMandatory());
            copy.setParametersObj(this.getParameters());
            copy.setReadOnly(this.isReadOnly());
            copy.setSearchable(this.isSearchable());
            copy.setTemplateName(this.getTemplateName());
            copy.setTypeName(this.getTypeName());
            copy.setUsedAsFacet(this.isUsedAsFacet());
            copy.setMaximumNumberOfOccurrences(this.getMaximumNumberOfOccurrences());
        }
        catch (FormException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
        return copy;
    }

    @Override
    public int getMaximumNumberOfOccurrences() {
        return this.maximumNumberOfOccurrences;
    }

    public void setMaximumNumberOfOccurrences(int nb) {
        this.maximumNumberOfOccurrences = Math.max(nb, 1);
    }

    @Override
    public boolean isRepeatable() {
        return this.maximumNumberOfOccurrences > 1;
    }
}

