/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.util;

import java.util.Optional;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class AttachmentSettings {
    public static final int DEFAULT_REORDER_START = 1;
    public static final int YOUNGEST_TO_OLDEST_MANUAL_REORDER_START = 200000;
    public static final int YOUNGEST_TO_OLDEST_MANUAL_REORDER_THRESHOLD = 100000;
    private static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.attachment.Attachment");

    private AttachmentSettings() {
        throw new IllegalStateException("Utility class");
    }

    public static int getDelayInPercentAfterWhichReservedFileAlertMustBeSent() {
        return settings.getInteger("DelayReservedFile", -1);
    }

    public static boolean listFromYoungestToOldestAdd() {
        int order = settings.getInteger("attachment.list.order", 1);
        return order < 0;
    }

    public static boolean isUseFileMetadataForAttachmentDataEnabled() {
        return settings.getBoolean("attachment.data.fromMetadata", false);
    }

    public static Stream<String> displayableAsContentComponentNames() {
        return Stream.of(settings.getString("attachmentsAsContent.component.names", "").split("[ ,;]")).map(String::trim);
    }

    public static boolean defaultValueOfDisplayableAsContentBehavior() {
        return settings.getBoolean("attachmentsAsContent.default.value", true);
    }

    public static boolean isDisplayableAsContentForComponentInstanceId(String componentInstanceId) {
        return AttachmentSettings.displayableAsContentComponentNames().map(c -> {
            Optional<SilverpeasComponent> component = SilverpeasComponent.getByInstanceId(componentInstanceId);
            return component.isPresent() && component.get().getName().equalsIgnoreCase(c.trim());
        }).filter(b -> b).findFirst().orElse(false);
    }

    public static boolean defaultValueOfEditableSimultaneously() {
        return settings.getBoolean("attachment.onlineEditing.simultaneously.default", true);
    }
}

