/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.notification.role;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.silverpeas.core.notification.system.AbstractResourceEvent;
import org.silverpeas.core.notification.system.ResourceEvent;

public class UserRoleEvent
extends AbstractResourceEvent<UserSet> {
    private final Set<String> instanceIds = new HashSet<String>();
    private String role;

    private UserRoleEvent(ResourceEvent.Type type, UserSet ... users) {
        super(type, (Serializable[])users);
    }

    public Set<String> getInstanceIds() {
        return this.instanceIds;
    }

    public Set<String> getUserIds() {
        return this.getTransition().getBefore() == null ? (Set)((Object)this.getTransition().getAfter()) : (Set)((Object)this.getTransition().getBefore());
    }

    public String getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserRoleEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserRoleEvent that = (UserRoleEvent)((Object)o);
        return Objects.equals(this.instanceIds, that.instanceIds) && Objects.equals(this.role, that.role);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.instanceIds, this.role);
    }

    static Builder builderFor(ResourceEvent.Type type) {
        return new Builder(type);
    }

    public static class UserSet
    extends HashSet<String>
    implements Serializable {
        private UserSet() {
        }
    }

    static class Builder {
        private final UserRoleEvent event;

        private Builder(ResourceEvent.Type type) {
            UserSet users = new UserSet();
            this.event = new UserRoleEvent(type, users, users);
        }

        Builder userId(String userId) {
            this.event.getUserIds().add(userId);
            return this;
        }

        Builder userIds(Collection<String> userIds) {
            this.event.getUserIds().addAll(userIds);
            return this;
        }

        Builder role(String role) {
            this.event.role = role;
            return this;
        }

        Builder instanceId(String instanceId) {
            this.event.instanceIds.add(instanceId);
            return this;
        }

        Builder instanceIds(Collection<String> instanceIds) {
            this.event.instanceIds.addAll(instanceIds);
            return this;
        }

        UserRoleEvent build() {
            return this.event;
        }
    }
}

