/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.dao.SqlGroupSelectorByCriteriaBuilder;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.admin.user.model.GroupCache;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class GroupDAO {
    private static final String GROUP_TABLE = "ST_Group";
    private static final String GROUP_USERS_TABLE = "st_group_user_rel";
    private static final String GROUP_ROLE_TABLE = "st_groupuserrole";
    private static final String GROUP_ROLE_USERS_TABLE = "st_groupuserrole_user_rel";
    private static final String GROUP_ROLE_GROUPS_TABLE = "st_groupuserrole_group_rel";
    private static final String USER_ROLE_GROUPS_TABLE = "st_userrole_group_rel";
    private static final String SPACE_ROLE_GROUP = "st_spaceuserrole_group_rel";
    private static final String GROUP_COLUMNS_PATTERN = "DISTINCT({0}id),{0}specificId,{0}domainId,{0}spaceId,{0}superGroupId,{0}name,{0}description,{0}synchroRule,{0}creationDate,{0}saveDate,{0}state,{0}stateSaveDate";
    private static final String GROUP_COLUMNS = MessageFormat.format("DISTINCT({0}id),{0}specificId,{0}domainId,{0}spaceId,{0}superGroupId,{0}name,{0}description,{0}synchroRule,{0}creationDate,{0}saveDate,{0}state,{0}stateSaveDate", "");
    private static final String SEARCH_GROUP_COLUMNS = MessageFormat.format("DISTINCT({0}id),{0}specificId,{0}domainId,{0}spaceId,{0}superGroupId,{0}name,{0}description,{0}synchroRule,{0}creationDate,{0}saveDate,{0}state,{0}stateSaveDate", "g.");
    private static final String DOMAIN_ID_CRITERION = "domainId = ?";
    private static final String GROUP_ID_CRITERION = "groupId = ?";
    private static final String STATE_CRITERION = "state = ?";
    private static final String ID_CRITERION = "id = ?";
    private static final String USER_ID = "userId";
    private static final String GROUP_ID = "groupId";
    private static final String GROUP_ID_ATTR = ".groupid";
    private static final String SPECIFIC_ID = "specificId";
    private static final String SPACE_ID = "spaceId";
    private static final String DOMAIN_ID = "domainId";
    private static final String SUPER_GROUP_ID = "superGroupId";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String SYNCHRO_RULE = "synchroRule";
    private static final String CREATION_DATE = "creationDate";
    private static final String SAVE_DATE = "saveDate";
    private static final String STATE = "state";
    private static final String STATE_SAVE_DATE = "stateSaveDate";
    @Inject
    private GroupCache groupCache;

    protected GroupDAO() {
    }

    public String addGroup(Connection connection, GroupDetail group) throws SQLException {
        Integer superGroupId = this.checkSuperGroup(connection, group);
        int nextId = DBUtil.getNextId((String)GROUP_TABLE);
        String specificId = StringUtil.isDefined((String)group.getSpecificId()) ? group.getSpecificId() : String.valueOf(nextId);
        Instant now = new Date().toInstant();
        if (GroupState.UNKNOWN.equals((Object)group.getState())) {
            group.setState(GroupState.VALID);
        }
        JdbcSqlQuery.insertInto((String)GROUP_TABLE).withInsertParam("id", (Object)nextId).withInsertParam(SPECIFIC_ID, (Object)specificId).withInsertParam(SPACE_ID, (Object)group.getSpaceId()).withInsertParam(DOMAIN_ID, (Object)this.getDomainIdOf(group)).withInsertParam(SUPER_GROUP_ID, (Object)superGroupId).withInsertParam(NAME, (Object)group.getName()).withInsertParam(DESCRIPTION, (Object)group.getDescription()).withInsertParam(SYNCHRO_RULE, (Object)group.getRule()).withInsertParam(CREATION_DATE, (Object)now).withInsertParam(SAVE_DATE, (Object)now).withInsertParam(STATE, (Object)group.getState()).withInsertParam(STATE_SAVE_DATE, (Object)now).executeWith(connection);
        return String.valueOf(nextId);
    }

    public Optional<GroupDetail> restoreGroup(Connection connection, GroupDetail group) throws SQLException {
        Date now = new Date();
        Instant nowI = now.toInstant();
        GroupDetail restored = null;
        long nbRestored = JdbcSqlQuery.update((String)GROUP_TABLE).withUpdateParam(STATE, (Object)GroupState.VALID).withUpdateParam(STATE_SAVE_DATE, (Object)nowI).withUpdateParam(SAVE_DATE, (Object)nowI).where(ID_CRITERION, new Object[]{Integer.parseInt(group.getId())}).and(STATE, new Object[0]).in(new Object[]{GroupState.REMOVED}).executeWith(connection);
        if (nbRestored > 0L) {
            this.groupCache.clearCache();
            restored = new GroupDetail(group);
            restored.setSaveDate(now);
            restored.setState(GroupState.VALID);
            restored.setStateSaveDate(now);
        }
        return Optional.ofNullable(restored);
    }

    public Optional<GroupDetail> removeGroup(Connection connection, GroupDetail group) throws SQLException {
        Date now = new Date();
        Instant nowI = now.toInstant();
        GroupDetail removed = null;
        long nbRemoved = JdbcSqlQuery.update((String)GROUP_TABLE).withUpdateParam(STATE, (Object)GroupState.REMOVED).withUpdateParam(STATE_SAVE_DATE, (Object)nowI).withUpdateParam(SAVE_DATE, (Object)nowI).where(ID_CRITERION, new Object[]{Integer.parseInt(group.getId())}).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).executeWith(connection);
        if (nbRemoved > 0L) {
            this.groupCache.clearCache();
            removed = new GroupDetail(group);
            removed.setSaveDate(now);
            removed.setState(GroupState.REMOVED);
            removed.setStateSaveDate(now);
        }
        return Optional.ofNullable(removed);
    }

    public long deleteGroup(Connection connection, GroupDetail group) throws SQLException {
        long nbDeleted = JdbcSqlQuery.deleteFrom((String)GROUP_TABLE).where(ID_CRITERION, new Object[]{Integer.parseInt(group.getId())}).executeWith(connection);
        if (nbDeleted > 0L) {
            this.groupCache.clearCache();
        }
        return nbDeleted;
    }

    public List<GroupDetail> getRemovedGroups(Connection connection, String ... domainIds) throws SQLException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(domainIds);
        JdbcSqlQuery query = JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(STATE_CRITERION, new Object[]{GroupState.REMOVED});
        List requestedDomainIds = Stream.of(domainIds).map(Integer::parseInt).collect(Collectors.toList());
        if (!requestedDomainIds.isEmpty()) {
            query.and(DOMAIN_ID, new Object[0]).in(requestedDomainIds);
        }
        return query.executeWith(connection, GroupDAO::fetchGroup);
    }

    public void addUserInGroup(Connection connection, String userId, String groupId) throws SQLException {
        this.checkUserExistence(connection, userId);
        this.checkGroupExistence(connection, groupId);
        JdbcSqlQuery.insertInto((String)GROUP_USERS_TABLE).withInsertParam(GROUP_ID, (Object)Integer.parseInt(groupId)).withInsertParam(USER_ID, (Object)Integer.parseInt(userId)).executeWith(connection);
        this.groupCache.removeCacheOfUser(userId);
    }

    public void addUsersInGroup(Connection connection, List<String> userIds, String groupId) throws SQLException {
        this.checkGroupExistence(connection, groupId);
        for (String userId : userIds) {
            this.checkUserExistence(connection, userId);
            JdbcSqlQuery.insertInto((String)GROUP_USERS_TABLE).withInsertParam(GROUP_ID, (Object)Integer.parseInt(groupId)).withInsertParam(USER_ID, (Object)Integer.parseInt(userId)).executeWith(connection);
            this.groupCache.removeCacheOfUser(userId);
        }
    }

    private void checkGroupExistence(Connection connection, String groupId) throws SQLException {
        if (this.getGroup(connection, groupId) == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"group", (Object)groupId));
        }
    }

    private void checkUserExistence(Connection connection, String userId) throws SQLException {
        UserDAO userDAO = (UserDAO)ServiceProvider.getService(UserDAO.class, (Annotation[])new Annotation[0]);
        if (!userDAO.isUserByIdExists(connection, userId)) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"user", (Object)userId));
        }
    }

    public void updateGroup(Connection connection, GroupDetail group) throws SQLException {
        Instant now = new Date().toInstant();
        Integer superGroupId = this.checkSuperGroup(connection, group);
        String specificId = StringUtil.isDefined((String)group.getSpecificId()) ? group.getSpecificId() : group.getId();
        JdbcSqlQuery.update((String)GROUP_TABLE).withUpdateParam(SPECIFIC_ID, (Object)specificId).withUpdateParam(DOMAIN_ID, (Object)this.getDomainIdOf(group)).withUpdateParam(SUPER_GROUP_ID, (Object)superGroupId).withUpdateParam(NAME, (Object)group.getName()).withUpdateParam(DESCRIPTION, (Object)group.getDescription()).withUpdateParam(SYNCHRO_RULE, (Object)(StringUtil.isDefined((String)group.getRule()) ? group.getRule() : null)).withUpdateParam(SAVE_DATE, (Object)now).withUpdateParam(STATE, (Object)group.getState()).withUpdateParam(STATE_SAVE_DATE, (Object)this.toInstant(group.getStateSaveDate())).where(ID_CRITERION, new Object[]{Integer.parseInt(group.getId())}).executeWith(connection);
    }

    private Integer checkSuperGroup(Connection connection, GroupDetail group) throws SQLException {
        Integer superGroupId = null;
        if (StringUtil.isDefined((String)group.getSuperGroupId()) && (superGroupId = Integer.valueOf(Integer.parseInt(group.getSuperGroupId()))) >= 0 && this.getGroup(connection, group.getSuperGroupId()) == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"parent group", (Object)superGroupId));
        }
        return superGroupId;
    }

    public void deleteUserInGroup(Connection connection, String userId, String groupdId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)GROUP_USERS_TABLE).where("userId = ?", new Object[]{Integer.parseInt(userId)}).and(GROUP_ID_CRITERION, new Object[]{Integer.parseInt(groupdId)}).executeWith(connection);
        this.groupCache.removeCacheOfUser(userId);
    }

    public boolean isGroupByNameExists(Connection connection, String name) throws SQLException {
        return (Integer)JdbcSqlQuery.select((String)"COUNT(id)").from(new String[]{GROUP_TABLE}).where("name like ?", new Object[]{name}).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).executeUniqueWith(connection, rs -> rs.getInt(1)) > 0;
    }

    public List<GroupDetail> getAllGroups(Connection connection) throws SQLException {
        return JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).andNull(SPACE_ID).orderBy(new String[]{NAME}).executeWith(connection, GroupDAO::fetchGroup);
    }

    public List<GroupDetail> getAllRootGroups(Connection connection) throws SQLException {
        return JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where("superGroupId is null", new Object[0]).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).andNull(SPACE_ID).orderBy(new String[]{NAME}).executeWith(connection, GroupDAO::fetchGroup);
    }

    public List<GroupDetail> getAllRootGroupsByDomainId(Connection connection, String domainId) throws SQLException {
        return JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and("superGroupId is null", new Object[0]).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).orderBy(new String[]{NAME}).executeWith(connection, GroupDAO::fetchGroup);
    }

    public List<GroupDetail> getAllGroupsByDomainId(Connection connection, String domainId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.orderBy(new String[]{NAME}).executeWith(connection, GroupDAO::fetchGroup);
    }

    public GroupDetail getSuperGroup(Connection connection, String groupId) throws SQLException {
        return (GroupDetail)JdbcSqlQuery.select((String)MessageFormat.format(GROUP_COLUMNS_PATTERN, "sg.")).from(new String[]{"ST_Group sg", "ST_Group g"}).where("sg.id = g.superGroupId", new Object[0]).and("g.id = ?", new Object[]{Integer.parseInt(groupId)}).executeUniqueWith(connection, GroupDAO::fetchGroup);
    }

    public ListSlice<GroupDetail> getGroupsByCriteria(Connection connection, GroupsSearchCriteria criteria, boolean orderByType) throws SQLException {
        return new SqlGroupSelectorByCriteriaBuilder(SEARCH_GROUP_COLUMNS).setOrderingByType(orderByType).build(criteria).executeWith(connection, GroupDAO::fetchGroup);
    }

    public Map<String, Set<String>> getRolesByGroupsMappingWith(Connection connection, List<String> groupIds, String[] profileIds) throws SQLException {
        HashMap<String, Set<String>> rolesByGroup = new HashMap<String, Set<String>>(groupIds.size());
        JdbcSqlQuery.executeBySplittingOn(groupIds, (idBatch, ignore) -> JdbcSqlQuery.select((String)"urgr.groupid, ur.rolename").from(new String[]{"st_userrole_group_rel urgr"}).join("st_userrole ur").on("ur.id = urgr.userroleid", new Object[0]).where("urgr.groupid", new Object[0]).in((Collection)idBatch.stream().map(Integer::parseInt).collect(Collectors.toList())).and("ur.id", new Object[0]).in((Collection)Stream.of(profileIds).map(Integer::parseInt).collect(Collectors.toList())).executeWith(connection, r -> {
            String groupId = Integer.toString(r.getInt(1));
            Set roles = rolesByGroup.computeIfAbsent(groupId, k -> new HashSet());
            roles.add(r.getString(2));
            return null;
        }));
        return rolesByGroup;
    }

    public GroupDetail getGroupBySpecificId(Connection connection, String domainId, String specificId) throws SQLException {
        return (GroupDetail)JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(DOMAIN_ID_CRITERION, new Object[]{Integer.parseInt(domainId)}).and("specificId = ?", new Object[]{specificId}).executeUniqueWith(connection, GroupDAO::fetchGroup);
    }

    public GroupDetail getGroup(Connection con, String groupId) throws SQLException {
        return (GroupDetail)JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where(ID_CRITERION, new Object[]{Integer.parseInt(groupId)}).executeUniqueWith(con, GroupDAO::fetchGroup);
    }

    public List<GroupDetail> getDirectSubGroups(Connection con, String groupId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where("superGroupId = ?", new Object[]{Integer.parseInt(groupId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.executeWith(con, GroupDAO::fetchGroup);
    }

    public List<String> getManageableGroupIds(Connection con, String userId, List<String> groupIds) throws SQLException {
        ArrayList<String> manageableGroupIds = new ArrayList<String>();
        if (StringUtil.isDefined((String)userId)) {
            manageableGroupIds.addAll(this.getManageableGroupIdsByUser(con, userId));
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            manageableGroupIds.addAll(this.getManageableGroupIdsByGroups(con, groupIds));
        }
        return manageableGroupIds;
    }

    public List<GroupDetail> getSynchronizedGroups(Connection connection) throws SQLException {
        return JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE}).where("synchroRule is not null", new Object[0]).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).executeWith(connection, GroupDAO::fetchGroup);
    }

    public List<GroupDetail> getDirectGroupsOfUser(Connection connection, String userId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)GROUP_COLUMNS).from(new String[]{GROUP_TABLE, GROUP_USERS_TABLE}).where("id = groupId", new Object[0]).and("userId = ?", new Object[]{Integer.parseInt(userId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.executeWith(connection, GroupDAO::fetchGroup);
    }

    public List<String> getDirectGroupIdsByUserRole(Connection connection, String userRoleId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"id").from(new String[]{GROUP_TABLE, USER_ROLE_GROUPS_TABLE}).where("id = groupid", new Object[0]).and("userroleid = ?", new Object[]{Integer.parseInt(userRoleId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.executeWith(connection, rs -> String.valueOf(rs.getInt(1)));
    }

    public List<String> getDirectGroupIdsBySpaceUserRole(Connection connection, String spaceUserRoleId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"id").from(new String[]{GROUP_TABLE, SPACE_ROLE_GROUP}).where("groupId = id", new Object[0]).and("spaceUserRoleId = ?", new Object[]{Integer.parseInt(spaceUserRoleId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.executeWith(connection, rs -> String.valueOf(rs.getInt(1)));
    }

    public List<String> getDirectGroupIdsByGroupUserRole(Connection connection, String groupUserRoleId, boolean includeRemoved) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"id").from(new String[]{GROUP_TABLE, GROUP_ROLE_GROUPS_TABLE}).where("id = groupId", new Object[0]).and("groupUserRoleId = ?", new Object[]{Integer.parseInt(groupUserRoleId)});
        if (!includeRemoved) {
            query.and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED});
        }
        return query.executeWith(connection, row -> Integer.toString(row.getInt(1)));
    }

    private List<String> getManageableGroupIdsByUser(Connection con, String userId) throws SQLException {
        return JdbcSqlQuery.select((String)"st_groupuserrole.groupid").from(new String[]{GROUP_ROLE_USERS_TABLE, GROUP_ROLE_TABLE, GROUP_TABLE}).where("st_groupuserrole_user_rel.groupuserroleid = st_groupuserrole.id", new Object[0]).and("ST_Group.id = st_groupuserrole.groupid", new Object[0]).and("st_groupuserrole_user_rel.userId = ?", new Object[]{Integer.parseInt(userId)}).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).executeWith(con, rs -> String.valueOf(rs.getInt(1)));
    }

    private List<String> getManageableGroupIdsByGroups(Connection con, List<String> groupIds) throws SQLException {
        return JdbcSqlQuery.select((String)"st_groupuserrole.groupid").from(new String[]{GROUP_ROLE_GROUPS_TABLE, GROUP_ROLE_TABLE, GROUP_TABLE}).where("st_groupuserrole_group_rel.groupuserroleid = st_groupuserrole.id", new Object[0]).and("ST_Group.id = st_groupuserrole.groupid", new Object[0]).and("st_groupuserrole_group_rel.groupid", new Object[0]).in((Collection)groupIds.stream().map(Integer::parseInt).collect(Collectors.toList())).and(STATE, new Object[0]).notIn(new Object[]{GroupState.REMOVED}).executeWith(con, rs -> String.valueOf(rs.getInt(1)));
    }

    private static GroupDetail fetchGroup(ResultSet rs) throws SQLException {
        int domainId;
        GroupDetail group = new GroupDetail();
        group.setId(Integer.toString(rs.getInt("id")));
        group.setSpecificId(rs.getString(SPECIFIC_ID));
        if ("-1".equals(group.getSpecificId())) {
            group.setSpecificId(null);
        }
        if ((domainId = rs.getInt(DOMAIN_ID)) != -1) {
            group.setDomainId(Integer.toString(domainId));
        }
        group.setSuperGroupId(Integer.toString(rs.getInt(SUPER_GROUP_ID)));
        if (rs.wasNull()) {
            group.setSuperGroupId(null);
        }
        group.setName(rs.getString(NAME));
        group.setDescription(rs.getString(DESCRIPTION));
        group.setSpaceId(rs.getString(SPACE_ID));
        group.setRule(rs.getString(SYNCHRO_RULE));
        group.setCreationDate(rs.getTimestamp(CREATION_DATE));
        group.setSaveDate(rs.getTimestamp(SAVE_DATE));
        group.setState(GroupState.from((String)rs.getString(STATE)));
        group.setStateSaveDate(rs.getTimestamp(STATE_SAVE_DATE));
        return group;
    }

    private int getDomainIdOf(GroupDetail group) {
        String domainId = group.getDomainId();
        if (StringUtil.isNotDefined((String)domainId)) {
            return -1;
        }
        return Integer.parseInt(domainId);
    }

    private Instant toInstant(Date aDate) {
        return aDate == null ? null : aDate.toInstant();
    }
}

