/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceI18NRow;
import org.silverpeas.core.admin.persistence.SpaceRow;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.ComponentInstManager;
import org.silverpeas.core.admin.service.cache.TreeCache;
import org.silverpeas.core.admin.space.SpaceI18N;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.space.SpaceProfileInstManager;
import org.silverpeas.core.admin.space.dao.SpaceDAO;
import org.silverpeas.core.admin.space.notification.SpaceEventNotifier;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class SpaceInstManager {
    public static final String SPACE = "space";
    @Inject
    private ComponentInstManager componentInstManager;
    @Inject
    private SpaceProfileInstManager spaceProfileInstManager;
    @Inject
    private SpaceEventNotifier notifier;
    @Inject
    private OrganizationSchema organizationSchema;
    @Inject
    private TreeCache treeCache;
    @Inject
    private SpaceDAO spaceDAO;

    protected SpaceInstManager() {
    }

    public SpaceInst copy(SpaceInst spaceInstToCopy) {
        if (spaceInstToCopy == null) {
            return null;
        }
        SpaceInst spaceInst = new SpaceInst();
        spaceInst.setLevel(spaceInstToCopy.getLevel());
        spaceInst.setLocalId(spaceInstToCopy.getLocalId());
        spaceInst.setDomainFatherId(spaceInstToCopy.getDomainFatherId());
        spaceInst.setName(spaceInstToCopy.getName());
        spaceInst.setDescription(spaceInstToCopy.getDescription());
        spaceInst.setCreatorUserId(spaceInstToCopy.getCreatorUserId());
        spaceInst.setFirstPageType(spaceInstToCopy.getFirstPageType());
        spaceInst.setFirstPageExtraParam(spaceInstToCopy.getFirstPageExtraParam());
        spaceInst.setOrderNum(spaceInstToCopy.getOrderNum());
        spaceInst.setCreationDate(spaceInstToCopy.getCreationDate());
        spaceInst.setLastUpdate(spaceInstToCopy.getLastUpdateDate());
        spaceInst.setRemovalDate(spaceInstToCopy.getRemovalDate());
        spaceInst.setStatus(spaceInstToCopy.getStatus());
        spaceInst.setUpdaterUserId(spaceInstToCopy.getUpdaterUserId());
        spaceInst.setRemoverUserId(spaceInstToCopy.getRemoverUserId());
        spaceInst.setInheritanceBlocked(spaceInstToCopy.isInheritanceBlocked());
        spaceInst.setLook(spaceInstToCopy.getLook());
        spaceInst.setCommunitySpace(spaceInstToCopy.isCommunitySpace());
        spaceInst.copyDataFrom(spaceInstToCopy);
        spaceInst.setLanguage(spaceInstToCopy.getLanguage());
        for (SpaceI18N translation : spaceInstToCopy.getTranslations().values()) {
            spaceInst.addTranslation(translation);
        }
        spaceInst.setDisplaySpaceFirst(spaceInstToCopy.isDisplaySpaceFirst());
        spaceInst.setPersonalSpace(spaceInstToCopy.isPersonalSpace());
        return spaceInst;
    }

    public void createSpaceInst(SpaceInst spaceInst) throws AdminException {
        try {
            this.checkSpaceIsValid(spaceInst);
            SpaceRow newSpaceRow = this.makeSpaceRow(spaceInst);
            this.organizationSchema.space().createSpace(newSpaceRow);
            spaceInst.setLocalId(newSpaceRow.id);
            this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, new SpaceInst[]{spaceInst});
            Map translations = spaceInst.getTranslations();
            for (Map.Entry lang : translations.entrySet()) {
                if (lang.getKey().equals(newSpaceRow.lang)) continue;
                SpaceI18N translation = (SpaceI18N)lang.getValue();
                SpaceI18NRow row = new SpaceI18NRow(newSpaceRow.id, lang.getKey(), translation.getName(), translation.getDescription());
                this.organizationSchema.spaceI18N().createTranslation(row);
            }
            for (SpaceProfileInst spaceProfileInst : spaceInst.getAllSpaceProfilesInst()) {
                this.spaceProfileInstManager.createSpaceProfileInst(spaceProfileInst, spaceInst.getLocalId());
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)SPACE, (Object)spaceInst.getName()), e);
        }
    }

    public SpaceInst getSpaceInstById(int spaceInstLocalId) throws AdminException {
        try {
            SpaceRow space = this.organizationSchema.space().getSpace(spaceInstLocalId);
            if (space == null) {
                SilverLogger.getLogger((Object)this).error("Space {0} not found", new Object[]{spaceInstLocalId});
                return null;
            }
            SpaceInst spaceInst = this.spaceRow2SpaceInst(space);
            spaceInst.setLanguage(space.lang);
            SpaceI18N translation = new SpaceI18N(space.lang, space.name, space.description);
            spaceInst.addTranslation(translation);
            List<SpaceI18NRow> translations = this.organizationSchema.spaceI18N().getTranslations(spaceInstLocalId);
            for (int t = 0; translations != null && t < translations.size(); ++t) {
                SpaceI18NRow row = translations.get(t);
                spaceInst.addTranslation(new SpaceI18N(row));
            }
            return spaceInst;
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)String.valueOf(spaceInstLocalId)), e);
        }
    }

    public void loadSpaceInstData(SpaceInst spaceInst) throws AdminException {
        int spaceInstLocalId = spaceInst.getLocalId();
        try {
            List<String> subSpaceIds = this.organizationSchema.space().getDirectSubSpaces(spaceInstLocalId).stream().map(this::spaceRow2SpaceInst).map(SpaceInst::getId).collect(Collectors.toList());
            String[] asCompoIds = this.organizationSchema.instance().getAllComponentInstanceIdsInSpace(spaceInstLocalId);
            ArrayList<String> componentIds = new ArrayList<String>(asCompoIds.length);
            for (String componentId : asCompoIds) {
                ComponentInst componentInst = this.componentInstManager.getComponentInst(this.idAsInt(componentId));
                WAComponent.getByName(componentInst.getName()).ifPresent(waComponent -> componentIds.add(componentInst.getId()));
            }
            String[] asProfIds = this.organizationSchema.spaceUserRole().getAllSpaceUserRoleIdsOfSpace(spaceInstLocalId);
            ArrayList<SpaceProfileInst> spaceProfiles = new ArrayList<SpaceProfileInst>(asProfIds.length);
            for (String profileId : asProfIds) {
                SpaceProfileInst spaceProfileInst = this.spaceProfileInstManager.getSpaceProfileInst(profileId, false);
                spaceProfiles.add(spaceProfileInst);
            }
            spaceInst.setData(spaceProfiles, subSpaceIds, componentIds);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)String.valueOf(spaceInstLocalId)), e);
        }
    }

    public SpaceInst getPersonalSpace(String userId) throws AdminException {
        try {
            SpaceRow space = this.organizationSchema.space().getPersonalSpace(userId);
            if (space != null) {
                SpaceInst spaceInst = this.spaceRow2SpaceInst(space);
                spaceInst.setLanguage(space.lang);
                return spaceInst;
            }
            return null;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"personal space of user", (Object)userId), e);
        }
    }

    private SpaceInst spaceRow2SpaceInst(SpaceRow space) {
        SpaceInst spaceInst = new SpaceInst();
        spaceInst.setLocalId(space.id);
        spaceInst.setDomainFatherId(SpaceInstManager.idAsString(space.domainFatherId));
        int spaceLevel = spaceInst.isRoot() ? 0 : this.getSpaceLevel(space.domainFatherId) + 1;
        spaceInst.setLevel(spaceLevel);
        spaceInst.setName(space.name);
        spaceInst.setDescription(space.description);
        spaceInst.setCreatorUserId(SpaceInstManager.idAsString(space.createdBy));
        spaceInst.setFirstPageType(space.firstPageType);
        spaceInst.setFirstPageExtraParam(space.firstPageExtraParam);
        spaceInst.setOrderNum(space.orderNum);
        if (space.createTime != null) {
            spaceInst.setCreationDate(new Date(Long.parseLong(space.createTime)));
        }
        if (space.updateTime != null) {
            spaceInst.setLastUpdate(new Date(Long.parseLong(space.updateTime)));
        }
        if (space.removeTime != null) {
            spaceInst.setRemovalDate(new Date(Long.parseLong(space.removeTime)));
        }
        spaceInst.setUpdaterUserId(SpaceInstManager.idAsString(space.updatedBy));
        spaceInst.setRemoverUserId(SpaceInstManager.idAsString(space.removedBy));
        spaceInst.setStatus(space.status);
        spaceInst.setInheritanceBlocked(space.inheritanceBlocked == 1);
        spaceInst.setLook(space.look);
        spaceInst.setDisplaySpaceFirst(space.displaySpaceFirst == 1);
        spaceInst.setPersonalSpace(space.isPersonalSpace == 1);
        spaceInst.setCommunitySpace(space.isCommunitySpace == 1);
        return spaceInst;
    }

    public SpaceInstLight getSpaceInstLightById(int spaceLocalId) throws AdminException {
        try {
            SpaceRow spaceRow = this.organizationSchema.space().getSpace(spaceLocalId);
            if (spaceRow == null) {
                return null;
            }
            SpaceInstLight spaceInstLight = new SpaceInstLight(spaceRow);
            spaceInstLight.setLevel(this.getSpaceLevel(spaceRow.id));
            this.setTranslations(spaceInstLight, spaceRow);
            return spaceInstLight;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)String.valueOf(spaceLocalId)), e);
        }
    }

    public void updateSpaceOrder(int spaceLocalId, int orderNum) throws AdminException {
        try {
            this.organizationSchema.space().updateSpaceOrder(spaceLocalId, orderNum);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"order of space", (Object)String.valueOf(spaceLocalId)), e);
        }
    }

    private int getSpaceLevel(int spaceId) {
        return this.treeCache.getSpaceLevel(spaceId);
    }

    public String[] getAllRootSpaceIds() throws AdminException {
        try {
            String[] asSpaceIds = this.organizationSchema.space().getAllRootSpaceIds();
            if (asSpaceIds != null) {
                return asSpaceIds;
            }
            return ArrayUtil.emptyStringArray();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all root spaces", (Object)""), e);
        }
    }

    public String[] getAllSpaceIds() throws AdminException {
        try {
            String[] asSpaceIds = this.organizationSchema.space().getAllSpaceIds();
            if (asSpaceIds != null) {
                return asSpaceIds;
            }
            return ArrayUtil.emptyStringArray();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all spaces", (Object)""), e);
        }
    }

    public List<SpaceInstLight> getRemovedSpaces() throws AdminException {
        try {
            SpaceRow[] spaceRows = this.organizationSchema.space().getRemovedSpaces();
            return this.spaceRows2SpaceInstLights(spaceRows);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"removed spaces", (Object)""), e);
        }
    }

    public List<SpaceInstLight> getSubSpaces(int spaceLocalId) throws AdminException {
        try {
            List<SpaceRow> rows = this.organizationSchema.space().getDirectSubSpaces(spaceLocalId);
            return this.spaceRows2SpaceInstLights(rows.toArray(new SpaceRow[0]));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"subspaces of space", (Object)String.valueOf(spaceLocalId)), e);
        }
    }

    private void setTranslations(SpaceInstLight space, SpaceRow row) {
        try {
            space.setLanguage(row.lang);
            SpaceI18N translation = new SpaceI18N(row.lang, row.name, row.description);
            space.addTranslation(translation);
            if (I18NHelper.isI18nContentActivated) {
                List<SpaceI18NRow> translations = this.organizationSchema.spaceI18N().getTranslations(row.id);
                for (int t = 0; translations != null && t < translations.size(); ++t) {
                    SpaceI18NRow i18nRow = translations.get(t);
                    space.addTranslation(new SpaceI18N(i18nRow));
                }
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private List<SpaceInstLight> spaceRows2SpaceInstLights(SpaceRow[] spaceRows) {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        if (spaceRows == null) {
            return spaces;
        }
        for (SpaceRow row : spaceRows) {
            SpaceInstLight spaceLight = new SpaceInstLight(row);
            this.setTranslations(spaceLight, row);
            spaces.add(spaceLight);
        }
        return spaces;
    }

    public String[] getAllSubSpaceIds(int sDomainFatherId) throws AdminException {
        try {
            String[] asSpaceIds = this.organizationSchema.space().getDirectSubSpaceIds(sDomainFatherId);
            if (asSpaceIds != null) {
                return asSpaceIds;
            }
            return ArrayUtil.emptyStringArray();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all subspaces of space", (Object)String.valueOf(sDomainFatherId)), e);
        }
    }

    public void deleteSpaceInst(SpaceInst spaceInst) throws AdminException {
        try {
            this.organizationSchema.spaceI18N().removeTranslations(spaceInst.getLocalId());
            this.organizationSchema.space().removeSpace(spaceInst.getLocalId());
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, new SpaceInst[]{spaceInst});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)SPACE, (Object)spaceInst.getId()), e);
        }
    }

    public void sendSpaceToBasket(SpaceInst spaceInst, String userId) throws AdminException {
        boolean nameOK = false;
        int retry = 0;
        String deletedSpaceName = null;
        while (!nameOK) {
            boolean spaceAlreadyExists;
            String spaceName = spaceInst.getName() + " (Restaur\u00e9)";
            if (retry > 0) {
                spaceName = spaceName + " " + retry;
            }
            try {
                spaceAlreadyExists = this.organizationSchema.space().isSpaceIntoBasket(this.idAsInt(spaceInst.getDomainFatherId()), spaceName);
            }
            catch (SQLException e) {
                throw new AdminException(e.getMessage(), e);
            }
            nameOK = !spaceAlreadyExists;
            deletedSpaceName = spaceName;
            ++retry;
        }
        try {
            this.organizationSchema.space().sendSpaceToBasket(spaceInst.getLocalId(), deletedSpaceName, userId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnMoving((String)SPACE, (Object)spaceInst.getId(), (String)"bin", (Object)""), e);
        }
    }

    public void removeSpaceFromBasket(int spaceLocalId) throws AdminException {
        try {
            this.organizationSchema.space().removeSpaceFromBasket(spaceLocalId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)SPACE, (Object)String.valueOf(spaceLocalId)), e);
        }
    }

    public void moveSpace(int spaceId, int fatherId) throws AdminException {
        try {
            this.organizationSchema.space().moveSpace(spaceId, fatherId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnMoving((String)SPACE, (Object)String.valueOf(spaceId), (String)SPACE, (Object)String.valueOf(fatherId)), e);
        }
    }

    public void updateSpaceInst(SpaceInst spaceInstNew) throws AdminException {
        try {
            this.checkSpaceIsValid(spaceInstNew);
            SpaceRow changedSpace = this.makeSpaceRow(spaceInstNew);
            changedSpace.id = spaceInstNew.getLocalId();
            SpaceRow oldSpace = this.organizationSchema.space().getSpace(changedSpace.id);
            if (spaceInstNew.isRemoveTranslation()) {
                this.removeTranslation(spaceInstNew, changedSpace, oldSpace);
            } else {
                this.updateTranslation(spaceInstNew, changedSpace, oldSpace);
                this.organizationSchema.space().updateSpace(changedSpace);
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE, (Object)String.valueOf(spaceInstNew.getLocalId())), e);
        }
    }

    private void updateTranslation(SpaceInst spaceInstNew, SpaceRow changedSpace, SpaceRow oldSpace) throws SQLException {
        if (changedSpace.lang != null) {
            if (oldSpace.lang == null) {
                oldSpace.lang = I18NHelper.DEFAULT_LANGUAGE;
            }
            if (!oldSpace.lang.equalsIgnoreCase(changedSpace.lang)) {
                SpaceI18NRow row = new SpaceI18NRow(changedSpace);
                String translationId = spaceInstNew.getTranslationId();
                if (translationId != null && !translationId.equals("-1")) {
                    row.setId(Integer.parseInt(spaceInstNew.getTranslationId()));
                    this.organizationSchema.spaceI18N().updateTranslation(row);
                } else {
                    this.organizationSchema.spaceI18N().createTranslation(row);
                }
                changedSpace.lang = oldSpace.lang;
                changedSpace.name = oldSpace.name;
                changedSpace.description = oldSpace.description;
            }
        }
    }

    private void removeTranslation(SpaceInst spaceInstNew, SpaceRow changedSpace, SpaceRow oldSpace) throws SQLException {
        if (oldSpace.lang.equalsIgnoreCase(spaceInstNew.getLanguage())) {
            List<SpaceI18NRow> translations = this.organizationSchema.spaceI18N().getTranslations(changedSpace.id);
            if (translations != null && !translations.isEmpty()) {
                SpaceI18NRow translation = translations.get(0);
                changedSpace.lang = translation.getLang();
                changedSpace.name = translation.getName();
                changedSpace.description = translation.getDescription();
                this.organizationSchema.space().updateSpace(changedSpace);
                this.organizationSchema.spaceI18N().removeTranslation(translation.getId());
            }
        } else {
            this.organizationSchema.spaceI18N().removeTranslation(Integer.parseInt(spaceInstNew.getTranslationId()));
        }
    }

    private void checkSpaceIsValid(SpaceInst spaceInst) throws AdminException {
        if (StringUtil.isNotDefined((String)spaceInst.getName())) {
            throw new AdminException("The space name is empty", new String[0]);
        }
    }

    public List<SpaceInstLight> getAllSpaces() throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        try {
            SpaceRow[] spaceRows = this.organizationSchema.space().getAllSpaces();
            spaces.addAll(this.spaceRows2SpaceInstLights(spaceRows));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all spaces", (Object)""), e);
        }
        return spaces;
    }

    public List<Integer> getManageableSpaceIds(String userId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<Integer> list = this.spaceDAO.getManageableSpaceIds(con, userId, groupIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all spaces manageable by user", (Object)userId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private SpaceRow makeSpaceRow(SpaceInst spaceInst) {
        SpaceRow space = new SpaceRow();
        space.id = spaceInst.getLocalId();
        space.domainFatherId = this.idAsInt(spaceInst.getDomainFatherId());
        space.name = spaceInst.getName();
        space.description = spaceInst.getDescription();
        space.createdBy = this.idAsInt(spaceInst.getCreatorUserId());
        space.firstPageType = spaceInst.getFirstPageType();
        space.firstPageExtraParam = spaceInst.getFirstPageExtraParam();
        space.orderNum = spaceInst.getOrderNum();
        space.updatedBy = this.idAsInt(spaceInst.getUpdaterUserId());
        space.lang = spaceInst.getLanguage();
        space.look = spaceInst.getLook();
        space.inheritanceBlocked = spaceInst.isInheritanceBlocked() ? 1 : 0;
        space.displaySpaceFirst = spaceInst.isDisplaySpaceFirst() ? 1 : 0;
        space.isPersonalSpace = spaceInst.isPersonalSpace() ? 1 : 0;
        space.isCommunitySpace = spaceInst.isCommunitySpace() ? 1 : 0;
        return space;
    }

    private int idAsInt(String id) {
        if (id == null || id.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return String.valueOf(id);
    }
}

