/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.model.CompoSpace;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.ComponentSearchCriteria;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.service.UserSpaceAvailabilityChecker;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.util.Pair;

public interface OrganizationController {
    public static OrganizationController get() {
        return (OrganizationController)ServiceProvider.getService(OrganizationController.class, (Annotation[])new Annotation[0]);
    }

    public String[] getAllSpaceIds();

    public String[] getAllSubSpaceIds(String var1);

    public String[] getSpaceNames(String[] var1);

    public SpaceInstLight getSpaceInstLightById(String var1);

    public SpaceInst getSpaceInstById(String var1);

    public String[] getAvailCompoIds(String var1, String var2);

    public String[] getAvailCompoIds(String var1);

    public String[] getAvailCompoIdsAtRoot(String var1, String var2);

    public CompoSpace[] getCompoForUser(String var1, String var2);

    public List<ComponentInstLight> getAvailComponentInstLights(String var1, String var2);

    public String[] getComponentIdsForUser(String var1, String var2);

    public String[] getCompoId(String var1);

    public String getComponentParameterValue(String var1, String var2);

    public List<ComponentInstLight> getComponentsWithParameterValue(String var1, String var2);

    public Map<String, Map<String, String>> getParameterValuesByComponentIdThenByParamName(Collection<String> var1, Collection<String> var2);

    public Optional<SilverpeasComponentInstance> getComponentInstance(String var1);

    public ComponentInst getComponentInst(String var1);

    public ComponentInstLight getComponentInstLight(String var1);

    public UserFull getUserFull(String var1);

    public List<UserFull> getUserFulls(Collection<String> var1);

    public <T extends User> T getUserDetail(String var1);

    public <T extends User> T[] getUserDetails(String[] var1);

    public <T extends User> T[] getAllUsers(String var1);

    public <T extends User> T[] getAllUsersInDomain(String var1);

    public <T extends User> SilverpeasList<T> searchUsers(UserDetailsSearchCriteria var1);

    public <T extends Group> T[] getAllRootGroupsInDomain(String var1);

    public <T extends User> T[] getFilteredDirectUsers(String var1, String var2);

    public <T extends Group> SilverpeasList<T> searchGroups(GroupsSearchCriteria var1, boolean var2);

    public int getAllSubUsersNumber(String var1);

    public <T extends Group> T[] getAllSubGroups(String var1);

    public <T extends Group> T[] getRecursivelyAllSubgroups(String var1);

    public <T extends User> T[] getAllUsers();

    public <T extends User> T[] getUsers(String var1, String var2);

    public Collection<SilverpeasRole> getUserSilverpeasRolesOn(User var1, String var2);

    public String[] getUserProfiles(String var1, String var2);

    public Map<String, Set<String>> getUserProfilesByComponentId(String var1, Collection<String> var2);

    public List<String> getSpaceUserProfilesBySpaceId(String var1, String var2);

    public Map<String, Set<String>> getSpaceUserProfilesBySpaceIds(String var1, Collection<String> var2);

    public String[] getUserProfiles(String var1, String var2, ProfiledObjectId var3);

    public Map<Pair<String, String>, Set<String>> getUserProfilesByComponentIdAndObjectId(String var1, Collection<String> var2, ProfiledObjectIds var3);

    public Map<String, List<String>> getUserObjectProfiles(String var1, String var2, ProfiledObjectType var3);

    public List<ProfileInst> getUserProfiles(String var1, ProfiledObjectId var2);

    public ProfileInst getUserProfile(String var1);

    public String[] getAdministratorUserIds(String var1);

    public <T extends Group> T getGroup(String var1);

    public <T extends Group> T[] getGroups(String[] var1);

    public <T extends Group> T[] getAllGroups();

    public <T extends Group> T[] getAllRootGroups();

    public <T extends User> T[] getAllUsersOfGroup(String var1);

    public List<String> getPathToGroup(String var1);

    public String[] getAllSpaceIds(String var1);

    public String[] getUserManageableSpaceIds(String var1);

    public String[] getAllRootSpaceIds();

    public String[] getAllRootSpaceIds(String var1);

    public String[] getAllSubSpaceIds(String var1, String var2);

    public String[] getAllComponentIds(String var1);

    public String[] getAllComponentIdsRecur(String var1);

    public List<SpaceInstLight> getRootSpacesContainingComponent(String var1, String var2);

    public List<SpaceInstLight> getSubSpacesContainingComponent(String var1, String var2, String var3);

    public boolean isToolAvailable(String var1);

    public List<String> getAvailableComponentsByUser(String var1);

    public boolean isComponentAvailableToUser(String var1, String var2);

    public boolean isComponentAvailableToGroup(String var1, String var2);

    public boolean isComponentExist(String var1);

    public boolean isComponentManageable(String var1, String var2);

    public boolean isSpaceAvailable(String var1, String var2);

    public UserSpaceAvailabilityChecker getUserSpaceAvailabilityChecker(String var1);

    public boolean isObjectAvailableToUser(ProfiledObjectId var1, String var2, String var3);

    public boolean isObjectAvailableToGroup(ProfiledObjectId var1, String var2, String var3);

    public List<SpaceInstLight> getSpaceTreeview(String var1);

    public String[] getAllowedSubSpaceIds(String var1, String var2);

    public SpaceInstLight getRootSpace(String var1);

    public String[] getAllUsersIds();

    public String[] getUsersIdsByRoleNames(String var1, List<String> var2);

    public String[] getUsersIdsByRoleNames(String var1, List<String> var2, boolean var3);

    public String[] getUsersIdsByRoleNames(String var1, ProfiledObjectId var2, List<String> var3);

    public String[] getUsersIdsByRoleNames(String var1, ProfiledObjectId var2, List<String> var3, boolean var4);

    public Domain getDomain(String var1);

    public Domain[] getAllDomains();

    public List<GroupDetail> getDirectGroupsOfUser(String var1);

    public String[] getAllGroupIdsOfUser(String var1);

    public String[] getAllowedComponentIds(String var1);

    public <T extends User> List<T> getUsersOfDomainsFromNewestToOldest(List<String> var1);

    public <T extends User> List<T> getUsersOfDomains(List<String> var1);

    public boolean isAdminTool(String var1);

    public List<String> getSearchableComponentsByCriteria(ComponentSearchCriteria var1);

    public SpaceProfile getSpaceProfile(String var1, SilverpeasRole var2);

    public SpaceWithSubSpacesAndComponents getFullTreeview() throws AdminException;

    public SpaceWithSubSpacesAndComponents getFullTreeview(String var1) throws AdminException;

    public SpaceWithSubSpacesAndComponents getFullTreeviewOnComponentName(String var1, String var2) throws AdminException;

    public SpaceWithSubSpacesAndComponents getFullTreeview(String var1, String var2) throws AdminException;

    @NonNull
    public List<SpaceInstLight> getPathToSpace(@NonNull String var1);

    public List<SpaceInstLight> getPathToComponent(String var1);
}

