/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.RightProfile;
import org.silverpeas.core.admin.component.ApplicationResourcePasting;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.admin.component.WAComponentRegistry;
import org.silverpeas.core.admin.component.model.CompoSpace;
import org.silverpeas.core.admin.component.model.ComponentI18N;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.InheritableSpaceRoles;
import org.silverpeas.core.admin.component.model.LocalizedProfile;
import org.silverpeas.core.admin.component.model.LocalizedWAComponent;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.Profile;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.ToolInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.DomainDriverManager;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSynchroUserItf;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.model.DomainCache;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainScheduler;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupManager;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupReport;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupScheduler;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdminNotFoundException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.ComponentInstManager;
import org.silverpeas.core.admin.service.GroupSynchronizationRule;
import org.silverpeas.core.admin.service.RightAssignationContext;
import org.silverpeas.core.admin.service.SpaceInstManager;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.service.SyncOfGroupsContext;
import org.silverpeas.core.admin.service.SyncOfUsersContext;
import org.silverpeas.core.admin.service.UserSpaceAvailabilityChecker;
import org.silverpeas.core.admin.service.cache.AdminCache;
import org.silverpeas.core.admin.service.cache.TreeCache;
import org.silverpeas.core.admin.space.SpaceI18N;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.space.SpaceProfileInstManager;
import org.silverpeas.core.admin.space.SpaceServiceProvider;
import org.silverpeas.core.admin.space.model.Space;
import org.silverpeas.core.admin.space.notification.SpaceEventNotifier;
import org.silverpeas.core.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.ProfileInstManager;
import org.silverpeas.core.admin.user.ProfiledObjectManager;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupCache;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupProfileInst;
import org.silverpeas.core.admin.user.model.GroupProfileInstManager;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SearchCriteriaVisitor;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.Process;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(rollbackOn={AdminException.class})
class DefaultAdministration
implements Administration {
    private static final String ADMIN_ID = "0";
    private static final String REMOVE_OF = "Suppression de ";
    private static final String INDEX_SPACE_SCOPE = "Spaces";
    private static final String INDEX_COMPONENT_SCOPE = "Components";
    private static final String SPACE = "space";
    private static final String SUBSPACES_OF_SPACE = "subspaces of space ";
    private static final String COMPONENT = "component";
    private static final String PROFILE = "profile";
    private static final String SPACE_PROFILE = "space profile";
    private static final String GROUP = "group";
    private static final String ACCESSIBLE_BY_USER = "accessible by user ";
    private static final String USER = "user ";
    private static final String IN_GROUP = "in group ";
    private static final String GROUP_PROFILE = "group profile";
    private static final String DOMAIN_ID_PARAM = "domainId";
    private static final String LOGIN_PARAM = "login";
    private static final String DOMAIN = "domain";
    private static final String COMPONENTS_IN_SPACE = "components in space ";
    private static final String AVAILABLE_TO_USER = "available to user ";
    private static final String ADMIN_SYNCHRONIZE_GROUP = "admin.synchronizeGroup";
    private static final String ADMIN_SYNCHRONIZE_DOMAIN = "admin.synchronizeSilverpeasWithDomain";
    private static final String ADMIN_SYNCHRONIZE_USERS = "admin.synchronizeUsers";
    private static final String ADMIN_SYNCHRONIZE_GROUPS = "admin.synchronizeGroups";
    private static final String ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS = "admin.checkOutGroups";
    private static final String ID_IS = " (id:";
    private final Object semaphore = new Object();
    private boolean delUsersOnDiffSynchro = true;
    private boolean shouldFallbackGroupNames = true;
    private boolean shouldFallbackUserLogins = false;
    private String groupSynchroCron = "";
    private String domainSynchroCron = "";
    private String senderEmail = null;
    private String senderName = null;
    private SynchroDomainScheduler domainSynchroScheduler = null;
    private AppRoleMappingManager roleMapping = null;
    private boolean useProfileInheritance = false;
    @Inject
    private AdminCache cache;
    @Inject
    private WAComponentRegistry componentRegistry;
    @Inject
    private UserManager userManager;
    @Inject
    private GroupManager groupManager;
    @Inject
    private SpaceInstManager spaceManager;
    @Inject
    private ProfiledObjectManager profiledObjectManager;
    @Inject
    private ProfileInstManager profileManager;
    @Inject
    private GroupProfileInstManager groupProfileManager;
    @Inject
    private ComponentInstManager componentManager;
    @Inject
    private SpaceProfileInstManager spaceProfileManager;
    @Inject
    private SpaceEventNotifier spaceEventNotifier;
    @Inject
    private ContentManagementEngine contentMgtEngine;
    @Inject
    private DomainDriverManager domainDriverManager;
    @Inject
    private DomainCache domainCache;
    @Inject
    private TreeCache treeCache;
    @Inject
    private GroupCache groupCache;
    @Inject
    private SynchroGroupManager synchroGroupManager;
    @Inject
    private Instance<SearchCriteriaVisitor> searchCriteriaVisitors;
    private final Supplier<ComponentInst> nullComponentInstSupplier = () -> {
        try {
            return this.getComponentInst(-1);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            return null;
        }
    };

    private void setup() {
        SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.admin.admin");
        this.roleMapping = new AppRoleMappingManager(this.componentRegistry);
        this.useProfileInheritance = resources.getBoolean("UseProfileInheritance", false);
        this.senderEmail = resources.getString("SenderEmail");
        this.senderName = resources.getString("SenderName");
        this.shouldFallbackGroupNames = resources.getBoolean("FallbackGroupNames", true);
        this.shouldFallbackUserLogins = resources.getBoolean("FallbackUserLogins", false);
        this.domainSynchroCron = resources.getString("DomainSynchroCron", "* 4 * * *");
        this.groupSynchroCron = resources.getString("GroupSynchroCron", "* 5 * * *");
        this.delUsersOnDiffSynchro = resources.getBoolean("DelUsersOnThreadedSynchro", true);
        this.cache.setCacheAvailable(StringUtil.getBooleanValue((String)resources.getString("UseCache", "1")));
    }

    protected DefaultAdministration() {
    }

    @PostConstruct
    private void initialize() {
        this.setup();
        Transaction.performInOne(() -> {
            this.reloadCache();
            return null;
        });
    }

    @Override
    public void reloadCache() {
        this.cache.resetCache();
        this.treeCache.clearCache();
        this.groupCache.clearCache();
        try {
            List<SpaceInstLight> spaces = this.spaceManager.getAllSpaces();
            for (SpaceInstLight space : spaces) {
                this.addSpaceInTreeCache(space, false);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @Override
    public void initSynchronization() {
        ArrayList<String> synchroDomainIds = new ArrayList<String>();
        Domain[] domains = null;
        try {
            domains = this.domainDriverManager.getAllDomains();
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
        if (domains != null) {
            for (Domain domain : domains) {
                try {
                    DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domain.getId());
                    if (synchroDomain == null || !synchroDomain.isSynchroThreaded()) continue;
                    synchroDomainIds.add(domain.getId());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                }
            }
        }
        this.domainSynchroScheduler = new SynchroDomainScheduler();
        this.domainSynchroScheduler.initialize(this.domainSynchroCron, synchroDomainIds);
        this.synchroGroupManager.resetContext();
        new SynchroGroupScheduler().initialize(this.groupSynchroCron);
    }

    private void addSpaceInTreeCache(SpaceInstLight space, boolean addSpaceToSuperSpace) throws AdminException {
        Space spaceInCache = new Space();
        spaceInCache.setSpaceInstLight(space);
        List<ComponentInstLight> components = this.componentManager.getComponentsInSpace(space.getLocalId());
        spaceInCache.setComponents(components);
        List<SpaceInstLight> subSpaces = this.getSubSpaces(space.getId());
        spaceInCache.setSubspaces(subSpaces);
        this.treeCache.addSpace(space.getLocalId(), spaceInCache);
        for (SpaceInstLight subSpace : subSpaces) {
            this.addSpaceInTreeCache(subSpace, false);
        }
        if (addSpaceToSuperSpace && !space.isRoot()) {
            this.treeCache.addSubSpace(Integer.parseInt(space.getFatherId()), space);
        }
    }

    @Override
    public void createSpaceIndex(int spaceId) {
        try {
            SpaceInstLight space = this.getSpaceInstLight(spaceId);
            this.createSpaceIndex(space);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }

    @Override
    public void createSpaceIndex(SpaceInstLight spaceInst) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(INDEX_SPACE_SCOPE, "Space", spaceInst.getId()));
        Map translations = spaceInst.getTranslations();
        for (Map.Entry translation : translations.entrySet()) {
            indexEntry.setTitle(((SpaceI18N)translation.getValue()).getName(), translation.getKey());
            indexEntry.setPreview(((SpaceI18N)translation.getValue()).getDescription(), translation.getKey());
        }
        indexEntry.setCreationUser(String.valueOf(spaceInst.getCreatedBy()));
        indexEntry.setCreationDate(spaceInst.getCreationDate());
        indexEntry.setLastModificationUser(String.valueOf(spaceInst.getUpdatedBy()));
        indexEntry.setLastModificationDate(spaceInst.getLastUpdateDate());
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    @Override
    public void deleteSpaceIndex(SpaceInst spaceInst) {
        String spaceId = spaceInst.getId();
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(INDEX_SPACE_SCOPE, "Space", spaceId));
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    @Override
    public void deleteAllSpaceIndexes() {
        IndexEngineProxy.removeScopedIndexEntries(INDEX_SPACE_SCOPE);
    }

    @Override
    public String addSpaceInst(String userId, SpaceInst spaceInst) throws AdminException {
        try {
            if (!spaceInst.isRoot()) {
                int localId = this.getDriverSpaceId(spaceInst.getDomainFatherId());
                spaceInst.setDomainFatherId(String.valueOf(localId));
                if (this.useProfileInheritance && !spaceInst.isInheritanceBlocked()) {
                    this.setSpaceProfilesToSubSpace(spaceInst, null);
                }
            }
            spaceInst.setCreatorUserId(userId);
            this.spaceManager.createSpaceInst(spaceInst);
            this.cache.opAddSpace(this.getSpaceInstById(spaceInst.getLocalId()));
            SpaceInstLight space = this.getSpaceInstLight(spaceInst.getLocalId());
            this.addSpaceInTreeCache(space, true);
            this.createSpaceIndex(space);
            return spaceInst.getId();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            try {
                this.cache.resetCache();
            }
            catch (Exception e1) {
                SilverLogger.getLogger((Object)this).error((Throwable)e1);
            }
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)SPACE, (Object)spaceInst.getName()), e);
        }
    }

    @Override
    public String deleteSpaceInstById(String userId, String spaceId, boolean definitive) throws AdminException {
        try {
            int driverSpaceId = this.getDriverSpaceId(spaceId);
            SpaceInst spaceInst = this.getSpaceInstById(driverSpaceId);
            if (!definitive) {
                this.spaceManager.sendSpaceToBasket(spaceInst, userId);
                this.deleteSpaceProfilesOnSpaceLogicalDeletion(spaceInst);
                this.notifyOnSpaceLogicalDeletion(spaceId);
            } else {
                this.deleteEffectivelySpaceInst(spaceInst, spaceId, driverSpaceId, userId);
            }
            this.cache.opRemoveSpace(spaceInst);
            this.treeCache.removeSpace(driverSpaceId);
            this.deleteSpaceIndex(spaceInst);
            return spaceId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)SPACE, (Object)spaceId), e);
        }
    }

    private void deleteEffectivelySpaceInst(SpaceInst spaceInst, String spaceId, int driverSpaceId, String userId) throws AdminException {
        String[] subSpaceIds;
        for (String subSpaceId : subSpaceIds = this.getAllSubSpaceIdsWithoutCache(spaceId)) {
            this.deleteSpaceInstById(userId, subSpaceId, true);
        }
        List<SpaceInstLight> removedSpaces = this.getRemovedSpaces();
        for (SpaceInstLight removedSpace : removedSpaces) {
            if (!String.valueOf(driverSpaceId).equals(removedSpace.getFatherId())) continue;
            this.deleteSpaceInstById(userId, removedSpace.getId(), true);
        }
        for (SpaceProfileInst spaceProfileInst : spaceInst.getAllSpaceProfilesInst()) {
            this.deleteSpaceProfileInst(spaceProfileInst.getId());
        }
        List<ComponentInst> alCompoInst = spaceInst.getAllComponentsInst();
        for (ComponentInst anAlCompoInst : alCompoInst) {
            this.deleteComponentInst(userId, this.getClientComponentId(anAlCompoInst), true);
        }
        List<ComponentInstLight> removedComponents = this.getRemovedComponents();
        for (ComponentInstLight removedComponent : removedComponents) {
            if (!spaceId.equals(removedComponent.getDomainFatherId())) continue;
            this.deleteComponentInst(userId, removedComponent.getId(), true);
        }
        this.spaceManager.deleteSpaceInst(spaceInst);
    }

    private void notifyOnSpaceLogicalDeletion(String spaceId) throws AdminException {
        SpaceInst spaceInst = this.getSpaceInstById(spaceId);
        this.spaceEventNotifier.notifyEventOn(ResourceEvent.Type.REMOVING, new SpaceInst[]{spaceInst, spaceInst});
        List<SpaceInstLight> spaces = this.treeCache.getSubSpaces(this.getDriverSpaceId(spaceId));
        for (SpaceInstLight space : spaces) {
            this.notifyOnSpaceLogicalDeletion(space.getId());
        }
    }

    private void deleteSpaceProfilesOnSpaceLogicalDeletion(SpaceInst spaceInst) throws AdminException {
        for (SpaceProfileInst spaceProfileInst : spaceInst.getAllSpaceProfilesInst()) {
            this.deleteSpaceProfileInst(spaceProfileInst.getId());
        }
        List<ComponentInst> components = spaceInst.getAllComponentsInst();
        for (ComponentInst component : components) {
            for (int p = 0; p < component.getNumProfileInst(); ++p) {
                this.deleteProfileInst(component.getProfileInst(p).getId());
            }
        }
        List<SpaceInst> list = spaceInst.getSubSpaces();
        for (SpaceInst subSpace : list) {
            this.deleteSpaceProfilesOnSpaceLogicalDeletion(subSpace);
        }
    }

    @Override
    public void restoreSpaceFromBasket(String spaceId) throws AdminException {
        try {
            int driverSpaceId = this.getDriverSpaceId(spaceId);
            this.spaceManager.removeSpaceFromBasket(driverSpaceId);
            this.cache.removeSpaceInst(driverSpaceId);
            this.treeCache.removeSpace(driverSpaceId);
            this.addSpaceInTreeCache(this.getSpaceInstLight(driverSpaceId), true);
            SpaceInst spaceInst = this.getSpaceInstById(driverSpaceId);
            if (this.useProfileInheritance && !spaceInst.isInheritanceBlocked() && !spaceInst.isRoot()) {
                this.updateSpaceInheritance(spaceInst, false);
            }
            this.createSpaceIndex(driverSpaceId);
            this.cache.opAddSpace(spaceInst);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)SPACE, (Object)spaceId), e);
        }
    }

    @Override
    public SpaceInst getSpaceInstById(String spaceId) throws AdminException {
        try {
            return this.getSpaceInstById(this.getDriverSpaceId(spaceId));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)spaceId), e);
        }
    }

    private SpaceInst getSpaceInstById(int spaceId) throws AdminException {
        try {
            SpaceInst spaceInst;
            Optional<SpaceInst> optionalSpaceInst = this.cache.getSpaceInst(spaceId);
            if (optionalSpaceInst.isEmpty()) {
                spaceInst = this.spaceManager.getSpaceInstById(spaceId);
                if (spaceInst != null) {
                    this.cache.putSpaceInst(spaceInst);
                }
            } else {
                spaceInst = optionalSpaceInst.get();
            }
            return this.spaceManager.copy(spaceInst);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)String.valueOf(spaceId)), e);
        }
    }

    @Override
    public SpaceInst getPersonalSpace(String userId) throws AdminException {
        return this.spaceManager.getPersonalSpace(userId);
    }

    @Override
    public String[] getAllSubSpaceIds(String domainFatherId) throws AdminException {
        try {
            int spaceId = this.getDriverSpaceId(domainFatherId);
            if (this.treeCache.isSpacePresent(spaceId)) {
                return (String[])this.treeCache.getSubSpaces(this.getDriverSpaceId(domainFatherId)).stream().map(SpaceInstLight::getId).toArray(String[]::new);
            }
            return this.getAllSubSpaceIdsWithoutCache(domainFatherId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SUBSPACES_OF_SPACE, (Object)domainFatherId), e);
        }
    }

    private String[] getAllSubSpaceIdsWithoutCache(String domainFatherId) throws AdminException {
        try {
            String[] asDriverSpaceIds = this.spaceManager.getAllSubSpaceIds(this.getDriverSpaceId(domainFatherId));
            return this.getClientSpaceIds(asDriverSpaceIds);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SUBSPACES_OF_SPACE, (Object)domainFatherId), e);
        }
    }

    @Override
    public String updateSpaceInst(SpaceInst spaceInstNew) throws AdminException {
        try {
            SpaceInst oldSpace = this.getSpaceInstById(spaceInstNew.getId());
            this.spaceManager.updateSpaceInst(spaceInstNew);
            if (this.useProfileInheritance && oldSpace.isInheritanceBlocked() != spaceInstNew.isInheritanceBlocked()) {
                this.updateSpaceInheritance(oldSpace, spaceInstNew.isInheritanceBlocked());
            }
            this.cache.opUpdateSpace(spaceInstNew);
            Optional<SpaceInstLight> spaceInCache = this.treeCache.getSpaceInstLight(spaceInstNew.getLocalId());
            spaceInCache.ifPresent(s -> s.setInheritanceBlocked(spaceInstNew.isInheritanceBlocked()));
            SpaceInstLight spaceLight = this.spaceManager.getSpaceInstLightById(this.getDriverSpaceId(spaceInstNew.getId()));
            spaceLight.setInheritanceBlocked(spaceInstNew.isInheritanceBlocked());
            this.treeCache.updateSpace(spaceLight);
            this.createSpaceIndex(spaceLight);
            return spaceInstNew.getId();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE, (Object)spaceInstNew.getId()), e);
        }
    }

    @Override
    public void updateSpaceOrderNum(String spaceId, int orderNum) throws AdminException {
        try {
            int driverSpaceId = this.getDriverSpaceId(spaceId);
            this.spaceManager.updateSpaceOrder(driverSpaceId, orderNum);
            this.cache.opUpdateSpace(this.spaceManager.getSpaceInstById(driverSpaceId));
            Optional<SpaceInstLight> optionalSpace = this.treeCache.getSpaceInstLight(driverSpaceId);
            if (optionalSpace.isPresent()) {
                SpaceInstLight space = optionalSpace.get();
                space.setOrderNum(orderNum);
                if (!space.isRoot()) {
                    this.treeCache.setSubspaces(this.getDriverSpaceId(space.getFatherId()), this.getSubSpaces(space.getFatherId()));
                }
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE, (Object)spaceId), e);
        }
    }

    private void updateSpaceInheritance(SpaceInst space, boolean inheritanceBlocked) throws AdminException {
        try {
            SpaceInst parentSpace;
            if (inheritanceBlocked) {
                List<SpaceProfileInst> inheritedProfiles = space.getInheritedProfiles();
                for (SpaceProfileInst profile : inheritedProfiles) {
                    this.deleteSpaceProfileInst(profile.getId());
                }
                parentSpace = this.getSpaceInstById(space.getId());
            } else {
                List<SpaceProfileInst> profiles = space.getProfiles();
                for (SpaceProfileInst profile : profiles) {
                    if (profile == null || profile.isManager()) continue;
                    this.deleteSpaceProfileInst(profile.getId());
                }
                parentSpace = null;
            }
            if (!space.isRoot()) {
                this.setSpaceProfilesToSubSpace(space, parentSpace, true);
            }
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE, (Object)space.getId()), (Throwable)((Object)e));
        }
    }

    @Override
    public String[] getAllRootSpaceIds() throws AdminException {
        try {
            String[] driverSpaceIds = this.spaceManager.getAllRootSpaceIds();
            driverSpaceIds = this.getClientSpaceIds(driverSpaceIds);
            return driverSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"root spaces", (Object)""), e);
        }
    }

    @Override
    public List<SpaceInstLight> getPathToComponent(String componentId) throws AdminException {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>();
        ComponentInst component = this.getComponentInst(componentId);
        if (component != null) {
            String spaceId = component.getDomainFatherId();
            return this.getPathToSpace(spaceId, true);
        }
        return path;
    }

    @Override
    public List<SpaceInstLight> getPathToSpace(String spaceId, boolean includeTarget) throws AdminException {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>(10);
        SpaceInstLight space = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
        if (space != null) {
            if (includeTarget) {
                path.add(0, space);
            }
            while (space != null && !space.isRoot()) {
                String fatherId = space.getFatherId();
                space = this.getSpaceInstLight(this.getDriverSpaceId(fatherId));
                path.add(0, space);
            }
        }
        return path;
    }

    @Override
    public String[] getAllSpaceIds() throws AdminException {
        try {
            String[] driverSpaceIds = this.spaceManager.getAllSpaceIds();
            driverSpaceIds = this.getClientSpaceIds(driverSpaceIds);
            return driverSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all spaces", (Object)""), e);
        }
    }

    @Override
    public List<SpaceInstLight> getRemovedSpaces() throws AdminException {
        try {
            return this.spaceManager.getRemovedSpaces();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all removed spaces", (Object)""), e);
        }
    }

    @Override
    public List<ComponentInstLight> getRemovedComponents() throws AdminException {
        try {
            return this.componentManager.getRemovedComponents();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all removed components", (Object)""), e);
        }
    }

    @Override
    public String[] getSpaceNames(String[] asClientSpaceIds) throws AdminException {
        if (asClientSpaceIds == null) {
            return ArrayUtil.emptyStringArray();
        }
        try {
            String[] asSpaceNames = new String[asClientSpaceIds.length];
            for (int nI = 0; nI < asClientSpaceIds.length; ++nI) {
                SpaceInstLight spaceInst = this.getSpaceInstLightById(asClientSpaceIds[nI]);
                asSpaceNames[nI] = spaceInst.getName();
            }
            return asSpaceNames;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"space names of", (Object)String.join((CharSequence)", ", asClientSpaceIds)), e);
        }
    }

    @Override
    public Map<String, WAComponent> getAllWAComponents() {
        return this.componentRegistry.getAllWAComponents();
    }

    @Override
    public SilverpeasComponentInstance getComponentInstance(String componentInstanceIdentifier) throws AdminException {
        try {
            ComponentInst componentInstance;
            Optional<ToolInstance> toolInstance;
            Optional<PersonalComponentInstance> personalComponentInstance = PersonalComponentInstance.from(componentInstanceIdentifier);
            Object instance = personalComponentInstance.isPresent() ? (SilverpeasComponentInstance)personalComponentInstance.get() : ((toolInstance = ToolInstance.from(componentInstanceIdentifier)).isPresent() ? (SilverpeasComponentInstance)toolInstance.get() : ("-1".equals((componentInstance = this.getComponentInst(componentInstanceIdentifier)).getId()) ? null : componentInstance));
            return instance;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"Silverpeas component", (Object)componentInstanceIdentifier), e);
        }
    }

    @Override
    public ComponentInst getComponentInst(String sClientComponentId) throws AdminException {
        try {
            ComponentInst componentInst = this.getComponentInst(this.getDriverComponentId(sClientComponentId));
            componentInst = this.checkComponentInstanceById(componentInst, sClientComponentId, this.nullComponentInstSupplier);
            Objects.requireNonNull(componentInst);
            componentInst.setDomainFatherId(this.getClientSpaceId(componentInst.getDomainFatherId()));
            return componentInst;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)COMPONENT, (Object)sClientComponentId), e);
        }
    }

    @Override
    public ComponentInstLight getComponentInstLight(String componentId) throws AdminException {
        try {
            int driverComponentId = this.getDriverComponentId(componentId);
            ComponentInstLight instance = this.componentManager.getComponentInstLight(driverComponentId);
            return this.checkComponentInstanceById(instance, componentId, null);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)COMPONENT, (Object)componentId), e);
        }
    }

    private <T extends SilverpeasComponentInstance> T checkComponentInstanceById(T componentInstance, String componentId, Supplier<T> nullComponentInstance) {
        if (componentInstance != null) {
            if (componentInstance.getId().equals(componentId) || "-1".equals(componentInstance.getId()) || StringUtil.isLong((String)componentId)) {
                return componentInstance;
            }
            SilverLogger.getLogger((Object)this).error("{0}. Wrong component {1} has been found!!", new Object[]{SilverpeasExceptionMessages.failureOnGetting((String)COMPONENT, (Object)componentId), componentInstance.getId()});
            return (T)(nullComponentInstance != null ? (SilverpeasComponentInstance)nullComponentInstance.get() : null);
        }
        return null;
    }

    private ComponentInst getComponentInst(int componentId) throws AdminException {
        try {
            ComponentInst componentInst;
            Optional<ComponentInst> optionalInstance = this.cache.getComponentInst(componentId);
            if (optionalInstance.isEmpty()) {
                componentInst = this.componentManager.getComponentInst(componentId);
                this.cache.putComponentInst(componentInst);
            } else {
                componentInst = optionalInstance.get();
            }
            return this.componentManager.copy(componentInst);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)COMPONENT, (Object)String.valueOf(componentId)), e);
        }
    }

    @Override
    public String getComponentParameterValue(String componentId, String parameterName) {
        try {
            return this.componentManager.getParameterValueByComponentAndParamName(this.getDriverComponentId(componentId), parameterName.toLowerCase(), true);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return StringUtil.emptyString();
        }
    }

    @Override
    public Map<String, Map<String, String>> getParameterValuesByComponentIdThenByParamName(Collection<String> componentIds, Collection<String> paramNames) {
        HashMap localComponentIds = new HashMap(componentIds.size());
        componentIds.forEach(i -> localComponentIds.put(this.getDriverComponentId((String)i), i));
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(componentIds.size());
        try {
            this.componentManager.getParameterValuesByComponentIdThenByParamName(localComponentIds.keySet(), paramNames).forEach((k, v) -> result.put((String)localComponentIds.get(k), (Map<String, String>)v));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return result;
    }

    @Override
    public void restoreComponentFromBasket(String componentId) throws AdminException {
        try {
            this.componentManager.restoreComponentFromBasket(this.getDriverComponentId(componentId));
            ComponentInst componentInst = this.getComponentInst(componentId);
            if (this.useProfileInheritance && !componentInst.isInheritanceBlocked()) {
                this.setSpaceProfilesToComponent(componentInst, null);
            }
            this.cache.opUpdateComponent(componentInst);
            ComponentInstLight component = this.getComponentInstLight(componentId);
            this.treeCache.addComponent(component, this.getDriverSpaceId(component.getDomainFatherId()));
            this.createComponentIndex((SilverpeasComponentInstance)component);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)COMPONENT, (Object)componentId), new String[0]);
        }
    }

    @Override
    public void createComponentIndex(String componentId) {
        try {
            SilverpeasComponentInstance componentInstance = this.getComponentInstance(componentId);
            if (!componentInstance.isPersonal()) {
                this.createComponentIndex(componentInstance);
            }
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }

    @Override
    public void createComponentIndex(SilverpeasComponentInstance instance) {
        if (instance != null) {
            String componentId = instance.getId();
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(INDEX_COMPONENT_SCOPE, "Component", componentId));
            if (instance instanceof ComponentInst) {
                this.setIndexEntry((ComponentInst)instance, indexEntry);
            } else if (instance instanceof ComponentInstLight) {
                this.setIndexEntry((ComponentInstLight)instance, indexEntry);
            }
            IndexEngineProxy.addIndexEntry(indexEntry);
        }
    }

    private void setIndexEntry(ComponentInst componentInst, FullIndexEntry indexEntry) {
        this.setIndexEntryTranslations(componentInst.getTranslations(), indexEntry);
        indexEntry.setCreationUser(componentInst.getCreatorUserId());
        indexEntry.setCreationDate(componentInst.getCreationDate());
        indexEntry.setLastModificationUser(componentInst.getUpdaterUserId());
        indexEntry.setLastModificationDate(componentInst.getLastUpdateDate());
    }

    private void setIndexEntry(ComponentInstLight componentInstLight, FullIndexEntry indexEntry) {
        this.setIndexEntryTranslations(componentInstLight.getTranslations(), indexEntry);
        indexEntry.setCreationUser(Integer.toString(componentInstLight.getCreatedBy()));
        indexEntry.setCreationDate(componentInstLight.getCreationDate());
        indexEntry.setLastModificationUser(String.valueOf(componentInstLight.getUpdatedBy()));
        indexEntry.setLastModificationDate(componentInstLight.getLastUpdateDate());
    }

    private void setIndexEntryTranslations(Map<String, ComponentI18N> translations, FullIndexEntry indexEntry) {
        for (Map.Entry<String, ComponentI18N> translation : translations.entrySet()) {
            indexEntry.setTitle(translation.getValue().getName(), translation.getKey());
            indexEntry.setPreview(translation.getValue().getDescription(), translation.getKey());
        }
    }

    private void deleteComponentIndex(String componentId) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(INDEX_COMPONENT_SCOPE, "Component", componentId));
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    private void deleteComponentData(String componentId) {
        FileRepositoryManager.deleteAbsolutePath(componentId, "");
        IndexEngineProxy.removeScopedIndexEntries(componentId);
    }

    @Override
    public void deleteAllComponentIndexes() {
        IndexEngineProxy.removeScopedIndexEntries(INDEX_COMPONENT_SCOPE);
    }

    @Override
    public String addComponentInst(String userId, ComponentInst componentInst) throws AdminException, QuotaException {
        String string;
        block11: {
            Connection connection = DBUtil.openConnection();
            try {
                SpaceInst spaceInstFather = this.getSpaceInstById(componentInst.getDomainFatherId());
                SpaceServiceProvider.getComponentSpaceQuotaService().verify(ComponentSpaceQuotaKey.from(spaceInstFather));
                this.componentManager.createComponentInst(componentInst, spaceInstFather.getLocalId());
                spaceInstFather.addComponentInst(componentInst);
                String componentName = componentInst.getName();
                String componentId = componentInst.getId();
                ComponentInstancePostConstruction.get(componentName).ifPresent(c -> c.postConstruct(componentId));
                if (this.isContentManagedComponent(componentName)) {
                    this.contentMgtEngine.registerNewContentInstance(connection, componentId, "containerPDC", componentName);
                }
                if (this.useProfileInheritance && !componentInst.isInheritanceBlocked()) {
                    this.setSpaceProfilesToComponent(componentInst, spaceInstFather);
                }
                this.cache.opAddComponent(componentInst);
                ComponentInstLight component = this.getComponentInstLight(componentId);
                this.treeCache.addComponent(component, this.getDriverSpaceId(spaceInstFather.getId()));
                this.createComponentIndex((SilverpeasComponentInstance)component);
                string = componentId;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QuotaException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)COMPONENT, (Object)componentInst.getName()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    boolean isContentManagedComponent(String componentName) {
        return "questionReply".equals(componentName) || "whitePages".equals(componentName) || "kmelia".equals(componentName) || "kmax".equals(componentName) || "survey".equals(componentName) || "toolbox".equals(componentName) || "quickinfo".equals(componentName) || "almanach".equals(componentName) || "quizz".equals(componentName) || "forums".equals(componentName) || "pollingStation".equals(componentName) || "bookmark".equals(componentName) || "chat".equals(componentName) || "infoLetter".equals(componentName) || "webSites".equals(componentName) || "gallery".equals(componentName) || "blog".equals(componentName);
    }

    @Override
    public String deleteComponentInst(String userId, String componentId, boolean definitive) throws AdminException {
        try {
            int sDriverComponentId = this.getDriverComponentId(componentId);
            ComponentInst componentInst = this.getComponentInst(sDriverComponentId);
            componentInst = this.checkComponentInstanceById(componentInst, componentId, this.nullComponentInstSupplier);
            Objects.requireNonNull(componentInst);
            String sFatherClientId = componentInst.getDomainFatherId();
            SpaceInst space = this.getSpaceInstById(sFatherClientId);
            if (space.getFirstPageType() == SpaceInst.FP_TYPE_COMPONENT_INST && space.getFirstPageExtraParam().equals(componentId)) {
                space.setFirstPageType(SpaceInst.FP_TYPE_STANDARD);
                space.setFirstPageExtraParam(null);
                this.updateSpaceInst(space);
            }
            if (!definitive) {
                for (int nI = 0; nI < componentInst.getNumProfileInst(); ++nI) {
                    this.deleteProfileInst(componentInst.getProfileInst(nI).getId());
                }
                this.componentManager.sendComponentToBasket(componentInst, userId);
            } else {
                try (Connection connection = DBUtil.openConnection();){
                    String componentName = componentInst.getName();
                    ComponentInstancePreDestruction.get(componentName).ifPresent(c -> c.preDestroy(componentId));
                    ServiceProvider.getAllServices(ComponentInstanceDeletion.class, (Annotation[])new Annotation[0]).forEach(service -> service.delete(componentId));
                    for (int nI = 0; nI < componentInst.getNumProfileInst(); ++nI) {
                        this.deleteProfileInst(componentInst.getProfileInst(nI).getId());
                    }
                    if (this.isContentManagedComponent(componentName)) {
                        this.contentMgtEngine.unregisterNewContentInstance(connection, componentId, "containerPDC", componentName);
                    }
                }
                this.componentManager.deleteComponentInst(componentInst);
            }
            this.cache.opRemoveComponent(componentInst);
            this.treeCache.removeComponent(this.getDriverSpaceId(sFatherClientId), componentId);
            this.deleteComponentIndex(componentId);
            if (definitive) {
                this.deleteComponentData(componentId);
            }
            return componentId;
        }
        catch (SQLException | ContentManagerException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)COMPONENT, (Object)componentId), (Throwable)e);
        }
    }

    private void updateComponentOrderNum(String componentId, int orderNum) throws AdminException {
        try {
            int driverComponentId = this.getDriverComponentId(componentId);
            this.componentManager.updateComponentOrder(driverComponentId, orderNum);
            Optional<ComponentInst> optional = this.cache.getComponentInst(driverComponentId);
            optional.ifPresent(componentInst -> componentInst.setOrderNum(orderNum));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)COMPONENT, (Object)componentId), e);
        }
    }

    @Override
    public String updateComponentInst(ComponentInst component) throws AdminException {
        try {
            ComponentInst oldComponent = this.getComponentInst(component.getId());
            String componentClientId = this.getClientComponentId(oldComponent);
            this.componentManager.updateComponentInst(oldComponent, component);
            if (this.useProfileInheritance && oldComponent.isInheritanceBlocked() != component.isInheritanceBlocked()) {
                this.updateComponentInheritance(oldComponent, component.isInheritanceBlocked());
            }
            this.cache.opUpdateComponent(component);
            this.treeCache.updateComponent(this.getComponentInstLight(component.getId()));
            this.createComponentIndex(componentClientId);
            return componentClientId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)COMPONENT, (Object)component.getId()), e);
        }
    }

    private void updateComponentInheritance(ComponentInst component, boolean inheritanceBlocked) throws AdminException {
        try {
            if (inheritanceBlocked) {
                List<ProfileInst> inheritedProfiles = component.getInheritedProfiles();
                for (ProfileInst profile : inheritedProfiles) {
                    this.deleteProfileInst(profile.getId());
                }
            } else {
                List<ProfileInst> profiles = component.getProfiles();
                for (ProfileInst profile : profiles) {
                    this.deleteProfileInst(profile.getId());
                }
                this.setSpaceProfilesToComponent(component, null);
            }
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)COMPONENT, (Object)component.getId()), (Throwable)((Object)e));
        }
    }

    @Override
    public void setSpaceProfilesToSubSpace(SpaceInst subSpace, SpaceInst space) throws AdminException {
        this.setSpaceProfilesToSubSpace(subSpace, space, false);
    }

    @Override
    public void setSpaceProfilesToSubSpace(SpaceInst subSpace, SpaceInst space, boolean persist) throws AdminException {
        SpaceInst parent = space;
        if (parent == null) {
            parent = this.getSpaceInstById(subSpace.getDomainFatherId());
        }
        this.setSpaceProfileToSubSpace(subSpace, parent, SilverpeasRole.MANAGER);
        this.setSpaceProfileToSubSpace(subSpace, parent, SilverpeasRole.ADMIN);
        this.setSpaceProfileToSubSpace(subSpace, parent, SilverpeasRole.PUBLISHER);
        this.setSpaceProfileToSubSpace(subSpace, parent, SilverpeasRole.WRITER);
        this.setSpaceProfileToSubSpace(subSpace, parent, SilverpeasRole.READER);
        if (persist) {
            for (SpaceProfileInst profile : subSpace.getInheritedProfiles()) {
                if (StringUtil.isDefined((String)profile.getId())) {
                    if (profile.isEmpty()) {
                        this.deleteSpaceProfileInst(profile.getId(), null);
                        continue;
                    }
                    this.updateSpaceProfileInst(profile, null);
                    continue;
                }
                this.addSpaceProfileInst(profile, null);
            }
        }
    }

    private void setSpaceProfileToSubSpace(SpaceInst subSpace, SpaceInst space, SilverpeasRole role) {
        SpaceProfileInst inheritedProfile;
        String profileName = role.toString();
        SpaceProfileInst subSpaceProfile = subSpace.getInheritedSpaceProfileInst(profileName);
        if (subSpaceProfile != null) {
            subSpaceProfile.removeAllGroups();
            subSpaceProfile.removeAllUsers();
        } else {
            subSpaceProfile = new SpaceProfileInst();
            subSpaceProfile.setName(profileName);
            subSpaceProfile.setInherited(true);
        }
        SpaceProfileInst profile = space.getDirectSpaceProfileInst(profileName);
        if (profile != null) {
            subSpaceProfile.addGroups(profile.getAllGroups());
            subSpaceProfile.addUsers(profile.getAllUsers());
        }
        if ((inheritedProfile = space.getInheritedSpaceProfileInst(profileName)) != null) {
            subSpaceProfile.addGroups(inheritedProfile.getAllGroups());
            subSpaceProfile.addUsers(inheritedProfile.getAllUsers());
        }
        if (!subSpaceProfile.isEmpty()) {
            subSpace.addSpaceProfileInst(subSpaceProfile);
        }
    }

    @Override
    public void setSpaceProfilesToComponent(ComponentInst component, SpaceInst spaceInst) throws AdminException {
        WAComponent waComponent = this.componentRegistry.getWAComponent(component.getName()).orElseThrow(() -> new AdminException("No such component with name " + component.getName(), new String[0]));
        List<Profile> componentRoles = waComponent.getProfiles();
        SpaceInst space = spaceInst == null ? this.getSpaceInstById(component.getDomainFatherId()) : spaceInst;
        try {
            for (Profile componentRole : componentRoles) {
                ProfileInst inheritedProfile = this.removeInheritedComponentRole(component, componentRole);
                List<String> spaceRoles = this.componentRole2SpaceRoles(componentRole.getName(), component.getName());
                this.removeInheritedSpaceRole(space, spaceRoles, inheritedProfile);
                if (StringUtil.isDefined((String)inheritedProfile.getId())) {
                    this.updateProfileInst(inheritedProfile);
                    continue;
                }
                if (inheritedProfile.isEmpty()) continue;
                this.addProfileInst(inheritedProfile, null);
            }
        }
        catch (Exception e) {
            throw new AdminException("Fail to set profiles of space " + space.getId() + " to component" + component.getId(), e);
        }
        this.checkObjectsProfiles(component.getId());
    }

    private void removeInheritedSpaceRole(SpaceInst space, List<String> spaceRoles, ProfileInst inheritedProfile) {
        for (String spaceRole : spaceRoles) {
            SpaceProfileInst spaceProfile = space.getDirectSpaceProfileInst(spaceRole);
            if (spaceProfile != null) {
                inheritedProfile.addGroups(spaceProfile.getAllGroups());
                inheritedProfile.addUsers(spaceProfile.getAllUsers());
            }
            if ((spaceProfile = space.getInheritedSpaceProfileInst(spaceRole)) == null) continue;
            inheritedProfile.addGroups(spaceProfile.getAllGroups());
            inheritedProfile.addUsers(spaceProfile.getAllUsers());
        }
    }

    @Nonnull
    private ProfileInst removeInheritedComponentRole(ComponentInst component, Profile componentRole) {
        ProfileInst inheritedProfile = component.getInheritedProfileInst(componentRole.getName());
        if (inheritedProfile != null) {
            inheritedProfile.removeAllGroups();
            inheritedProfile.removeAllUsers();
        } else {
            inheritedProfile = new ProfileInst();
            inheritedProfile.setComponentFatherId(component.getLocalId());
            inheritedProfile.setInherited(true);
            inheritedProfile.setName(componentRole.getName());
        }
        return inheritedProfile;
    }

    private void checkObjectsProfiles(String componentId) {
        List<ProfileInst> objectsProfiles = this.getProfileInsts(componentId);
        if (objectsProfiles == null) {
            return;
        }
        for (ProfileInst objectProfile : objectsProfiles) {
            try {
                List<String> groupIdsToRemove = this.getGroupIdsToRemove(componentId, objectProfile);
                List<String> userIdsToRemove = this.getUserIdsToRemove(componentId, objectProfile);
                if (groupIdsToRemove.isEmpty() && userIdsToRemove.isEmpty()) continue;
                for (String groupId : groupIdsToRemove) {
                    objectProfile.removeGroup(groupId);
                }
                for (String userId : userIdsToRemove) {
                    objectProfile.removeUser(userId);
                }
                this.profileManager.updateProfileInst(objectProfile);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("Error when checking object profile " + objectProfile.getId(), new Object[]{e});
            }
        }
    }

    @Nonnull
    private List<String> getUserIdsToRemove(String componentId, ProfileInst objectProfile) throws AdminException {
        ArrayList<String> userIdsToRemove = new ArrayList<String>();
        List<String> userIds = objectProfile.getAllUsers();
        for (String userId : userIds) {
            if (this.isComponentAvailableToUser(componentId, userId)) continue;
            userIdsToRemove.add(userId);
        }
        return userIdsToRemove;
    }

    @Nonnull
    private List<String> getGroupIdsToRemove(String componentId, ProfileInst objectProfile) throws AdminException {
        ArrayList<String> groupIdsToRemove = new ArrayList<String>();
        List<String> groupIds = objectProfile.getAllGroups();
        for (String groupId : groupIds) {
            if (this.isComponentAvailableToGroup(componentId, groupId)) continue;
            groupIdsToRemove.add(groupId);
        }
        return groupIdsToRemove;
    }

    @Nullable
    private List<ProfileInst> getProfileInsts(String componentId) {
        List<ProfileInst> objectsProfiles = null;
        try {
            int shortComponentId = this.getDriverComponentId(componentId);
            objectsProfiles = this.profiledObjectManager.getProfiles(shortComponentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn("Error when getting all component objects profiles " + componentId, new Object[]{e});
        }
        return objectsProfiles;
    }

    @Override
    public void moveSpace(String spaceId, String fatherId) throws AdminException {
        String[] allComponentIds;
        if (this.isParent(this.getDriverSpaceId(spaceId), this.getDriverSpaceId(fatherId))) {
            return;
        }
        int shortSpaceId = this.getDriverSpaceId(spaceId);
        int shortFatherId = StringUtil.isDefined((String)fatherId) ? this.getDriverSpaceId(fatherId) : -1;
        boolean moveOnTop = shortFatherId == -1;
        SpaceInst space = this.getSpaceInstById(shortSpaceId);
        int shortOldSpaceId = this.getDriverSpaceId(space.getDomainFatherId());
        this.spaceManager.moveSpace(shortSpaceId, shortFatherId);
        int position = moveOnTop ? this.getAllRootSpaceIds().length : this.getAllSubSpaceIdsWithoutCache(fatherId).length;
        this.spaceManager.updateSpaceOrder(shortSpaceId, position);
        if (this.useProfileInheritance) {
            this.processProfileInstsOnSpaceMove(shortSpaceId, shortFatherId, moveOnTop);
        }
        this.cache.resetSpaceInst();
        this.treeCache.removeSpace(shortSpaceId);
        this.treeCache.setSubspaces(shortOldSpaceId, this.spaceManager.getSubSpaces(shortOldSpaceId));
        this.addSpaceInTreeCache(this.spaceManager.getSpaceInstLightById(shortSpaceId), false);
        if (!moveOnTop) {
            this.treeCache.setSubspaces(shortFatherId, this.spaceManager.getSubSpaces(shortFatherId));
        }
        for (String componentId : allComponentIds = this.getAllComponentIdsRecur(spaceId)) {
            this.checkObjectsProfiles(componentId);
        }
    }

    private void processProfileInstsOnSpaceMove(int shortSpaceId, int shortFatherId, boolean moveOnTop) throws AdminException {
        SpaceInst space = this.spaceManager.getSpaceInstById(shortSpaceId);
        if (moveOnTop) {
            List<SpaceProfileInst> inheritedProfiles = space.getInheritedProfiles();
            for (SpaceProfileInst profile : inheritedProfiles) {
                this.deleteSpaceProfileInst(profile.getId());
            }
        } else if (!space.isInheritanceBlocked()) {
            SpaceInst father = this.getSpaceInstById(shortFatherId);
            this.setSpaceProfilesToSubSpace(space, father, true);
        }
        HashMap<String, SpaceProfileInst> mergedProfiles = new HashMap<String, SpaceProfileInst>();
        ArrayList<SpaceProfileInst> allProfiles = new ArrayList<SpaceProfileInst>(space.getProfiles());
        if (!moveOnTop) {
            allProfiles.addAll(space.getInheritedProfiles());
        }
        for (SpaceProfileInst profile : allProfiles) {
            SpaceProfileInst mergedProfile = (SpaceProfileInst)mergedProfiles.get(profile.getName());
            if (mergedProfile == null) {
                mergedProfile = new SpaceProfileInst();
                mergedProfile.setName(profile.getName());
                mergedProfile.setInherited(true);
                mergedProfiles.put(profile.getName(), mergedProfile);
            }
            mergedProfile.addGroups(profile.getAllGroups());
            mergedProfile.addUsers(profile.getAllUsers());
        }
        for (SpaceProfileInst profile : mergedProfiles.values()) {
            this.spreadSpaceProfile(shortSpaceId, profile);
        }
        if (moveOnTop) {
            space.setInheritanceBlocked(false);
            this.spaceManager.updateSpaceInst(space);
        }
    }

    @Override
    public void moveComponentInst(String spaceId, String componentId, String idComponentBefore, ComponentInst[] componentInsts) throws AdminException {
        try {
            int sDriverComponentId = this.getDriverComponentId(componentId);
            int sDriverSpaceId = this.getDriverSpaceId(spaceId);
            ComponentInst componentInst = this.getComponentInst(componentId);
            String oldSpaceId = componentInst.getDomainFatherId();
            this.componentManager.moveComponentInst(sDriverSpaceId, sDriverComponentId);
            componentInst.setDomainFatherId(String.valueOf(sDriverSpaceId));
            if (!componentInst.isInheritanceBlocked()) {
                this.setSpaceProfilesToComponent(componentInst, null);
            }
            if (StringUtil.isDefined((String)idComponentBefore) && componentInsts != null) {
                this.setComponentPlace(componentId, idComponentBefore, componentInsts);
            } else {
                this.updateComponentOrderNum(componentId, this.getAllComponentIds(spaceId).length);
            }
            SpaceInst fromSpace = this.getSpaceInstById(this.getDriverSpaceId(oldSpaceId));
            String spaceHomePage = fromSpace.getFirstPageExtraParam();
            if (StringUtil.isDefined((String)spaceHomePage) && spaceHomePage.equals(componentId)) {
                fromSpace.setFirstPageExtraParam("");
                fromSpace.setFirstPageType(0);
                this.updateSpaceInst(fromSpace);
            }
            this.cache.resetSpaceInst();
            this.cache.resetComponentInst();
            this.treeCache.setComponents(this.getDriverSpaceId(oldSpaceId), this.componentManager.getComponentsInSpace(this.getDriverSpaceId(oldSpaceId)));
            this.treeCache.setComponents(this.getDriverSpaceId(spaceId), this.componentManager.getComponentsInSpace(this.getDriverSpaceId(spaceId)));
        }
        catch (Exception e) {
            throw new AdminException("Fail to move component " + componentId + " into space " + spaceId, e);
        }
    }

    @Override
    public void setComponentPlace(String componentId, String idComponentBefore, ComponentInst[] brothersComponents) throws AdminException {
        int i;
        int orderNum = 0;
        ComponentInst theComponent = this.getComponentInst(componentId);
        for (i = 0; i < brothersComponents.length; ++i) {
            if (idComponentBefore.equals(brothersComponents[i].getId())) {
                theComponent.setOrderNum(orderNum);
                this.updateComponentOrderNum(theComponent.getId(), orderNum);
                ++orderNum;
            }
            if (brothersComponents[i].getOrderNum() != orderNum) {
                brothersComponents[i].setOrderNum(orderNum);
                this.updateComponentOrderNum(brothersComponents[i].getId(), orderNum);
            }
            ++orderNum;
        }
        if (orderNum == i) {
            theComponent.setOrderNum(orderNum);
            this.updateComponentOrderNum(theComponent.getId(), orderNum);
        }
        int spaceId = this.getDriverSpaceId(theComponent.getSpaceId());
        this.treeCache.setComponents(spaceId, this.componentManager.getComponentsInSpace(spaceId));
        this.cache.removeSpaceInst(spaceId);
    }

    @Override
    public String getRequestRouter(String sComponentName) {
        return this.componentRegistry.getWAComponent(sComponentName).filter(wac -> StringUtil.isDefined((String)wac.getRouter())).map(WAComponent::getRouter).orElse("R" + sComponentName);
    }

    @Override
    public String[] getAllProfilesNames(String sComponentName) {
        ArrayList asProfiles = new ArrayList();
        this.componentRegistry.getWAComponent(sComponentName).ifPresent(wac -> {
            List<Profile> profiles = wac.getProfiles();
            ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
            for (Profile profile : profiles) {
                profileNames.add(profile.getName());
            }
            asProfiles.addAll(profileNames);
        });
        return asProfiles.toArray(new String[0]);
    }

    @Override
    public String getProfileLabelFromName(String componentName, String profileName, String lang) {
        return this.componentRegistry.getWAComponent(componentName).map(c -> new LocalizedWAComponent((WAComponent)c, lang)).map(l -> l.getProfile(profileName)).map(LocalizedProfile::getLabel).orElse(profileName);
    }

    @Override
    @Nonnull
    public ProfileInst getProfileInst(String sProfileId) throws AdminException {
        ProfileInst profileInst;
        Optional<ProfileInst> optionalProfile = this.cache.getProfileInst(sProfileId);
        if (optionalProfile.isEmpty()) {
            profileInst = Optional.ofNullable(this.profileManager.getProfileInst(sProfileId, false)).orElseThrow(() -> new AdminException("Profile instance" + sProfileId + " not found", new String[0]));
            this.cache.putProfileInst(profileInst);
        } else {
            profileInst = optionalProfile.get();
        }
        return profileInst;
    }

    @Override
    public List<ProfileInst> getAllProfiles(String userId, String componentId) {
        List<ProfileInst> profiles = new ArrayList<ProfileInst>();
        try {
            List<String> profileIds = List.of(this.getProfileIds(userId));
            ComponentInst componentInst = this.getComponentInst(componentId);
            profiles = componentInst.getAllProfilesInst().stream().filter(p -> profileIds.contains(p.getId())).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return profiles;
    }

    @Override
    public List<ProfileInst> getProfilesByObject(ProfiledObjectId objectRef, String componentId) throws AdminException {
        return this.profiledObjectManager.getProfiles(objectRef, this.getDriverComponentId(componentId));
    }

    @Override
    public String[] getProfilesByObjectAndUserId(ProfiledObjectId objectRef, String componentId, String userId) throws AdminException {
        List<String> groups = this.getAllGroupsOfUser(userId);
        return this.profiledObjectManager.getUserProfileNames(objectRef, this.getDriverComponentId(componentId), Integer.parseInt(userId), groups);
    }

    @Override
    public String[] getProfilesByObjectAndGroupId(ProfiledObjectId objectRef, String componentId, String groupId) throws AdminException {
        List<String> groupIds = this.groupManager.getPathToGroup(groupId);
        groupIds.add(groupId);
        return this.profiledObjectManager.getUserProfileNames(objectRef, this.getDriverComponentId(componentId), -1, groupIds);
    }

    @Override
    public Map<Pair<String, String>, Set<String>> getUserProfilesByComponentIdAndObjectId(ProfiledObjectIds profiledObjectIds, Collection<String> componentIds, String userId) throws AdminException {
        Map<Integer, String> localComponentIds = componentIds.stream().collect(Collectors.toMap(this::getDriverComponentId, i -> i));
        List<String> groups = this.getAllGroupsOfUser(userId);
        return this.profiledObjectManager.getUserProfileNames(profiledObjectIds, localComponentIds.keySet(), Integer.parseInt(userId), groups).entrySet().stream().collect(Collectors.toMap(e -> Pair.of((Object)((String)localComponentIds.get(((Pair)e.getKey()).getFirst())), (Object)String.valueOf(((Pair)e.getKey()).getSecond())), Map.Entry::getValue));
    }

    @Override
    public Map<String, List<String>> getProfilesByObjectTypeAndUserId(ProfiledObjectType profiledObjectType, String componentId, String userId) throws AdminException {
        List<String> groups = this.getAllGroupsOfUser(userId);
        return this.profiledObjectManager.getUserProfileNames(profiledObjectType, this.getDriverComponentId(componentId), Integer.parseInt(userId), groups);
    }

    @Override
    public boolean isObjectAvailableToUser(String componentId, ProfiledObjectId objectRef, String userId) throws AdminException {
        return userId == null || this.getProfilesByObjectAndUserId(objectRef, componentId, userId).length > 0;
    }

    @Override
    public boolean isObjectAvailableToGroup(String componentId, ProfiledObjectId objectRef, String groupId) throws AdminException {
        return groupId == null || this.getProfilesByObjectAndGroupId(objectRef, componentId, groupId).length > 0;
    }

    @Override
    public String addProfileInst(ProfileInst profileInst) throws AdminException {
        return this.addProfileInst(profileInst, null);
    }

    @Override
    public String addProfileInst(ProfileInst profileInst, String userId) throws AdminException {
        try {
            int driverFatherId = profileInst.getComponentFatherId();
            String sProfileId = this.profileManager.createProfileInst(profileInst, driverFatherId);
            profileInst.setId(sProfileId);
            if (profileInst.getObjectId().isNotDefined() || profileInst.getObjectId().isRootNode()) {
                ComponentInst componentInstFather = this.getComponentInst(driverFatherId);
                componentInstFather = this.checkComponentInstanceById(componentInstFather, String.valueOf(driverFatherId), this.nullComponentInstSupplier);
                Objects.requireNonNull(componentInstFather);
                componentInstFather.addProfileInst(profileInst);
                if (StringUtil.isDefined((String)userId)) {
                    componentInstFather.setUpdaterUserId(userId);
                    this.updateComponentInst(componentInstFather);
                }
                this.cache.opAddProfile(this.profileManager.getProfileInst(sProfileId, false));
            }
            return sProfileId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)PROFILE, (Object)profileInst.getName()), e);
        }
    }

    private void deleteProfileInst(String sProfileId) throws AdminException {
        this.deleteProfileInst(sProfileId, null);
    }

    @Override
    public String deleteProfileInst(String profileId, String userId) throws AdminException {
        ProfileInst profile = this.profileManager.getProfileInst(profileId, true);
        if (profile == null) {
            throw new AdminNotFoundException("Profile instance " + profileId + " not found", new String[0]);
        }
        try {
            this.profileManager.deleteProfileInst(profile);
            if (StringUtil.isDefined((String)userId) && (profile.getObjectId().isNotDefined() || profile.getObjectId().isRootNode())) {
                int driverFatherId = profile.getComponentFatherId();
                ComponentInst component = this.getComponentInst(driverFatherId);
                component = this.checkComponentInstanceById(component, String.valueOf(driverFatherId), this.nullComponentInstSupplier);
                Objects.requireNonNull(component);
                component.setUpdaterUserId(userId);
                this.updateComponentInst(component);
            }
            if (profile.getObjectId().isNotDefined() || profile.getObjectId().isRootNode()) {
                this.cache.opRemoveProfile(profile);
            }
            return profileId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)PROFILE, (Object)profileId), e);
        }
    }

    @Override
    public String updateProfileInst(ProfileInst profileInstNew) throws AdminException {
        return this.doUpdateProfileInst(profileInstNew, null);
    }

    @Override
    public String updateProfileInst(ProfileInst profileInstNew, String userId) throws AdminException {
        return this.doUpdateProfileInst(profileInstNew, userId);
    }

    private String doUpdateProfileInst(ProfileInst newProfile, String userId) throws AdminException {
        try {
            this.profileManager.updateProfileInst(newProfile);
            if (StringUtil.isDefined((String)userId) && (newProfile.getObjectId().isNotDefined() || newProfile.getObjectId().isRootNode())) {
                int driverFatherId = newProfile.getComponentFatherId();
                ComponentInst component = this.getComponentInst(driverFatherId);
                component = this.checkComponentInstanceById(component, String.valueOf(driverFatherId), this.nullComponentInstSupplier);
                Objects.requireNonNull(component);
                component.setUpdaterUserId(userId);
                this.updateComponentInst(component);
            }
            if (newProfile.getObjectId().isNotDefined() || newProfile.getObjectId().isRootNode()) {
                this.cache.opUpdateProfile(newProfile);
            }
            return newProfile.getId();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)PROFILE, (Object)newProfile.getId()), e);
        }
    }

    @Override
    public SpaceProfileInst getSpaceProfileInst(String spaceProfileId) throws AdminException {
        return this.spaceProfileManager.getSpaceProfileInst(spaceProfileId, false);
    }

    @Override
    public String addSpaceProfileInst(SpaceProfileInst spaceProfile, String userId) throws AdminException {
        try {
            int spaceId = this.getDriverComponentId(spaceProfile.getSpaceFatherId());
            String sSpaceProfileId = this.spaceProfileManager.createSpaceProfileInst(spaceProfile, spaceId);
            spaceProfile.setId(sSpaceProfileId);
            if (StringUtil.isDefined((String)userId)) {
                SpaceInst spaceInstFather = this.getSpaceInstById(spaceId);
                spaceInstFather.setUpdaterUserId(userId);
                this.updateSpaceInst(spaceInstFather);
            }
            Optional<SpaceInst> spaceInst = this.cache.getSpaceInst(spaceId);
            spaceInst.ifPresent(s -> s.addSpaceProfileInst(spaceProfile));
            if (!spaceProfile.isManager()) {
                this.spreadInheritedSpaceProfile(spaceProfile, spaceId);
            }
            this.cache.opAddSpaceProfile(spaceProfile);
            return sSpaceProfileId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)SPACE_PROFILE, (Object)spaceProfile.getName()), e);
        }
    }

    private void spreadInheritedSpaceProfile(SpaceProfileInst spaceProfile, Integer spaceId) throws AdminException {
        SpaceProfileInst inheritedProfile;
        SpaceProfileInst fullProfile = new SpaceProfileInst(spaceProfile);
        if (!fullProfile.isInherited() && (inheritedProfile = this.spaceProfileManager.getInheritedSpaceProfileInstByName(spaceId, fullProfile.getName())) != null) {
            fullProfile.addGroups(inheritedProfile.getAllGroups());
            fullProfile.addUsers(inheritedProfile.getAllUsers());
        }
        this.spreadSpaceProfile(spaceId, fullProfile);
    }

    private void deleteSpaceProfileInst(String sSpaceProfileId) throws AdminException {
        this.deleteSpaceProfileInst(sSpaceProfileId, null);
    }

    @Override
    public void deleteSpaceProfileInst(String sSpaceProfileId, String userId) throws AdminException {
        SpaceProfileInst spaceProfileInst = this.spaceProfileManager.getSpaceProfileInst(sSpaceProfileId, true);
        if (spaceProfileInst != null) {
            try {
                this.spaceProfileManager.deleteSpaceProfileInst(spaceProfileInst);
                this.cache.opRemoveSpaceProfile(spaceProfileInst);
                spaceProfileInst.removeAllGroups();
                spaceProfileInst.removeAllUsers();
                int spaceId = this.getDriverComponentId(spaceProfileInst.getSpaceFatherId());
                if (StringUtil.isDefined((String)userId)) {
                    SpaceInst spaceInstFather = this.getSpaceInstById(spaceId);
                    spaceInstFather.setUpdaterUserId(userId);
                    this.updateSpaceInst(spaceInstFather);
                }
                this.spreadInheritedSpaceProfile(spaceProfileInst, spaceId);
            }
            catch (Exception e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)SPACE_PROFILE, (Object)sSpaceProfileId), e);
            }
        }
    }

    private void updateSpaceProfileInst(SpaceProfileInst newSpaceProfile) throws AdminException {
        this.updateSpaceProfileInst(newSpaceProfile, null);
    }

    @Override
    public String updateSpaceProfileInst(SpaceProfileInst newSpaceProfile, String userId) throws AdminException {
        try {
            int spaceId = this.getDriverSpaceId(newSpaceProfile.getSpaceFatherId());
            SpaceProfileInst oldSpaceProfile = this.spaceProfileManager.getSpaceProfileInst(newSpaceProfile.getId(), false);
            if (oldSpaceProfile == null) {
                SpaceProfileInst spaceSpecificProfile;
                SpaceInst spaceInstFather = this.spaceManager.getSpaceInstById(spaceId);
                if (spaceInstFather.isInheritanceBlocked() && (spaceSpecificProfile = this.spaceProfileManager.getSpaceProfileInstByName(spaceId, newSpaceProfile.getName())) != null) {
                    SpaceProfileInst profileToSpread = new SpaceProfileInst();
                    profileToSpread.setName(newSpaceProfile.getName());
                    profileToSpread.setInherited(true);
                    profileToSpread.addGroups(spaceSpecificProfile.getAllGroups());
                    profileToSpread.addUsers(spaceSpecificProfile.getAllUsers());
                    this.spreadSpaceProfile(spaceId, profileToSpread);
                }
                return null;
            }
            String spaceProfileNewId = this.spaceProfileManager.updateSpaceProfileInst(oldSpaceProfile, newSpaceProfile);
            if (!oldSpaceProfile.isManager()) {
                if (StringUtil.isDefined((String)userId)) {
                    SpaceInst spaceInstFather = this.getSpaceInstById(spaceId);
                    spaceInstFather.setUpdaterUserId(userId);
                    this.updateSpaceInst(spaceInstFather);
                }
                ArrayList<SpaceProfileInst> allProfileSources = new ArrayList<SpaceProfileInst>();
                allProfileSources.add(newSpaceProfile);
                if (newSpaceProfile.isInherited()) {
                    allProfileSources.add(this.spaceProfileManager.getSpaceProfileInstByName(spaceId, oldSpaceProfile.getName()));
                } else {
                    allProfileSources.add(this.spaceProfileManager.getInheritedSpaceProfileInstByName(spaceId, oldSpaceProfile.getName()));
                }
                SpaceProfileInst profileToSpread = new SpaceProfileInst();
                profileToSpread.setName(oldSpaceProfile.getName());
                profileToSpread.setInherited(true);
                allProfileSources.remove(null);
                for (SpaceProfileInst spaceProfile : allProfileSources) {
                    profileToSpread.addGroups(spaceProfile.getAllGroups());
                    profileToSpread.addUsers(spaceProfile.getAllUsers());
                }
                this.spreadSpaceProfile(spaceId, profileToSpread);
            }
            this.cache.opUpdateSpaceProfile(this.spaceProfileManager.getSpaceProfileInst(newSpaceProfile.getId(), false));
            return spaceProfileNewId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)SPACE_PROFILE, (Object)newSpaceProfile.getId()), e);
        }
    }

    private String spaceRole2ComponentRole(String spaceRole, String componentName) {
        return this.roleMapping.spaceRoleToComponentOne(spaceRole, componentName);
    }

    private List<String> componentRole2SpaceRoles(String componentRole, String componentName) {
        ArrayList<String> roles = new ArrayList<String>();
        for (SilverpeasRole role : InheritableSpaceRoles.getAllRoles()) {
            String mappedRole = this.spaceRole2ComponentRole(role.getName(), componentName);
            if (mappedRole == null || !mappedRole.equalsIgnoreCase(componentRole)) continue;
            roles.add(role.getName());
        }
        return roles;
    }

    private void spreadSpaceProfile(int spaceId, SpaceProfileInst spaceProfile) throws AdminException {
        List<ComponentInstLight> components = this.treeCache.getComponents(spaceId);
        this.spreadSpaceProfilesInComponents(spaceId, spaceProfile, components);
        List<SpaceInstLight> subSpaces = this.treeCache.getSubSpaces(spaceId);
        this.spreadSpaceProfilesInSubspaces(spaceProfile, subSpaces);
    }

    private void spreadSpaceProfilesInSubspaces(SpaceProfileInst spaceProfile, List<SpaceInstLight> subSpaces) throws AdminException {
        for (SpaceInstLight subSpace : subSpaces) {
            if (subSpace.isInheritanceBlocked()) continue;
            SpaceProfileInst subSpaceProfile = this.spaceProfileManager.getInheritedSpaceProfileInstByName(subSpace.getLocalId(), spaceProfile.getName());
            if (subSpaceProfile != null) {
                subSpaceProfile.setGroups(spaceProfile.getAllGroups());
                subSpaceProfile.setUsers(spaceProfile.getAllUsers());
                this.updateSpaceProfileInst(subSpaceProfile);
                continue;
            }
            subSpaceProfile = new SpaceProfileInst();
            subSpaceProfile.setName(spaceProfile.getName());
            subSpaceProfile.setInherited(true);
            subSpaceProfile.setSpaceFatherId(String.valueOf(subSpace.getLocalId()));
            subSpaceProfile.addGroups(spaceProfile.getAllGroups());
            subSpaceProfile.addUsers(spaceProfile.getAllUsers());
            if (subSpaceProfile.getAllGroups().isEmpty() && subSpaceProfile.getAllUsers().isEmpty()) continue;
            this.addSpaceProfileInst(subSpaceProfile, null);
        }
    }

    private void spreadSpaceProfilesInComponents(int spaceId, SpaceProfileInst spaceProfile, List<ComponentInstLight> components) throws AdminException {
        for (ComponentInstLight component : components) {
            String componentRole;
            if (component == null || component.isInheritanceBlocked() || (componentRole = this.spaceRole2ComponentRole(spaceProfile.getName(), component.getName())) == null) continue;
            ProfileInst inheritedProfile = this.profileManager.getInheritedProfileInst(component.getLocalId(), componentRole);
            if (inheritedProfile != null) {
                this.updateInheritedProfileInsts(spaceId, spaceProfile, inheritedProfile, componentRole, component);
                continue;
            }
            this.addNewProfileInsts(spaceProfile, componentRole, component);
        }
    }

    private void addNewProfileInsts(SpaceProfileInst spaceProfile, String componentRole, ComponentInstLight component) throws AdminException {
        ProfileInst inheritedProfile = new ProfileInst();
        inheritedProfile.setComponentFatherId(component.getLocalId());
        inheritedProfile.setName(componentRole);
        inheritedProfile.setInherited(true);
        inheritedProfile.addGroups(spaceProfile.getAllGroups());
        inheritedProfile.addUsers(spaceProfile.getAllUsers());
        if (inheritedProfile.getNumGroup() > 0 || inheritedProfile.getNumUser() > 0) {
            this.addProfileInst(inheritedProfile);
        }
    }

    private void updateInheritedProfileInsts(int spaceId, SpaceProfileInst spaceProfile, ProfileInst inheritedProfile, String componentRole, ComponentInstLight component) throws AdminException {
        inheritedProfile.removeAllGroups();
        inheritedProfile.removeAllUsers();
        inheritedProfile.addGroups(spaceProfile.getAllGroups());
        inheritedProfile.addUsers(spaceProfile.getAllUsers());
        List<String> profilesToCheck = this.componentRole2SpaceRoles(componentRole, component.getName());
        profilesToCheck.remove(spaceProfile.getName());
        for (String profileToCheck : profilesToCheck) {
            Stream.of(this.spaceProfileManager.getInheritedSpaceProfileInstByName(spaceId, profileToCheck), this.spaceProfileManager.getSpaceProfileInstByName(spaceId, profileToCheck)).filter(Objects::nonNull).forEach(p -> {
                inheritedProfile.addGroups(p.getAllGroups());
                inheritedProfile.addUsers(p.getAllUsers());
            });
        }
        this.updateProfileInst(inheritedProfile);
    }

    @Override
    public String getGroupName(String sGroupId) throws AdminException {
        return this.getGroup(sGroupId).getName();
    }

    @Override
    public List<GroupDetail> getAllGroups() throws AdminException {
        return this.groupManager.getAllGroups();
    }

    @Override
    public boolean isGroupExist(String groupName) throws AdminException {
        return this.groupManager.isGroupExist(groupName);
    }

    @Override
    public GroupDetail getGroup(String groupId) throws AdminException {
        return this.groupManager.getGroup(groupId);
    }

    @Override
    public List<String> getPathToGroup(String groupId) throws AdminException {
        return this.groupManager.getPathToGroup(groupId);
    }

    @Override
    public GroupDetail getGroupByNameInDomain(String groupName, String domainFatherId) throws AdminException {
        if (domainFatherId.equals("-1")) {
            GroupsSearchCriteria criteria = new GroupsSearchCriteria().onName(groupName).onDomainIds(domainFatherId);
            SilverpeasList<GroupDetail> groups = this.searchGroups(criteria);
            if (groups.size() > 1) {
                throw new AdminException("More than one group exists with the name " + groupName + " in the domain " + domainFatherId, new String[0]);
            }
            UnaryOperator loadGroupUserIds = g -> {
                try {
                    List<String> userIds = this.userManager.getAllUserIdsInGroups(List.of(g.getId()));
                    g.setUserIds(userIds.toArray(new String[0]));
                    return g;
                }
                catch (AdminException e) {
                    throw new SilverpeasRuntimeException((Throwable)((Object)e));
                }
            };
            return groups.stream().findFirst().map(loadGroupUserIds).orElse(null);
        }
        return this.groupManager.getGroupByNameInDomain(groupName, domainFatherId);
    }

    @Override
    public GroupDetail[] getGroups(String[] asGroupId) throws AdminException {
        if (asGroupId == null) {
            return new GroupDetail[0];
        }
        GroupDetail[] aGroup = new GroupDetail[asGroupId.length];
        for (int nI = 0; nI < asGroupId.length; ++nI) {
            aGroup[nI] = this.getGroup(asGroupId[nI]);
        }
        return aGroup;
    }

    @Override
    public String addGroup(GroupDetail group) throws AdminException {
        return this.addGroup(group, false);
    }

    @Override
    public String addGroup(GroupDetail group, boolean onlyInSilverpeas) throws AdminException {
        try {
            String groupId = this.groupManager.addGroup(group, onlyInSilverpeas, true);
            group.setId(groupId);
            this.synchroGroupManager.updateContextWith(group);
            this.cache.opAddGroup(group);
            return groupId;
        }
        catch (AdminException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP, (Object)group.getName()), e);
        }
    }

    @Override
    public List<GroupDetail> restoreGroup(String groupId) throws AdminException {
        GroupDetail group = this.getGroup(groupId);
        if (group == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)groupId), new String[0]);
        }
        try {
            List<GroupDetail> restoredGroups = this.groupManager.restoreGroup(group, true);
            restoredGroups.forEach(this.synchroGroupManager::updateContextWith);
            if (!restoredGroups.isEmpty()) {
                this.cache.resetCache();
            }
            return restoredGroups;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)GROUP, (Object)groupId), e);
        }
    }

    @Override
    public List<GroupDetail> removeGroup(String groupId) throws AdminException {
        GroupDetail group = this.getGroup(groupId);
        if (group == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)groupId), new String[0]);
        }
        try {
            List<GroupDetail> removedGroups = this.groupManager.removeGroup(group, true);
            removedGroups.forEach(g -> {
                this.synchroGroupManager.removeFromContext((Group)g);
                this.cache.opRemoveGroup((Group)g);
            });
            return removedGroups;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)GROUP, (Object)groupId), e);
        }
    }

    @Override
    public List<GroupDetail> deleteGroupById(String sGroupId) throws AdminException {
        try {
            return this.deleteGroupById(sGroupId, false);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP, (Object)sGroupId), e);
        }
    }

    @Override
    public List<GroupDetail> deleteGroupById(String sGroupId, boolean onlyInSilverpeas) throws AdminException {
        GroupDetail group = this.getGroup(sGroupId);
        if (group == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)sGroupId), new String[0]);
        }
        try {
            this.deleteGroupProfileInst(sGroupId);
            List<GroupDetail> deletedGroups = this.groupManager.deleteGroup(group, onlyInSilverpeas);
            deletedGroups.forEach(g -> {
                this.synchroGroupManager.removeFromContext((Group)g);
                this.cache.opRemoveGroup((Group)g);
            });
            return deletedGroups;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP, (Object)group.getId()), e);
        }
    }

    @Override
    public String copyGroup(GroupDetail group, String groupParentId) throws AdminException {
        try {
            this.assertGroupValidAndBelongsToDomain(groupParentId, group.getDomainId());
            Date now = new Date();
            GroupDetail copy = new GroupDetail(group);
            copy.setId(null);
            copy.setSpecificId(null);
            copy.setSuperGroupId(groupParentId);
            copy.setCreationDate(now);
            copy.setStateSaveDate(now);
            copy.setSaveDate(now);
            return (String)Transaction.performInOne(() -> {
                String groupId = this.addGroup(copy);
                List<GroupDetail> subgroups = group.getSubGroups();
                for (GroupDetail subgroup : subgroups) {
                    this.copyGroup(subgroup, groupId);
                }
                return groupId;
            });
        }
        catch (Exception e) {
            throw new AdminException("Failure while copying the group " + group.getId(), e);
        }
    }

    @Override
    public void moveGroup(GroupDetail group, String groupParentId) throws AdminException {
        this.assertGroupValidAndBelongsToDomain(groupParentId, group.getDomainId());
        group.setSuperGroupId(groupParentId);
        this.updateGroup(group);
    }

    private void assertGroupValidAndBelongsToDomain(String groupId, String domainId) throws AdminException {
        if (groupId != null) {
            String errorMsgPattern = "The group {0} {1}";
            GroupDetail group = this.getGroup(groupId);
            if (group == null) {
                throw new AdminException(MessageFormat.format("The group {0} {1}", groupId, "doesn't exist!"), new String[0]);
            }
            if (!group.isValidState()) {
                throw new AdminException(MessageFormat.format("The group {0} {1}", groupId, "isn't valid"), new String[0]);
            }
            if (!Objects.equals(group.getDomainId(), domainId)) {
                throw new AdminException(MessageFormat.format("The group {0} {1}", groupId, "doesn't belong to the domain " + domainId), new String[0]);
            }
        }
    }

    @Override
    public String updateGroup(GroupDetail group) throws AdminException {
        try {
            return this.updateGroup(group, false);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP, (Object)group.getId()), e);
        }
    }

    @Override
    public String updateGroup(GroupDetail group, boolean onlyInSilverpeas) throws AdminException {
        try {
            String groupId = this.groupManager.updateGroup(group, onlyInSilverpeas);
            this.synchroGroupManager.updateContextWith(group);
            this.cache.resetOnUpdateGroup();
            return groupId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP, (Object)group.getId()), e);
        }
    }

    @Override
    public void removeUserFromGroup(String sUserId, String sGroupId) throws AdminException {
        try {
            this.groupManager.removeUserFromGroup(sUserId, sGroupId);
            this.cache.resetOnUpdateGroup();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)(USER + sUserId), (Object)(IN_GROUP + sGroupId)), e);
        }
    }

    @Override
    public void addUserInGroup(String sUserId, String sGroupId) throws AdminException {
        try {
            this.groupManager.addUserInGroup(sUserId, sGroupId);
            this.cache.resetOnUpdateGroup();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)(USER + sUserId), (Object)(IN_GROUP + sGroupId)), e);
        }
    }

    @Override
    public List<GroupDetail> getAllRootGroups() throws AdminException {
        return this.groupManager.getAllRootGroups();
    }

    @Override
    public GroupProfileInst getGroupProfileInst(String groupId) throws AdminException {
        return this.groupProfileManager.getGroupProfileInst(groupId, false);
    }

    @Override
    public void addGroupProfileInst(GroupProfileInst groupProfileInst) throws AdminException {
        try {
            GroupDetail group = this.getGroup(groupProfileInst.getGroupId());
            String sProfileId = this.groupProfileManager.createGroupProfileInst(groupProfileInst, group.getId());
            groupProfileInst.setId(sProfileId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP_PROFILE, (Object)groupProfileInst.getName()), e);
        }
    }

    @Override
    public void deleteGroupProfileInst(String groupId) throws AdminException {
        GroupProfileInst groupProfileInst = this.groupProfileManager.getGroupProfileInst(groupId, true);
        if (groupProfileInst != null) {
            try {
                this.groupProfileManager.deleteGroupProfileInst(groupProfileInst);
            }
            catch (Exception e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP_PROFILE, (Object)groupId), e);
            }
        }
    }

    @Override
    public void updateGroupProfileInst(GroupProfileInst groupProfileInstNew) throws AdminException {
        String sSpaceProfileNewId = groupProfileInstNew.getId();
        if (!StringUtil.isDefined((String)sSpaceProfileNewId)) {
            this.addGroupProfileInst(groupProfileInstNew);
        } else {
            try {
                GroupProfileInst oldSpaceProfile = this.groupProfileManager.getGroupProfileInst(groupProfileInstNew.getGroupId(), false);
                this.groupProfileManager.updateGroupProfileInst(oldSpaceProfile, groupProfileInstNew);
            }
            catch (Exception e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP_PROFILE, (Object)groupProfileInstNew.getId()), e);
            }
        }
    }

    @Override
    public void indexAllGroups() throws AdminException {
        Domain[] domains;
        IndexEngineProxy.removeScopedIndexEntries("groups");
        for (Domain domain : domains = this.getAllDomains()) {
            try {
                this.indexGroups(domain.getId());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        try {
            this.indexGroups("-1");
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @Override
    public void indexGroups(String domainId) throws AdminException {
        try {
            this.domainDriverManager.indexAllGroups(domainId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnIndexing((String)"groups in domain", (Object)domainId), e);
        }
    }

    @Override
    public String[] getAllUsersIds() throws AdminException {
        List<String> userIds = this.userManager.getAllUsersIds();
        return userIds.toArray(new String[0]);
    }

    @Override
    public UserDetail getUserDetail(String sUserId) throws AdminException {
        UserDetail ud;
        if (!StringUtil.isDefined((String)sUserId)) {
            return null;
        }
        if (sUserId.equals("-1")) {
            return UserDetail.getSystemUser();
        }
        Optional<UserDetail> optionalUser = this.cache.getUserDetail(sUserId);
        if (optionalUser.isEmpty()) {
            ud = this.userManager.getUserDetail(sUserId);
            if (ud != null) {
                this.cache.putUserDetail(sUserId, ud);
            }
        } else {
            ud = optionalUser.get();
        }
        return ud == null ? null : new UserDetail(ud);
    }

    @Override
    public UserDetail[] getUserDetails(String[] userIds) {
        if (userIds == null) {
            return new UserDetail[0];
        }
        ArrayList<UserDetail> users = new ArrayList<UserDetail>(userIds.length);
        for (String userId : userIds) {
            try {
                users.add(this.getUserDetail(userId));
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            }
        }
        return users.toArray(new UserDetail[0]);
    }

    @Override
    public List<UserDetail> getAllUsers() throws AdminException {
        return this.userManager.getAllUsers();
    }

    @Override
    public List<UserDetail> getAllUsersFromNewestToOldest() throws AdminException {
        return this.userManager.getAllUsersFromNewestToOldest();
    }

    @Override
    public boolean isEmailExisting(String email) throws AdminException {
        return this.userManager.isEmailExisting(email);
    }

    @Override
    public String getUserIdByLoginAndDomain(String sLogin, String sDomainId) throws AdminException {
        String valret = null;
        if (!StringUtil.isDefined((String)sDomainId)) {
            Domain[] theDomains;
            try {
                theDomains = this.domainDriverManager.getAllDomains();
            }
            catch (Exception e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user by login and domain:", (Object)(sLogin + "/" + sDomainId)), e);
            }
            for (int i = 0; i < theDomains.length && valret == null; ++i) {
                try {
                    valret = this.userManager.getUserIdByLoginAndDomain(sLogin, theDomains[i].getId());
                    continue;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user by login and domain:", (Object)(sLogin + "/" + sDomainId)), e);
                }
            }
            if (valret == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)"in all domains user with login", (Object)sLogin), new String[0]);
            }
        } else {
            valret = this.userManager.getUserIdByLoginAndDomain(sLogin, sDomainId);
        }
        return valret;
    }

    @Override
    public String getUserIdByAuthenticationKey(String authenticationKey) throws AdminException {
        Map<String, String> userParameters = this.domainDriverManager.authenticate(authenticationKey);
        String login = userParameters.get(LOGIN_PARAM);
        String domainId = userParameters.get(DOMAIN_ID_PARAM);
        return this.userManager.getUserIdByLoginAndDomain(login, domainId);
    }

    @Override
    public UserFull getUserFull(String sUserId) throws AdminException {
        return this.userManager.getUserFull(sUserId);
    }

    @Override
    public List<UserFull> getUserFulls(Collection<String> userIds) throws AdminException {
        return this.userManager.listUserFulls(userIds);
    }

    @Override
    public UserFull getUserFull(String domainId, String specificId) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        return synchroDomain.getUserFull(specificId);
    }

    @Override
    public String addUser(UserDetail userDetail) throws AdminException {
        try {
            return this.addUser(userDetail, false);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)userDetail.getDisplayedName()), e);
        }
    }

    @Override
    public String addUser(UserDetail userDetail, boolean addOnlyInSilverpeas) throws AdminException {
        try {
            return this.userManager.addUser(userDetail, addOnlyInSilverpeas, true);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)userDetail.getDisplayedName()), e);
        }
    }

    @Override
    public void migrateUser(UserDetail userDetail, String targetDomainId) throws AdminException {
        try {
            this.userManager.migrateUser(userDetail, targetDomainId);
            this.cache.opUpdateUser(userDetail);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)(USER + userDetail.getId()), (Object)("in domain " + targetDomainId)), e);
        }
    }

    @Override
    public void blockUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.BLOCKED);
    }

    @Override
    public void unblockUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.VALID);
    }

    @Override
    public void deactivateUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.DEACTIVATED);
    }

    @Override
    public void activateUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.VALID);
    }

    @Override
    public void setUserSensitiveData(String userId, boolean sensitive) throws AdminException {
        try {
            UserDetail user = this.getUserDetail(userId);
            user.setSensitiveData(sensitive);
            this.updateUser(user);
        }
        catch (Exception e) {
            String msg = sensitive ? "Some data as sensitive for user " : "Some data as non sensitive for user ";
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)msg, (Object)userId), e);
        }
    }

    private void updateUserState(String userId, UserState state) throws AdminException {
        try {
            UserDetail user = this.getUserDetail(userId);
            user.setState(state);
            user.setStateSaveDate(new Date());
            this.updateUser(user);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)("state of user " + userId), (Object)("to " + state.getName())), e);
        }
    }

    @Override
    public void userAcceptsTermsOfService(String userId) throws AdminException {
        try {
            UserDetail user = this.getUserDetail(userId);
            user.setTosAcceptanceDate(DateUtil.getNow());
            this.updateUser(user);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"terms of service acceptance for user", (Object)userId), e);
        }
    }

    @Override
    public String restoreUser(String sUserId) throws AdminException {
        UserDetail user = this.getUserDetail(sUserId);
        if (user == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"user", (Object)sUserId), new String[0]);
        }
        try {
            String removedUserId = this.userManager.restoreUser(user, true);
            this.cache.resetCache();
            return removedUserId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)"user", (Object)sUserId), e);
        }
    }

    @Override
    public String removeUser(String sUserId) throws AdminException {
        if (ADMIN_ID.equals(sUserId)) {
            SilverLogger.getLogger((Object)this).warn("Attempt to remove the main administrator account by user " + User.getCurrentRequester().getId(), new Object[0]);
            return null;
        }
        UserDetail user = this.getUserDetail(sUserId);
        if (user == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"user", (Object)sUserId), new String[0]);
        }
        try {
            String removedUserId = this.userManager.removeUser(user, true);
            this.cache.opRemoveUser(user);
            return removedUserId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)"user", (Object)sUserId), e);
        }
    }

    @Override
    public String deleteUser(String sUserId) throws AdminException {
        try {
            if (ADMIN_ID.equals(sUserId)) {
                SilverLogger.getLogger((Object)this).warn("Attempt to delete the main administrator account by user " + User.getCurrentRequester().getId(), new Object[0]);
                return null;
            }
            return this.deleteUser(sUserId, false);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)sUserId), e);
        }
    }

    @Override
    public String deleteUser(String sUserId, boolean onlyInSilverpeas) throws AdminException {
        try {
            UserDetail user = this.getUserDetail(sUserId);
            if (user == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)"user", (Object)sUserId), new String[0]);
            }
            String sReturnUserId = this.userManager.deleteUser(user, onlyInSilverpeas);
            this.cache.opRemoveUser(user);
            return sReturnUserId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)sUserId), e);
        }
    }

    @Override
    public String updateUser(UserDetail user) throws AdminException {
        try {
            String sUserId = this.userManager.updateUser(user, true);
            this.cache.opUpdateUser(this.userManager.getUserDetail(sUserId));
            return sUserId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)user.getId()), e);
        }
    }

    @Override
    public String updateUserFull(UserFull user) throws AdminException {
        try {
            String sUserId = this.userManager.updateUserFull(user);
            this.cache.opUpdateUser(this.userManager.getUserDetail(sUserId));
            return sUserId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)user.getId()), e);
        }
    }

    private int getDriverSpaceId(String sClientSpaceId) {
        String clientSpaceId = sClientSpaceId;
        if (clientSpaceId != null) {
            if (clientSpaceId.startsWith("WA")) {
                clientSpaceId = clientSpaceId.substring("WA".length());
            }
            try {
                return Integer.parseInt(clientSpaceId);
            }
            catch (NumberFormatException e) {
                SilverLogger.getLogger((Object)this).warn("can not get driver space id from {0} : {1}", new Object[]{sClientSpaceId, e.getMessage()});
            }
        }
        return -1;
    }

    @Override
    public String getClientSpaceId(String sDriverSpaceId) {
        if (sDriverSpaceId != null && !sDriverSpaceId.startsWith("WA")) {
            return "WA" + sDriverSpaceId;
        }
        return sDriverSpaceId;
    }

    @Override
    public String[] getClientSpaceIds(String[] asDriverSpaceIds) {
        String[] asClientSpaceIds = new String[asDriverSpaceIds.length];
        for (int nI = 0; nI < asDriverSpaceIds.length; ++nI) {
            asClientSpaceIds[nI] = this.getClientSpaceId(asDriverSpaceIds[nI]);
        }
        return asClientSpaceIds;
    }

    private int getDriverComponentId(String sClientComponentId) {
        if (sClientComponentId == null) {
            return -1;
        }
        return this.getTableClientComponentIdFromClientComponentId(sClientComponentId);
    }

    private int getTableClientComponentIdFromClientComponentId(String sClientComponentId) {
        String sTableClientId = "";
        char[] cBuf = sClientComponentId.toCharArray();
        if (Character.isDigit(cBuf[cBuf.length - 1])) {
            for (int nI = 0; nI < cBuf.length && sTableClientId.isEmpty(); ++nI) {
                if (!Character.isDigit(cBuf[nI])) continue;
                sTableClientId = sClientComponentId.substring(nI);
            }
            if (StringUtil.isDefined((String)sTableClientId)) {
                return Integer.parseInt(sTableClientId);
            }
        }
        return -1;
    }

    private String getClientComponentId(ComponentInst component) {
        return this.getClientComponentId(component.getName(), component.getId());
    }

    private String getClientComponentId(String componentName, String sDriverComponentId) {
        if (StringUtil.isInteger((String)sDriverComponentId)) {
            return componentName + sDriverComponentId;
        }
        return sDriverComponentId;
    }

    @Override
    public String getNextDomainId() throws AdminException {
        try {
            return this.domainDriverManager.getNextDomainId();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    @Override
    public String addDomain(Domain theDomain) throws AdminException {
        try {
            String id = this.domainDriverManager.createDomain(theDomain);
            DomainDriver domainDriver = this.domainDriverManager.getDomainDriver(id);
            if (domainDriver.isSynchroThreaded()) {
                this.domainSynchroScheduler.addDomain(id);
            }
            return id;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)DOMAIN, (Object)theDomain.getName()), e);
        }
    }

    @Override
    public String updateDomain(Domain domain) throws AdminException {
        try {
            this.domainCache.removeDomain(domain.getId());
            return this.domainDriverManager.updateDomain(domain);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)DOMAIN, (Object)domain.getId()), e);
        }
    }

    @Override
    public String removeDomain(String domainId) throws AdminException {
        try {
            GroupDetail[] toRemoveGroups;
            UserDetail[] toRemoveUDs = this.userManager.getAllUsersInDomain(domainId, true);
            if (toRemoveUDs != null) {
                SilverLogger.getLogger((Object)this).debug("[Domain deletion] Remove all the users...", new Object[0]);
                for (UserDetail user : toRemoveUDs) {
                    this.deleteUser(user.getId(), false);
                }
            }
            if ((toRemoveGroups = this.groupManager.getRootGroupsOfDomain(domainId)) != null) {
                SilverLogger.getLogger((Object)this).debug("[Domain deletion] Remove all the groups...", new Object[0]);
                for (GroupDetail group : toRemoveGroups) {
                    this.deleteGroupById(group.getId(), false);
                }
            }
            SilverLogger.getLogger((Object)this).debug("[Domain deletion] Then remove the domain...", new Object[0]);
            this.domainDriverManager.removeDomain(domainId);
            this.domainSynchroScheduler.removeDomain(domainId);
            this.domainCache.removeDomain(domainId);
            return domainId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)DOMAIN, (Object)domainId), e);
        }
    }

    @Override
    public Domain[] getAllDomains() throws AdminException {
        try {
            return this.domainDriverManager.getAllDomains();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all domains", (Object)"in Silverpeas"), e);
        }
    }

    @Override
    public Domain getDomain(String domainId) throws AdminException {
        try {
            Domain domain;
            Optional<Domain> optionalDomain;
            if (!StringUtil.isDefined((String)domainId) || !StringUtil.isInteger((String)domainId)) {
                domainId = "-1";
            }
            if ((optionalDomain = this.domainCache.getDomain(domainId)).isEmpty()) {
                domain = this.domainDriverManager.getDomain(domainId);
                this.domainCache.addDomain(domain);
            } else {
                domain = optionalDomain.get();
            }
            return domain;
        }
        catch (AdminNotFoundException e) {
            SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public long getDomainActions(String domainId) throws AdminException {
        try {
            if (domainId != null && domainId.equals("-1")) {
                return 426L;
            }
            return this.domainDriverManager.getDomainActions(domainId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"actions of domain", (Object)domainId), e);
        }
    }

    @Override
    public GroupDetail[] getRootGroupsOfDomain(String domainId) throws AdminException {
        try {
            return this.groupManager.getRootGroupsOfDomain(domainId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"root groups of domain", (Object)domainId), e);
        }
    }

    @Override
    public List<GroupDetail> getSynchronizedGroups() throws AdminException {
        try {
            return this.groupManager.getSynchronizedGroups();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"synchronized groups", (Object)""), e);
        }
    }

    @Override
    public UserDetail[] getAllUsersOfGroup(String groupId) throws AdminException {
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(groupId);
            groupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(groupId));
            return this.userManager.getAllUsersInGroups(groupIds);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all users in group", (Object)groupId), e);
        }
    }

    @Override
    public UserDetail[] getUsersOfDomain(String domainId) throws AdminException {
        try {
            if ("-1".equals(domainId)) {
                return new UserDetail[0];
            }
            return this.userManager.getAllUsersInDomain(domainId, false);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all users in domain", (Object)domainId), e);
        }
    }

    @Override
    public List<UserDetail> getUsersOfDomains(List<String> domainIds) throws AdminException {
        return this.userManager.getUsersOfDomains(domainIds);
    }

    @Override
    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) throws AdminException {
        return this.userManager.getUsersOfDomainsFromNewestToOldest(domainIds);
    }

    @Override
    public String[] getUserIdsOfDomain(String domainId) throws AdminException {
        try {
            if ("-1".equals(domainId)) {
                return ArrayUtil.emptyStringArray();
            }
            List<String> userIds = this.userManager.getAllUserIdsInDomain(domainId);
            return userIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all users in domain", (Object)domainId), e);
        }
    }

    @Override
    public String identify(String sKey, String sSessionId, boolean isAppInMaintenance) throws AdminException {
        return this.identify(sKey, sSessionId, isAppInMaintenance, true);
    }

    @Override
    public String identify(String sKey, String sSessionId, boolean isAppInMaintenance, boolean removeKey) throws AdminException {
        try {
            Map<String, String> loginDomain = this.domainDriverManager.authenticate(sKey, removeKey);
            if (!loginDomain.containsKey(LOGIN_PARAM) || !loginDomain.containsKey(DOMAIN_ID_PARAM)) {
                throw new AdminException(SilverpeasExceptionMessages.undefined((String)("domain for authentication key " + sKey)), new String[0]);
            }
            String sLogin = loginDomain.get(LOGIN_PARAM);
            String sDomainId = loginDomain.get(DOMAIN_ID_PARAM);
            DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(sDomainId);
            String sUserId = this.synchroGetUserId(isAppInMaintenance, sLogin, sDomainId, synchroDomain);
            this.doSynchronizeUser(sUserId, synchroDomain, isAppInMaintenance);
            return sUserId;
        }
        catch (Exception e) {
            throw new AdminException("Fail to identify authentication key " + sKey, e);
        }
    }

    private void doSynchronizeUser(String sUserId, DomainDriver synchroDomain, boolean isAppInMaintenance) {
        if (synchroDomain.isSynchroOnLoginEnabled() && !isAppInMaintenance) {
            try {
                this.synchronizeUser(sUserId, synchroDomain.isSynchroOnLoginRecursToGroups(), false);
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
            }
        }
    }

    private String synchroGetUserId(boolean isAppInMaintenance, String sLogin, String sDomainId, DomainDriver synchroDomain) throws AdminException {
        String sUserId;
        try {
            sUserId = this.userManager.getUserIdByLoginAndDomain(sLogin, sDomainId);
        }
        catch (Exception ex) {
            if (synchroDomain.isSynchroOnLoginEnabled() && !isAppInMaintenance) {
                SilverLogger.getLogger((Object)this).warn("User with login {0} in domain {1} not found", new Object[]{sLogin, sDomainId});
                sUserId = this.synchronizeImportUserByLogin(sDomainId, sLogin, synchroDomain.isSynchroOnLoginRecursToGroups());
            }
            throw ex;
        }
        return sUserId;
    }

    @Override
    public List<GroupDetail> getDirectGroupsOfUser(String userId) throws AdminException {
        try {
            return this.groupManager.getDirectGroupsOfUser(userId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"direct groups of user", (Object)userId), e);
        }
    }

    @Override
    public String[] getUserSpaceIds(String sUserId) throws AdminException {
        ArrayList<String> spaceIds = new ArrayList<String>();
        List<String> componentIds = this.getAllowedComponentIds(sUserId);
        for (String componentId : componentIds) {
            List<SpaceInstLight> spaces = this.treeCache.getComponentPath(componentId);
            for (SpaceInstLight space : spaces) {
                if (spaceIds.contains(space.getId())) continue;
                spaceIds.add(space.getId());
            }
        }
        return spaceIds.toArray(new String[0]);
    }

    private List<String> getAllGroupsOfUser(String userId) throws AdminException {
        List<String> allGroupsOfUser;
        Optional<List<String>> optionalGroups = this.groupCache.getAllGroupIdsOfUser(userId);
        if (optionalGroups.isEmpty()) {
            allGroupsOfUser = this.groupManager.getAllGroupsOfUser(userId);
            this.groupCache.setAllGroupIdsOfUser(userId, allGroupsOfUser);
        } else {
            allGroupsOfUser = optionalGroups.get();
        }
        return allGroupsOfUser;
    }

    private List<String> getAllowedComponentIds(String userId) throws AdminException {
        return this.getAllowedComponentIds(userId, null);
    }

    private List<String> getAllowedComponentIds(String userId, String componentName) throws AdminException {
        List<String> allGroupsOfUser = this.getAllGroupsOfUser(userId);
        return this.componentManager.getAllowedComponentIds(Integer.parseInt(userId), allGroupsOfUser, null, componentName);
    }

    @Override
    public String[] getUserRootSpaceIds(String sUserId) throws AdminException {
        try {
            List<String> componentIds = this.getAllowedComponentIds(sUserId);
            return this.getRootSpaceIds(componentIds);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"root spaces accessible by user", (Object)sUserId), e);
        }
    }

    private String[] getRootSpaceIds(List<String> componentIds) throws AdminException {
        HashSet<String> indexedComponentIds = new HashSet<String>(componentIds);
        String[] rootSpaceIds = this.getAllRootSpaceIds();
        return (String[])Stream.of(rootSpaceIds).filter(i -> this.isSpaceContainsOneComponent(indexedComponentIds, this.getDriverSpaceId((String)i))).toArray(String[]::new);
    }

    @Override
    public String[] getUserSubSpaceIds(String sUserId, String spaceId) throws AdminException {
        try {
            List<String> componentIds = this.getAllowedComponentIds(sUserId);
            return this.getSubSpaceIds(componentIds, spaceId, true);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)(SUBSPACES_OF_SPACE + spaceId), (Object)(ACCESSIBLE_BY_USER + sUserId)), e);
        }
    }

    private String[] getSubSpaceIds(List<String> componentIds, String spaceId, boolean ignoreEmptySpaces) {
        Stream<Object> subspaces = this.treeCache.getSubSpaces(this.getDriverSpaceId(spaceId)).stream();
        if (ignoreEmptySpaces) {
            HashSet<String> indexedComponentIds = new HashSet<String>(componentIds);
            subspaces = subspaces.filter(s -> this.isSpaceContainsOneComponent(indexedComponentIds, s.getLocalId()));
        }
        return (String[])subspaces.map(SpaceInstLight::getId).toArray(String[]::new);
    }

    @Override
    public boolean isSpaceAvailable(String userId, String spaceId) throws AdminException {
        return this.getUserSpaceAvailabilityChecker(userId).isAvailable(spaceId);
    }

    @Override
    public UserSpaceAvailabilityChecker getUserSpaceAvailabilityChecker(String userId) throws AdminException {
        return new UserSpaceAvailabilityChecker(userId, this.getAllowedComponentIds(userId), this::getDriverSpaceId, this::isSpaceContainsOneComponent);
    }

    private boolean isSpaceContainsOneComponent(Set<String> componentIds, int spaceId) {
        List<ComponentInstLight> components = this.treeCache.getComponents(spaceId);
        if (components.stream().noneMatch(c -> componentIds.contains(c.getId()))) {
            List<SpaceInstLight> subspaces = this.treeCache.getSubSpaces(spaceId);
            return subspaces.stream().anyMatch(s -> this.isSpaceContainsOneComponent(componentIds, s.getLocalId()));
        }
        return true;
    }

    @Override
    public List<SpaceInstLight> getSubSpaces(String spaceId) throws AdminException {
        return this.spaceManager.getSubSpaces(this.getDriverSpaceId(spaceId));
    }

    @Override
    public List<ComponentInstLight> getAvailCompoInSpace(String userId, String spaceId) throws AdminException {
        try {
            List<String> allowedComponentIds = this.getAllowedComponentIds(userId);
            ArrayList<ComponentInstLight> allowedComponents = new ArrayList<ComponentInstLight>();
            List<ComponentInstLight> allComponents = this.treeCache.getComponentsInSpaceAndSubspaces(this.getDriverSpaceId(spaceId));
            for (ComponentInstLight component : allComponents) {
                if (!allowedComponentIds.contains(component.getId())) continue;
                allowedComponents.add(component);
            }
            return allowedComponents;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)(COMPONENTS_IN_SPACE + spaceId), (Object)(ACCESSIBLE_BY_USER + userId)), e);
        }
    }

    @Override
    public List<SpaceInstLight> getUserSpaceTreeview(String userId) throws AdminException {
        HashSet<String> componentIds = new HashSet<String>(Arrays.asList(this.getAvailCompoIds(userId)));
        HashSet authorizedIds = new HashSet(100);
        while (!componentIds.isEmpty()) {
            String componentId = (String)componentIds.iterator().next();
            componentIds.remove(componentId);
            Optional<SpaceInstLight> space = this.treeCache.getSpaceContainingComponent(componentId);
            space.ifPresent(s -> this.addAuthorizedSpace(authorizedIds, (Set<String>)componentIds, (SpaceInstLight)s));
        }
        String[] rootSpaceIds = this.getAllRootSpaceIds(userId);
        ArrayList<SpaceInstLight> treeview = new ArrayList<SpaceInstLight>(authorizedIds.size());
        for (String spaceId : rootSpaceIds) {
            int currentSpaceId = this.getDriverSpaceId(spaceId);
            if (!authorizedIds.contains(currentSpaceId)) continue;
            Optional<SpaceInstLight> optionalSpace = this.treeCache.getSpaceInstLight(currentSpaceId);
            optionalSpace.ifPresent(s -> {
                treeview.add((SpaceInstLight)s);
                this.addAuthorizedSpaceToTree(treeview, authorizedIds, currentSpaceId, 1);
            });
        }
        return treeview;
    }

    void addAuthorizedSpaceToTree(List<SpaceInstLight> treeview, Set<Integer> authorizedIds, int spaceId, int level) {
        List<SpaceInstLight> subSpaces = this.treeCache.getSubSpaces(spaceId);
        for (SpaceInstLight space : subSpaces) {
            int subSpaceId = space.getLocalId();
            if (!authorizedIds.contains(subSpaceId)) continue;
            space.setLevel(level);
            treeview.add(space);
            this.addAuthorizedSpaceToTree(treeview, authorizedIds, subSpaceId, level + 1);
        }
    }

    private void addAuthorizedSpace(Set<Integer> spaces, Set<String> componentsId, SpaceInstLight space) {
        if (!"R".equals(space.getStatus()) && !spaces.contains(space.getLocalId())) {
            int fatherId;
            int spaceId = space.getLocalId();
            spaces.add(spaceId);
            this.treeCache.getComponentIds(spaceId).forEach(componentsId::remove);
            if (!space.isRoot() && !spaces.contains(fatherId = this.getDriverSpaceId(space.getFatherId()))) {
                Optional<SpaceInstLight> parent = this.treeCache.getSpaceInstLight(fatherId);
                parent.ifPresent(p -> this.addAuthorizedSpace(spaces, componentsId, (SpaceInstLight)p));
            }
        }
    }

    @Override
    public SpaceWithSubSpacesAndComponents getFullTreeview() throws AdminException {
        return this.getFullTreeview(this.componentManager.getAllActiveComponentIds(), false);
    }

    @Override
    public SpaceWithSubSpacesAndComponents getAllowedFullTreeview(String userId) throws AdminException {
        return this.getFullTreeview(this.getAllowedComponentIds(userId), true);
    }

    @Override
    public SpaceWithSubSpacesAndComponents getAllowedFullTreeviewOnComponentName(String userId, String componentName) throws AdminException {
        return this.getFullTreeview(this.getAllowedComponentIds(userId, componentName), true);
    }

    private SpaceWithSubSpacesAndComponents getFullTreeview(List<String> componentIds, boolean ignoreEmptySpaces) throws AdminException {
        String[] spaceIds = this.getRootSpaceIds(componentIds);
        SpaceWithSubSpacesAndComponents root = new SpaceWithSubSpacesAndComponents(new SpaceInstLight());
        ArrayList<SpaceWithSubSpacesAndComponents> spaces = new ArrayList<SpaceWithSubSpacesAndComponents>();
        for (String spaceId : spaceIds) {
            spaces.add(this.geTreeview(componentIds, spaceId, ignoreEmptySpaces));
        }
        root.setSubSpaces(spaces);
        return root;
    }

    @Override
    public SpaceWithSubSpacesAndComponents getAllowedFullTreeview(String userId, String spaceId) throws AdminException {
        List<String> componentIds = this.getAllowedComponentIds(userId);
        return this.geTreeview(componentIds, spaceId, true);
    }

    @Override
    public List<GroupDetail> getRemovedGroups(String ... domainIds) throws AdminException {
        return this.groupManager.getRemovedGroupsOfDomains(domainIds);
    }

    @Override
    public List<UserDetail> getRemovedUsers(String ... domainIds) throws AdminException {
        return this.userManager.getRemovedUsersOfDomains(domainIds);
    }

    @Override
    public List<UserDetail> getNonBlankedDeletedUsers(String ... domainIds) throws AdminException {
        return this.userManager.getNonBlankedDeletedUsersOfDomains(domainIds);
    }

    @Override
    public List<UserDetail> getUsersWithSensitiveData(String ... domainIds) throws AdminException {
        return this.userManager.getUsersWithSensitiveData(domainIds);
    }

    @Override
    public void blankDeletedUsers(String targetDomainId, List<String> userIds) throws AdminException {
        UserDetail[] users;
        for (UserDetail user : users = this.getUserDetails(userIds.toArray(new String[0]))) {
            if (!user.getDomainId().equals(targetDomainId)) continue;
            String userName = user.getDisplayedName();
            this.userManager.blankUser(user);
            this.cache.opUpdateUser(this.userManager.getUserDetail(user.getId()));
            SilverLogger.getLogger((Object)this).info("User " + userName + " blanked", new Object[0]);
        }
    }

    @Override
    public void disableDataSensitivity(String domainId, List<String> userIds) throws AdminException {
        UserDetail[] users;
        for (UserDetail user : users = this.getUserDetails(userIds.toArray(new String[0]))) {
            if (!user.getDomainId().equals(domainId) || !user.hasSensitiveData()) continue;
            user.setSensitiveData(false);
            this.updateUser(user);
        }
    }

    private SpaceWithSubSpacesAndComponents geTreeview(List<String> componentIds, String spaceId, boolean ignoreEmptySpaces) throws AdminException {
        SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
        SpaceWithSubSpacesAndComponents space = new SpaceWithSubSpacesAndComponents(spaceInst);
        String[] subSpaceIds = this.getSubSpaceIds(componentIds, spaceId, ignoreEmptySpaces);
        ArrayList<SpaceWithSubSpacesAndComponents> subSpaces = new ArrayList<SpaceWithSubSpacesAndComponents>(subSpaceIds.length);
        for (String subSpaceId : subSpaceIds) {
            subSpaces.add(this.geTreeview(componentIds, subSpaceId, ignoreEmptySpaces));
        }
        space.setSubSpaces(subSpaces);
        List<SilverpeasComponentInstance> spaceComponents = this.treeCache.getComponents(this.getDriverSpaceId(spaceId)).stream().filter(c -> componentIds.contains(c.getId())).collect(Collectors.toList());
        space.setComponents(spaceComponents);
        return space;
    }

    @Override
    public String[] getAllowedSubSpaceIds(String userId, String spaceFatherId) throws AdminException {
        return this.getUserSubSpaceIds(userId, spaceFatherId);
    }

    private SpaceInstLight getSpaceInstLight(int spaceId) throws AdminException {
        SpaceInstLight sil;
        Optional<SpaceInstLight> optionalSpace = this.treeCache.getSpaceInstLight(spaceId);
        SpaceInstLight spaceInstLight = sil = optionalSpace.isPresent() ? optionalSpace.get() : this.spaceManager.getSpaceInstLightById(spaceId);
        if (sil != null && sil.getLevel() == -1) {
            sil.setLevel(this.treeCache.getSpaceLevel(spaceId));
        }
        return sil;
    }

    @Override
    public SpaceInstLight getSpaceInstLightById(String sClientSpaceId) throws AdminException {
        try {
            return this.getSpaceInstLight(this.getDriverSpaceId(sClientSpaceId));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)SPACE, (Object)sClientSpaceId), e);
        }
    }

    @Override
    public SpaceInstLight getRootSpace(String spaceId) throws AdminException {
        SpaceInstLight sil = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
        while (sil != null && !sil.isRoot()) {
            sil = this.getSpaceInstLight(this.getDriverSpaceId(sil.getFatherId()));
        }
        return sil;
    }

    @Override
    public String[] getGroupManageableSpaceIds(String sGroupId) throws AdminException {
        try {
            List<String> groupIds = List.of(sGroupId);
            List<Integer> directSpaceIds = this.spaceManager.getManageableSpaceIds(null, groupIds);
            ArrayList<SpaceInst> consumer = new ArrayList<SpaceInst>();
            for (Integer directSpaceId : directSpaceIds) {
                consumer.add(this.getSpaceInstById(String.valueOf(directSpaceId)));
            }
            LinkedHashSet<String> allSpaces = new LinkedHashSet<String>();
            while (!consumer.isEmpty()) {
                SpaceInst current = (SpaceInst)consumer.remove(0);
                allSpaces.add(String.valueOf(current.getLocalId()));
                current.getSubSpaces().forEach(s -> consumer.add(0, (SpaceInst)s));
            }
            return allSpaces.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"spaces manageable by group", (Object)sGroupId), e);
        }
    }

    @Override
    public String[] getUserManageableSpaceIds(String sUserId) throws AdminException {
        try {
            String[] result;
            Optional<String[]> cachedSpaceIds = this.cache.getManageableSpaceIds(sUserId);
            if (cachedSpaceIds.isEmpty()) {
                List<String> groupIds = this.getAllGroupsOfUser(sUserId);
                Integer[] directSpaceIds = this.userManager.getManageableSpaceIds(sUserId, groupIds);
                ArrayList<SpaceInst> consumer = new ArrayList<SpaceInst>();
                for (Integer directSpaceId : directSpaceIds) {
                    consumer.add(this.getSpaceInstById(String.valueOf(directSpaceId)));
                }
                LinkedHashSet<String> allSpaces = new LinkedHashSet<String>();
                while (!consumer.isEmpty()) {
                    SpaceInst current = (SpaceInst)consumer.remove(0);
                    allSpaces.add(String.valueOf(current.getLocalId()));
                    current.getSubSpaces().forEach(s -> consumer.add(0, (SpaceInst)s));
                }
                result = allSpaces.toArray(new String[0]);
                this.cache.putManageableSpaceIds(sUserId, result);
            } else {
                result = cachedSpaceIds.get();
            }
            return result;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"spaces manageable by user", (Object)sUserId), e);
        }
    }

    @Override
    public String[] getUserManageableSubSpaceIds(String sUserId, String sParentSpaceId) throws AdminException {
        try {
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            Integer[] asManageableSpaceIds = this.userManager.getManageableSpaceIds(sUserId, groupIds);
            int parentSpaceId = this.getDriverSpaceId(sParentSpaceId);
            ArrayList<String> manageableRootSpaceIds = new ArrayList<String>();
            for (Integer manageableSpaceId : asManageableSpaceIds) {
                boolean find = false;
                Optional<SpaceInstLight> space = this.treeCache.getSpaceInstLight(manageableSpaceId);
                while (space.isPresent() && !space.get().isRoot() && !find) {
                    int driverFatherId = this.getDriverSpaceId(space.get().getFatherId());
                    if (parentSpaceId == driverFatherId) {
                        manageableRootSpaceIds.add(String.valueOf(manageableSpaceId));
                        find = true;
                        continue;
                    }
                    space = this.treeCache.getSpaceInstLight(driverFatherId);
                }
            }
            return manageableRootSpaceIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)(SUBSPACES_OF_SPACE + sParentSpaceId), (Object)("that are manageable by user" + sUserId)), e);
        }
    }

    @Override
    public SpaceProfile getSpaceProfile(String spaceId, SilverpeasRole role) throws AdminException {
        SpaceProfile spaceProfile = new SpaceProfile();
        SpaceInst space = this.getSpaceInstById(spaceId);
        if (space == null) {
            return null;
        }
        List<SpaceProfileInst> profiles = space.getSpaceProfileInst(role.getName());
        if (profiles.isEmpty() && !space.isInheritanceBlocked()) {
            SpaceInst parent = space;
            while (!parent.isRoot()) {
                parent = this.getSpaceInstById(parent.getDomainFatherId());
                SpaceProfileInst parentProfile = parent.getDirectSpaceProfileInst(role.getName());
                spaceProfile.addInheritedProfile(parentProfile);
            }
        } else {
            profiles.forEach(p -> {
                if (p.isInherited()) {
                    spaceProfile.addInheritedProfile((SpaceProfileInst)p);
                } else {
                    spaceProfile.setProfile((SpaceProfileInst)p);
                }
            });
        }
        return spaceProfile;
    }

    @Override
    public List<String> getUserManageableGroupIds(String sUserId) throws AdminException {
        try {
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            return this.groupManager.getManageableGroupIds(sUserId, groupIds);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups manageable by user", (Object)sUserId), e);
        }
    }

    @Override
    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) throws AdminException {
        try {
            String[] asAvailCompoIds;
            int spaceId = this.getDriverSpaceId(sClientSpaceId);
            Optional<String[]> optionalInstanceIds = this.cache.getAvailCompoIds(spaceId, sUserId);
            if (optionalInstanceIds.isEmpty()) {
                asAvailCompoIds = this.getAvailableInstanceIds(sClientSpaceId, sUserId);
                this.cache.putAvailCompoIds(String.valueOf(spaceId), sUserId, asAvailCompoIds);
            } else {
                asAvailCompoIds = optionalInstanceIds.get();
            }
            return asAvailCompoIds;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)(COMPONENTS_IN_SPACE + sClientSpaceId), (Object)(AVAILABLE_TO_USER + sUserId)), e);
        }
    }

    private String[] getAvailableInstanceIds(String clientSpaceId, String userId) throws AdminException {
        ArrayList<String> componentIds = new ArrayList<String>();
        List<ComponentInstLight> components = this.getAvailCompoInSpace(userId, clientSpaceId);
        for (ComponentInstLight component : components) {
            componentIds.add(component.getId());
        }
        return componentIds.toArray(new String[0]);
    }

    @Override
    public boolean isAnAdminTool(String toolId) {
        return "ADMIN".equals(toolId);
    }

    @Override
    public List<String> getAvailableComponentsByUser(String userId) throws AdminException {
        try {
            return this.getAllowedComponentIds(userId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"components available by user", (Object)userId), e);
        }
    }

    @Override
    public boolean isComponentAvailableToUser(String componentId, String userId) throws AdminException {
        try {
            return this.getAllowedComponentIds(userId).contains(componentId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"components available by user", (Object)userId), e);
        }
    }

    @Override
    public boolean isComponentAvailableToGroup(String componentId, String groupId) throws AdminException {
        List<String> groupIds = this.groupManager.getPathToGroup(groupId);
        groupIds.add(groupId);
        return this.componentManager.getAllowedComponentIds(-1, groupIds).contains(componentId);
    }

    @Override
    public boolean isComponentManageable(String componentId, String userId) throws AdminException {
        boolean manageable = this.getUserDetail(userId).isAccessAdmin();
        if (!manageable) {
            List<String> toCheck = Arrays.asList(this.getUserManageableSpaceIds(userId));
            List<SpaceInstLight> path = this.getPathToComponent(componentId);
            for (SpaceInstLight space : path) {
                if (!toCheck.contains(String.valueOf(space.getLocalId()))) continue;
                manageable = true;
                break;
            }
        }
        return manageable;
    }

    @Override
    public String[] getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId) throws AdminException {
        try {
            int spaceId = this.getDriverSpaceId(sClientSpaceId);
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            List<String> asAvailCompoIds = this.componentManager.getAllowedComponentIds(Integer.parseInt(sUserId), groupIds, spaceId);
            return asAvailCompoIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("root components in space " + sClientSpaceId), (Object)(AVAILABLE_TO_USER + sUserId)), e);
        }
    }

    @Override
    public List<String> getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId, String componentNameRoot) throws AdminException {
        try {
            int spaceId = this.getDriverSpaceId(sClientSpaceId);
            List<ComponentInstLight> components = this.treeCache.getComponents(spaceId);
            List<String> allowedComponentIds = this.getAllowedComponentIds(sUserId);
            ArrayList<String> result = new ArrayList<String>();
            for (ComponentInstLight component : components) {
                if (!allowedComponentIds.contains(component.getId()) || !component.getName().startsWith(componentNameRoot)) continue;
                result.add(component.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("root components in space " + sClientSpaceId), (Object)(AVAILABLE_TO_USER + sUserId)), e);
        }
    }

    @Override
    public String[] getAvailCompoIds(String userId) throws AdminException {
        try {
            List<String> componentIds = this.getAllowedComponentIds(userId);
            return componentIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"components available to user", (Object)userId), e);
        }
    }

    @Override
    public String[] getComponentIdsByNameAndUserId(String sUserId, String sComponentName) throws AdminException {
        List<String> allowedComponentIds = this.getAllowedComponentIds(sUserId, sComponentName);
        return allowedComponentIds.toArray(new String[0]);
    }

    @Override
    public List<ComponentInstLight> getAvailComponentInstLights(String userId, String componentName) throws AdminException {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        List<String> allowedComponentIds = this.getAllowedComponentIds(userId, componentName);
        for (String allowedComponentId : allowedComponentIds) {
            ComponentInstLight componentInst = this.getComponentInstLight(allowedComponentId);
            if (!componentInst.getName().equalsIgnoreCase(componentName)) continue;
            components.add(componentInst);
        }
        return components;
    }

    @Override
    public List<SpaceInstLight> getRootSpacesContainingComponent(String userId, String componentName) throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        List<ComponentInstLight> components = this.getAvailComponentInstLights(userId, componentName);
        for (ComponentInstLight component : components) {
            SpaceInstLight root;
            List<SpaceInstLight> path = this.treeCache.getComponentPath(component.getId());
            if (path.isEmpty() || spaces.contains(root = path.get(0))) continue;
            spaces.add(root);
        }
        return spaces;
    }

    @Override
    public List<SpaceInstLight> getSubSpacesContainingComponent(String spaceId, String userId, String componentName) throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        int driverSpaceId = this.getDriverSpaceId(spaceId);
        List<ComponentInstLight> components = this.getAvailComponentInstLights(userId, componentName);
        for (ComponentInstLight component : components) {
            List<SpaceInstLight> path = this.treeCache.getComponentPath(component.getId());
            for (SpaceInstLight space : path) {
                if (this.getDriverSpaceId(space.getFatherId()) != driverSpaceId || spaces.contains(space)) continue;
                spaces.add(space);
            }
        }
        return spaces;
    }

    @Override
    public CompoSpace[] getCompoForUser(String sUserId, String sComponentName) throws AdminException {
        ArrayList<CompoSpace> alCompoSpace = new ArrayList<CompoSpace>();
        try {
            List<ComponentInstLight> components = this.getAvailComponentInstLights(sUserId, sComponentName);
            for (ComponentInstLight componentInst : components) {
                CompoSpace compoSpace = new CompoSpace();
                compoSpace.setComponentId(componentInst.getId());
                if (StringUtil.isDefined((String)componentInst.getLabel())) {
                    compoSpace.setComponentLabel(componentInst.getLabel());
                } else {
                    compoSpace.setComponentLabel(componentInst.getName());
                }
                compoSpace.setSpaceId(this.getClientSpaceId(componentInst.getDomainFatherId()));
                SpaceInstLight spaceInst = this.getSpaceInstLightById(componentInst.getDomainFatherId());
                compoSpace.setSpaceLabel(spaceInst.getName());
                alCompoSpace.add(compoSpace);
            }
            return alCompoSpace.toArray(new CompoSpace[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("instances of component " + sComponentName), (Object)(AVAILABLE_TO_USER + sUserId)), e);
        }
    }

    @Override
    public String[] getCompoId(String sComponentName) throws AdminException {
        try {
            String[] matchingComponentIds = this.componentManager.getAllCompoIdsByComponentName(sComponentName);
            ArrayList shortIds = new ArrayList();
            for (String componentId : matchingComponentIds) {
                Optional<ComponentInstLight> component = this.treeCache.getComponent(sComponentName + componentId);
                component.ifPresent(c -> shortIds.add(componentId));
            }
            return shortIds.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"instances of component", (Object)sComponentName), e);
        }
    }

    @Override
    public List<ComponentInstLight> getComponentsWithParameter(String paramName, String paramValue) {
        try {
            Parameter param = new Parameter();
            param.setName(paramName);
            param.setValue(paramValue);
            List<Integer> componentIds = this.componentManager.getComponentIds(param);
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            for (Integer id : componentIds) {
                ComponentInst component = this.getComponentInst(id);
                Optional<ComponentInstLight> componentLight = this.treeCache.getComponent(component.getId());
                componentLight.filter(c -> !c.isRemoved()).ifPresent(components::add);
            }
            return components;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String[] getProfileIds(String sUserId) throws AdminException {
        try {
            String[] asProfilesIds;
            Optional<String[]> optionalProfileIds = this.cache.getProfileIds(sUserId);
            if (optionalProfileIds.isEmpty()) {
                asProfilesIds = this.profileManager.getProfileIdsOfUser(sUserId, this.getAllGroupsOfUser(sUserId));
                if (asProfilesIds != null) {
                    this.cache.putProfileIds(sUserId, asProfilesIds);
                }
            } else {
                asProfilesIds = optionalProfileIds.get();
            }
            return asProfilesIds;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"profiles of user", (Object)sUserId), e);
        }
    }

    @Override
    public String[] getProfileIdsOfGroup(String sGroupId) throws AdminException {
        return this.getDirectComponentProfileIdsOfGroup(sGroupId);
    }

    @Override
    public String[] getCurrentProfiles(String sUserId, ComponentInst componentInst) {
        ArrayList<String> alProfiles = new ArrayList<String>();
        try {
            String[] asProfileIds;
            for (String asProfileId : asProfileIds = this.getProfileIds(sUserId)) {
                for (int nJ = 0; nJ < componentInst.getNumProfileInst(); ++nJ) {
                    if (!componentInst.getProfileInst(nJ).getId().equals(asProfileId)) continue;
                    alProfiles.add(componentInst.getProfileInst(nJ).getName());
                }
            }
            return this.arrayListToString(this.removeTuples(alProfiles));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getCurrentProfiles(String sUserId, String componentId) throws AdminException {
        return this.profileManager.getProfileNamesOfUser(sUserId, this.getAllGroupsOfUser(sUserId), this.getDriverComponentId(componentId));
    }

    @Override
    public Map<String, Set<String>> getUserProfilesByComponentId(String userId, Collection<String> componentIds) throws AdminException {
        Map<Integer, String> localComponentIds = componentIds.stream().collect(Collectors.toMap(this::getDriverComponentId, i -> i));
        return this.profileManager.getProfileNamesOfUser(userId, this.getAllGroupsOfUser(userId), localComponentIds.keySet()).entrySet().stream().collect(Collectors.toMap(e -> (String)localComponentIds.get(e.getKey()), Map.Entry::getValue));
    }

    @Override
    public List<String> getSpaceUserProfilesBySpaceId(String userId, String spaceId) throws AdminException {
        return this.spaceProfileManager.getSpaceProfileNamesOfUser(userId, this.getAllGroupsOfUser(userId), this.getDriverSpaceId(spaceId));
    }

    @Override
    public Map<String, Set<String>> getSpaceUserProfilesBySpaceIds(String userId, Collection<String> spaceIds) throws AdminException {
        Map<Integer, String> localSpaceIds = spaceIds.stream().collect(Collectors.toMap(this::getDriverSpaceId, i -> i));
        return this.spaceProfileManager.getSpaceProfileNamesOfUser(userId, this.getAllGroupsOfUser(userId), localSpaceIds.keySet()).entrySet().stream().collect(Collectors.toMap(e -> (String)localSpaceIds.get(e.getKey()), Map.Entry::getValue));
    }

    @Override
    public UserDetail[] getUsers(boolean bAllProfiles, String sProfile, String sClientComponentId) throws AdminException {
        ArrayList<String> alUserIds = new ArrayList<String>();
        try {
            ComponentInst componentInst = this.getComponentInst(this.getDriverComponentId(sClientComponentId));
            componentInst = this.checkComponentInstanceById(componentInst, sClientComponentId, this.nullComponentInstSupplier);
            Objects.requireNonNull(componentInst);
            for (ProfileInst profile : componentInst.getAllProfilesInst()) {
                if (profile == null || !profile.getName().equals(sProfile) && !bAllProfiles) continue;
                alUserIds.addAll(profile.getAllUsers());
                this.addUsersOfAllGroups(alUserIds, profile);
            }
            this.removeTuples(alUserIds);
            UserDetail[] userDetails = new UserDetail[alUserIds.size()];
            for (int nI = 0; nI < userDetails.length; ++nI) {
                userDetails[nI] = this.getUserDetail(alUserIds.get(nI));
            }
            return userDetails;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("users with profile " + sProfile), (Object)("of the component " + sClientComponentId)), e);
        }
    }

    private void addUsersOfAllGroups(Collection<String> alUserIds, ProfileInst profile) throws AdminException {
        List<String> groupIds = profile.getAllGroups();
        for (String groupId : groupIds) {
            UserDetail[] users;
            List<String> subGroupIds = this.groupManager.getAllSubGroupIdsRecursively(groupId);
            subGroupIds.add(groupId);
            for (UserDetail user : users = this.userManager.getAllUsersInGroups(subGroupIds)) {
                alUserIds.add(user.getId());
            }
        }
    }

    @Override
    public GroupDetail[] getAllSubGroups(String parentGroupId) throws AdminException {
        List<GroupDetail> subgroups = this.groupManager.getSubGroups(parentGroupId);
        return subgroups.toArray(new GroupDetail[0]);
    }

    @Override
    public GroupDetail[] getRecursivelyAllSubGroups(String parentGroupId) throws AdminException {
        List<GroupDetail> subgroups = this.groupManager.getRecursivelySubGroups(parentGroupId);
        return subgroups.toArray(new GroupDetail[0]);
    }

    @Override
    public UserDetail[] getFilteredDirectUsers(String sGroupId, String sUserLastNameFilter) throws AdminException {
        GroupDetail theGroup = this.getGroup(sGroupId);
        if (theGroup == null) {
            return new UserDetail[0];
        }
        String[] usersIds = theGroup.getUserIds();
        if (usersIds == null || usersIds.length == 0) {
            return new UserDetail[0];
        }
        if (sUserLastNameFilter == null || sUserLastNameFilter.isEmpty()) {
            return this.getUserDetails(usersIds);
        }
        String upperFilter = sUserLastNameFilter.toUpperCase();
        ArrayList<UserDetail> matchedUsers = new ArrayList<UserDetail>();
        for (String usersId : usersIds) {
            UserDetail currentUser = this.getUserDetail(usersId);
            if (currentUser == null || !currentUser.getLastName().toUpperCase().startsWith(upperFilter)) continue;
            matchedUsers.add(currentUser);
        }
        return matchedUsers.toArray(new UserDetail[0]);
    }

    @Override
    public int getAllSubUsersNumber(String sGroupId) throws AdminException {
        if (!StringUtil.isDefined((String)sGroupId)) {
            return this.userManager.getUserCount();
        }
        return this.groupManager.getTotalUserCountInGroup("", sGroupId);
    }

    @Override
    public String[] getAdministratorUserIds(String fromUserId) throws AdminException {
        return this.userManager.getAllAdminIds(this.getUserDetail(fromUserId));
    }

    @Override
    public String getSilverpeasEmail() {
        return this.senderEmail;
    }

    @Override
    public String getSilverpeasName() {
        return this.senderName;
    }

    private String[] arrayListToString(ArrayList<String> al) {
        if (al == null) {
            return ArrayUtil.emptyStringArray();
        }
        String[] as = new String[al.size()];
        for (int nI = 0; nI < al.size(); ++nI) {
            as[nI] = al.get(nI);
        }
        return as;
    }

    private ArrayList<String> removeTuples(ArrayList<String> al) {
        if (al == null) {
            return new ArrayList<String>();
        }
        for (int nI = 0; nI < al.size(); ++nI) {
            while (al.lastIndexOf(al.get(nI)) != al.indexOf(al.get(nI))) {
                al.remove(al.lastIndexOf(al.get(nI)));
            }
        }
        return al;
    }

    @Override
    public String[] getAllSpaceIds(String sUserId) throws AdminException {
        return this.getClientSpaceIds(this.getUserSpaceIds(sUserId));
    }

    @Override
    public String[] getAllRootSpaceIds(String sUserId) throws AdminException {
        return this.getClientSpaceIds(this.getUserRootSpaceIds(sUserId));
    }

    @Override
    public String[] getAllSubSpaceIds(String sSpaceId, String sUserId) throws AdminException {
        return this.getUserSubSpaceIds(sUserId, sSpaceId);
    }

    @Override
    public String[] getAllComponentIds(String sSpaceId) throws AdminException {
        return (String[])Optional.of(this.getSpaceInstById(sSpaceId)).stream().flatMap(s -> s.getAllComponentInstances().stream()).map(Identifiable::getId).toArray(String[]::new);
    }

    @Override
    public String[] getAllComponentIdsRecur(String sSpaceId) throws AdminException {
        List<ComponentInstLight> components = this.treeCache.getComponentsInSpaceAndSubspaces(this.getDriverSpaceId(sSpaceId));
        ArrayList<String> componentIds = new ArrayList<String>();
        for (ComponentInstLight component : components) {
            componentIds.add(component.getId());
        }
        SpaceInst space = this.getSpaceInstById(sSpaceId);
        if (space.isPersonalSpace()) {
            PersonalComponent.getAll().forEach(p -> componentIds.add(PersonalComponentInstance.from(space.getCreator(), p).getId()));
        }
        return componentIds.toArray(new String[0]);
    }

    @Override
    public void synchronizeGroupByRule(String groupId, boolean scheduledMode) throws AdminException {
        GroupDetail group = this.getGroup(groupId);
        String rule = group.getRule();
        if (StringUtil.isDefined((String)rule)) {
            try {
                if (!scheduledMode) {
                    SynchroGroupReport.setReportLevel(Level.DEBUG);
                    SynchroGroupReport.startSynchro();
                }
                SynchroGroupReport.warn(ADMIN_SYNCHRONIZE_GROUP, "Synchronisation du groupe '" + group.getName() + "' - Regle de synchronisation = \"" + rule + "\"");
                List<String> actualUserIds = Arrays.asList(group.getUserIds());
                List<String> userIds = GroupSynchronizationRule.from(group).getUserIds();
                ArrayList<String> newUsers = new ArrayList<String>();
                if (userIds != null) {
                    this.synchroAddUsersToAdd(actualUserIds, userIds, newUsers);
                }
                SynchroGroupReport.warn(ADMIN_SYNCHRONIZE_GROUP, "Ajout de " + newUsers.size() + " utilisateur(s)");
                if (!newUsers.isEmpty()) {
                    SynchroGroupReport.debug("admin.synchronizeGroup()", () -> "Ajout de l'utilisateur d'ID " + String.join((CharSequence)", ", newUsers) + " dans le groupe d'ID " + groupId);
                    this.groupManager.addUsersInGroup(newUsers, groupId);
                }
                ArrayList<String> removedUsers = new ArrayList<String>();
                this.synchroAddUsersToRemove(actualUserIds, userIds, removedUsers);
                SynchroGroupReport.warn(ADMIN_SYNCHRONIZE_GROUP, REMOVE_OF + removedUsers.size() + " utilisateur(s)");
                if (!removedUsers.isEmpty()) {
                    this.groupManager.removeUsersFromGroup(removedUsers, groupId);
                }
            }
            catch (Exception e) {
                SynchroGroupReport.error(ADMIN_SYNCHRONIZE_GROUP, "Error during the processing of synchronization rule of group '" + groupId + "': " + e.getMessage(), null);
                throw new AdminException("Fail to synchronize group " + groupId, e);
            }
            finally {
                if (!scheduledMode) {
                    SynchroGroupReport.stopSynchro();
                }
            }
        }
    }

    private void synchroAddUsersToRemove(List<String> actualUserIds, List<String> userIds, List<String> removedUsers) {
        for (String actualUserId : actualUserIds) {
            if (userIds != null && userIds.contains(actualUserId)) continue;
            removedUsers.add(actualUserId);
            SynchroGroupReport.info(ADMIN_SYNCHRONIZE_GROUP, "Suppression de l'utilisateur " + actualUserId);
        }
    }

    private void synchroAddUsersToAdd(List<String> actualUserIds, List<String> userIds, List<String> newUsers) {
        for (String userId : userIds) {
            if (actualUserIds.contains(userId)) continue;
            newUsers.add(userId);
            SynchroGroupReport.info(ADMIN_SYNCHRONIZE_GROUP, "Ajout de l'utilisateur " + userId);
        }
    }

    private List<String> translateGroupIds(String sDomainId, String[] groupSpecificIds, boolean recursGroups) {
        ArrayList<String> convertedGroupIds = new ArrayList<String>();
        for (String groupSpecificId : groupSpecificIds) {
            String groupId;
            block5: {
                try {
                    groupId = this.groupManager.getGroupIdBySpecificIdAndDomainId(groupSpecificId, sDomainId);
                }
                catch (AdminException e) {
                    groupId = null;
                    SilverLogger.getLogger((Object)this).warn("Group {0} not found. Synchronize it", new Object[]{groupSpecificId});
                    if (!recursGroups) break block5;
                    try {
                        groupId = this.synchronizeImportGroup(sDomainId, groupSpecificId, null, true, true);
                    }
                    catch (AdminException ex) {
                        SilverLogger.getLogger((Object)this).error((Throwable)((Object)ex));
                    }
                }
            }
            if (groupId == null) continue;
            convertedGroupIds.add(groupId);
        }
        return convertedGroupIds;
    }

    private Map<String, String> translateUserIds(String sDomainId, String[] userSpecificIds) {
        HashMap<String, String> userIdMapping = new HashMap<String, String>(userSpecificIds.length);
        String userId = null;
        for (String userSpecificId : userSpecificIds) {
            try {
                userId = this.userManager.getUserIdBySpecificIdAndDomainId(userSpecificId, sDomainId);
                if (userId == null) {
                    SilverLogger.getLogger((Object)this).warn("The user {0} doesn't exist. Synchronize it", new Object[]{userSpecificId});
                    userId = this.synchronizeImportUser(sDomainId, userSpecificId, false);
                }
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            }
            if (userId == null) continue;
            userIdMapping.put(userSpecificId, userId);
        }
        return userIdMapping;
    }

    @Override
    public String synchronizeGroup(String groupId, boolean recurs) throws AdminException {
        GroupDetail silverpeasGroup = this.getGroup(groupId);
        if (silverpeasGroup.isSynchronized()) {
            this.synchronizeGroupByRule(groupId, false);
        } else {
            String domainId = silverpeasGroup.getDomainId();
            String specificId = silverpeasGroup.getSpecificId();
            Mutable distantGroup = Mutable.empty();
            DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
            try {
                distantGroup.set((Object)synchroDomain.synchroGroup(specificId));
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).warn("Group {0} not found into identity manager, removing it", new Object[]{groupId});
            }
            if (!distantGroup.isPresent()) {
                return this.synchronizeRemoveGroup(groupId);
            }
            GroupDetail existingDistantGroup = (GroupDetail)distantGroup.get();
            existingDistantGroup.setId(groupId);
            existingDistantGroup.setDomainId(domainId);
            existingDistantGroup.setSuperGroupId(silverpeasGroup.getSuperGroupId());
            this.internalSynchronizeGroup(synchroDomain, existingDistantGroup, silverpeasGroup, recurs);
        }
        return groupId;
    }

    @Override
    public String synchronizeImportGroup(String domainId, String groupKey, String askedParentId, boolean recurs, boolean isIdKey) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        GroupDetail gr = isIdKey ? synchroDomain.synchroGroup(groupKey) : synchroDomain.importGroup(groupKey);
        gr.setDomainId(domainId);
        String[] parentSpecificIds = synchroDomain.getGroupMemberGroupIds(gr.getSpecificId());
        String parentId = null;
        for (int i = 0; i < parentSpecificIds.length && parentId == null; ++i) {
            try {
                parentId = this.groupManager.getGroupIdBySpecificIdAndDomainId(parentSpecificIds[i], domainId);
                if (askedParentId == null || askedParentId.isEmpty() || askedParentId.equals(parentId)) continue;
                parentId = null;
                continue;
            }
            catch (AdminException adminException) {
                // empty catch block
            }
        }
        if (parentId == null && (parentSpecificIds.length > 0 || askedParentId != null && !askedParentId.isEmpty())) {
            throw new AdminException("Fail to synchronize imported group " + groupKey + " in domain " + domainId, new String[0]);
        }
        gr.setSuperGroupId(parentId);
        String[] specificIds = gr.getUserIds();
        gr.setUserIds(ArrayUtil.emptyStringArray());
        String groupId = this.addGroup(gr, true);
        gr.setId(groupId);
        gr.setUserIds(specificIds);
        GroupDetail spGroup = this.getGroup(groupId);
        this.internalSynchronizeGroup(synchroDomain, gr, spGroup, recurs);
        return groupId;
    }

    @Override
    public String synchronizeRemoveGroup(String groupId) throws AdminException {
        GroupDetail theGroup = this.getGroup(groupId);
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(theGroup.getDomainId());
        synchroDomain.removeGroup(theGroup.getSpecificId());
        List<GroupDetail> removedGroups = this.removeGroup(groupId);
        return removedGroups.stream().findFirst().map(GroupDetail::getId).orElse("");
    }

    protected void internalSynchronizeGroup(DomainDriver synchroDomain, GroupDetail distantGroup, GroupDetail silverpeasGroup, boolean recurs) throws AdminException {
        Map<String, String> userIdMapping = this.translateUserIds(distantGroup.getDomainId(), distantGroup.getUserIds());
        SyncOfGroupsContext context = new SyncOfGroupsContext(distantGroup.getDomainId(), userIdMapping);
        if (this.mergeDistantGroupIntoSilverpeasGroup(context, CheckoutGroupDescriptor.synchronizingOneGroupWithSuperGroupId(distantGroup.getSuperGroupId()), distantGroup, silverpeasGroup)) {
            this.updateGroup(silverpeasGroup, true);
        }
        if (recurs) {
            GroupDetail[] children;
            for (GroupDetail child : children = synchroDomain.getGroups(distantGroup.getSpecificId())) {
                String existingGroupId = null;
                try {
                    existingGroupId = this.groupManager.getGroupIdBySpecificIdAndDomainId(child.getSpecificId(), distantGroup.getDomainId());
                    GroupDetail existingGroup = this.getGroup(existingGroupId);
                    if (!existingGroup.getSuperGroupId().equals(distantGroup.getId())) continue;
                    this.synchronizeGroup(existingGroupId, recurs);
                }
                catch (AdminException e) {
                    if (existingGroupId != null) continue;
                    this.synchronizeImportGroup(distantGroup.getDomainId(), child.getSpecificId(), distantGroup.getId(), recurs, true);
                }
            }
        }
    }

    @Override
    public String synchronizeUser(String userId, boolean recurs, boolean force) throws AdminException {
        ArrayList<UserDetail> listUsersUpdate = new ArrayList<UserDetail>();
        UserDetail theUserDetail = this.getUserDetail(userId);
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(theUserDetail.getDomainId());
        Mutable silverpeasUser = Mutable.empty();
        try {
            silverpeasUser.set((Object)synchroDomain.synchroUser(theUserDetail.getSpecificId()));
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).warn("User {0} not found into identity manager, removing it", new Object[]{userId});
        }
        try {
            if (!silverpeasUser.isPresent()) {
                return this.synchronizeRemoveUser(userId);
            }
            UserDetail ud = synchroDomain.synchroUser(theUserDetail.getSpecificId());
            ud.setId(userId);
            ud.setAccessLevel(theUserDetail.getAccessLevel());
            ud.setDomainId(theUserDetail.getDomainId());
            if (!ud.equals(theUserDetail) || ud.getState() != UserState.UNKNOWN && ud.getState() != theUserDetail.getState()) {
                DefaultAdministration.mergeDistantUserIntoSilverpeasUser(ud, theUserDetail);
                this.userManager.updateUser(theUserDetail, true);
                this.cache.opUpdateUser(this.userManager.getUserDetail(userId));
            } else if (force) {
                this.domainDriverManager.indexUser(userId);
            }
            listUsersUpdate.add(ud);
            String[] incGroupsSpecificId = synchroDomain.getUserMemberGroupIds(theUserDetail.getSpecificId());
            List<String> incGroupsId = this.translateGroupIds(theUserDetail.getDomainId(), incGroupsSpecificId, recurs);
            List<GroupDetail> oldGroups = this.groupManager.getAllDirectGroupsOfUser(userId);
            for (GroupDetail oldGroup : oldGroups) {
                if (incGroupsId.contains(oldGroup.getId())) {
                    incGroupsId.remove(oldGroup.getId());
                    continue;
                }
                if (!theUserDetail.getDomainId().equals(oldGroup.getDomainId())) continue;
                this.groupManager.removeUserFromGroup(userId, oldGroup.getId());
                this.cache.opRemoveUserFromGroup(userId);
            }
            for (String includedGroupId : incGroupsId) {
                this.groupManager.addUserInGroup(userId, includedGroupId);
                this.cache.opAddUserInGroup(userId);
            }
            this.processSpecificSynchronization(theUserDetail.getDomainId(), null, listUsersUpdate, null);
            return userId;
        }
        catch (Exception e) {
            throw new AdminException("Fail to synchronize user " + userId, e);
        }
    }

    @Override
    public String synchronizeImportUserByLogin(String domainId, String userLogin, boolean recurs) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        UserDetail ud = synchroDomain.importUser(userLogin);
        ud.setDomainId(domainId);
        String userId = this.addUser(ud, true);
        this.synchronizeUser(userId, recurs, false);
        return userId;
    }

    @Override
    public String synchronizeImportUser(String domainId, String specificId, boolean recurs) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        UserDetail ud = synchroDomain.getUser(specificId);
        ud.setDomainId(domainId);
        String userId = this.addUser(ud, true);
        this.synchronizeUser(userId, recurs, false);
        return userId;
    }

    @Override
    public List<DomainProperty> getSpecificPropertiesToImportUsers(String domainId, String language) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        return synchroDomain.getPropertiesToImport(language);
    }

    @Override
    public UserDetail[] searchUsers(String domainId, Map<String, String> query) throws AdminException {
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(domainId);
        return synchroDomain.getUsersByQuery(query);
    }

    @Override
    public String synchronizeRemoveUser(String userId) throws AdminException {
        UserDetail theUserDetail = this.getUserDetail(userId);
        DomainDriver synchroDomain = this.domainDriverManager.getDomainDriver(theUserDetail.getDomainId());
        synchroDomain.removeUser(theUserDetail.getSpecificId());
        this.removeUser(userId);
        this.processSpecificSynchronization(theUserDetail.getDomainId(), null, null, Collections.singletonList(theUserDetail));
        return userId;
    }

    @Override
    public String synchronizeSilverpeasWithDomain(String sDomainId) throws AdminException {
        return this.synchronizeSilverpeasWithDomain(sDomainId, false);
    }

    @Override
    public String synchronizeSilverpeasWithDomain(final String sDomainId, final boolean threaded) throws AdminException {
        try {
            Pair result = (Pair)Transaction.performInNew((Process)new Process<Pair<String, List<AbstractBackgroundProcessRequest>>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Pair<String, List<AbstractBackgroundProcessRequest>> execute() throws Exception {
                    Object sReport = "Starting synchronization...\n\n";
                    Object object = DefaultAdministration.this.semaphore;
                    synchronized (object) {
                        SynchroDomainReport.startSynchro();
                        try {
                            SynchroDomainReport.info(DefaultAdministration.ADMIN_SYNCHRONIZE_DOMAIN, "Domain '" + DefaultAdministration.this.domainDriverManager.getDomain(sDomainId).getName() + "', Id : " + sDomainId);
                            DefaultAdministration.this.domainDriverManager.beginSynchronization(sDomainId);
                            DomainDriver synchroDomain = DefaultAdministration.this.domainDriverManager.getDomainDriver(sDomainId);
                            boolean addUserIntoSilverpeas = synchroDomain.mustImportUsers() || threaded;
                            SyncOfUsersContext userContext = new SyncOfUsersContext(sDomainId, threaded, addUserIntoSilverpeas, DefaultAdministration.this.delUsersOnDiffSynchro);
                            SyncOfUsersContext syncOfUsersContext = DefaultAdministration.this.synchronizeUsers(userContext);
                            sReport = (String)sReport + syncOfUsersContext.getReport();
                            Map<String, String> userIdsMapping = Arrays.stream(DefaultAdministration.this.userManager.getAllUsersInDomain(sDomainId, true)).collect(Collectors.toMap(UserDetail::getSpecificId, UserDetail::getId));
                            SyncOfGroupsContext groupContext = new SyncOfGroupsContext(sDomainId, userIdsMapping);
                            SyncOfGroupsContext syncOfGroupsContext = DefaultAdministration.this.synchronizeGroups(groupContext);
                            sReport = (String)sReport + "\n" + syncOfGroupsContext.getReport();
                            String sDomainSpecificErrors = DefaultAdministration.this.domainDriverManager.endSynchronization(sDomainId, false);
                            if (StringUtil.isDefined((String)sDomainSpecificErrors)) {
                                SynchroDomainReport.info(DefaultAdministration.ADMIN_SYNCHRONIZE_DOMAIN, "----------------" + sDomainSpecificErrors);
                            }
                            Pair pair = Pair.of((Object)((String)sReport + "\n----------------\n" + sDomainSpecificErrors), List.of(syncOfUsersContext.getIndexationBackgroundProcess(), syncOfGroupsContext.getIndexationBackgroundProcess()));
                            return pair;
                        }
                        catch (Exception e) {
                            try {
                                DefaultAdministration.this.domainDriverManager.endSynchronization(sDomainId, true);
                            }
                            catch (Exception e1) {
                                SilverLogger.getLogger((Object)this).error((Throwable)e1);
                            }
                            SynchroDomainReport.error(DefaultAdministration.ADMIN_SYNCHRONIZE_DOMAIN, "Probl\u00e8me lors de la synchronisation : " + e.getMessage(), null);
                            throw new AdminException("Fail to synchronize domain " + sDomainId + ". Report: " + (String)sReport, e);
                        }
                        finally {
                            SynchroDomainReport.stopSynchro();
                            DefaultAdministration.this.cache.resetCache();
                        }
                    }
                }
            });
            ((List)result.getSecond()).forEach(BackgroundProcessTask::push);
            return (String)result.getFirst();
        }
        catch (Exception e) {
            if (e.getCause() instanceof AdminException) {
                throw e;
            }
            throw new AdminException(e);
        }
    }

    static boolean mergeDistantUserIntoSilverpeasUser(UserDetail distantUser, UserDetail silverpeasUser) {
        boolean dataUpdated = !Objects.equals(silverpeasUser.getSpecificId(), distantUser.getSpecificId());
        silverpeasUser.setSpecificId(distantUser.getSpecificId());
        dataUpdated |= !Objects.equals(silverpeasUser.getFirstName(), distantUser.getFirstName());
        silverpeasUser.setFirstName(distantUser.getFirstName());
        dataUpdated |= !Objects.equals(silverpeasUser.getLastName(), distantUser.getLastName());
        silverpeasUser.setLastName(distantUser.getLastName());
        dataUpdated |= !Objects.equals(silverpeasUser.getEmailAddress(), distantUser.getEmailAddress());
        silverpeasUser.setEmailAddress(distantUser.getEmailAddress());
        dataUpdated |= !Objects.equals(silverpeasUser.getLogin(), distantUser.getLogin());
        silverpeasUser.setLogin(distantUser.getLogin());
        if (silverpeasUser.isRemovedState()) {
            return dataUpdated;
        }
        if (distantUser.isDeactivatedState() || distantUser.isValidState() && silverpeasUser.isDeactivatedState()) {
            dataUpdated |= !Objects.equals(silverpeasUser.getState(), distantUser.getState());
            silverpeasUser.setState(distantUser.getState());
        }
        return dataUpdated;
    }

    private SyncOfUsersContext synchronizeUsers(SyncOfUsersContext context) throws AdminException {
        String domainId = context.getDomainId();
        context.appendToReport("User synchronization : \n");
        SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, "Starting synchronization of users...");
        UserDetail[] distantUDs = this.domainDriverManager.getAllUsers(context.getDomainId());
        SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_USERS, MessageFormat.format("Existing currently {0} users in external repository before synchronization", distantUDs.length));
        UserDetail[] silverpeasUDs = this.userManager.getAllUsersInDomain(domainId, true);
        SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_USERS, MessageFormat.format("Existing currently {0} users in Silverpeas before synchronization", silverpeasUDs.length));
        try {
            this.performRemoveOfUsersDuringSynchronization(context, distantUDs, silverpeasUDs);
            this.performSaveOfUsersDuringSynchronization(context, distantUDs, silverpeasUDs);
            this.processSpecificSynchronization(domainId, context.getAddedUsers().values(), context.getUpdatedUsers().values(), context.getRemovedUsers().values());
            String message = "Synchronization of users terminated";
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
            message = MessageFormat.format("# of updated users: {0}, added: {1}, removed: {2}, restored: {3}, deleted: {4}", context.getUpdatedUsers().size(), context.getAddedUsers().size(), context.getRemovedUsers().size(), context.getRestoredUsers().size(), context.getDeletedUsers().size());
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
            context.setIndexationBackgroundProcess(new BackgroundUserIndexationProcess(this.domainDriverManager, context));
            return context;
        }
        catch (Exception e) {
            SynchroDomainReport.error(ADMIN_SYNCHRONIZE_USERS, "Problem during synchronization of users : " + e.getMessage(), null);
            throw new AdminException("Fail to synchronize domain " + domainId + ". Report: " + context.getReport(), e);
        }
    }

    private void performRemoveOfUsersDuringSynchronization(SyncOfUsersContext context, UserDetail[] distantUDs, UserDetail[] silverpeasUDs) {
        if (context.isRemoveOperationToPerform()) {
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_USERS, "Removing users from database...");
            Set<String> indexedDistantUsers = this.extractUserSpecificIdAndFallbackLogin(distantUDs);
            for (UserDetail silverpeasUD : silverpeasUDs) {
                if (silverpeasUD.isRemovedState() || this.existsUserBySpecificIdOrFallbackLoginIn(silverpeasUD, indexedDistantUsers)) continue;
                this.removeUserDuringSynchronization(context, silverpeasUD);
            }
        }
    }

    private void performSaveOfUsersDuringSynchronization(SyncOfUsersContext context, UserDetail[] distantUDs, UserDetail[] silverpeasUDs) {
        SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_USERS, "Saving users in database...");
        Map<String, UserDetail> indexedSpUsers = this.indexUsersBySpecificIdAndLogin(silverpeasUDs);
        for (UserDetail distantUD : distantUDs) {
            UserDetail userToUpdateFromDistantUser = this.getUserBySpecificIdOrFallbackLoginFrom(distantUD, indexedSpUsers);
            if (userToUpdateFromDistantUser != null) {
                if (userToUpdateFromDistantUser.isRemovedState()) {
                    this.restoreUserDuringSynchronization(context, distantUD, userToUpdateFromDistantUser);
                    continue;
                }
                if (!DefaultAdministration.mergeDistantUserIntoSilverpeasUser(distantUD, userToUpdateFromDistantUser)) continue;
                this.updateUserDuringSynchronization(context, userToUpdateFromDistantUser);
                continue;
            }
            if (!context.isAddOperationToPerform()) continue;
            this.deleteRemovedUserDuringSynchronization(context, distantUD, indexedSpUsers);
            distantUD.setDomainId(context.getDomainId());
            this.addUserDuringSynchronization(context, distantUD);
        }
    }

    @Nullable
    private UserDetail getUserBySpecificIdOrFallbackLoginFrom(@Nonnull UserDetail user, Map<String, UserDetail> indexedUsers) {
        UserDetail indexedUser = indexedUsers.get(user.getSpecificId());
        if (indexedUser == null && this.shouldFallbackUserLogins) {
            indexedUser = indexedUsers.get(user.getLogin());
        }
        return indexedUser;
    }

    private boolean existsUserBySpecificIdOrFallbackLoginIn(UserDetail user, Set<String> indexedUsers) {
        return indexedUsers.contains(user.getSpecificId()) || this.shouldFallbackUserLogins && indexedUsers.contains(user.getLogin());
    }

    @Nonnull
    private Map<String, UserDetail> indexUsersBySpecificIdAndLogin(UserDetail[] silverpeasUDs) {
        HashMap<String, UserDetail> indexedSilverpeasUsers = new HashMap<String, UserDetail>(silverpeasUDs.length * 2);
        Arrays.stream(silverpeasUDs).forEach(u -> {
            indexedSilverpeasUsers.put(u.getSpecificId(), (UserDetail)u);
            indexedSilverpeasUsers.put(u.getLogin(), (UserDetail)u);
        });
        return indexedSilverpeasUsers;
    }

    @Nonnull
    private Set<String> extractUserSpecificIdAndFallbackLogin(UserDetail[] users) {
        HashSet<String> indexedUsers = new HashSet<String>(this.shouldFallbackUserLogins ? users.length * 2 : users.length);
        Arrays.stream(users).forEach(u -> {
            indexedUsers.add(u.getSpecificId());
            if (this.shouldFallbackUserLogins) {
                indexedUsers.add(u.getLogin());
            }
        });
        return indexedUsers;
    }

    private void updateUserDuringSynchronization(SyncOfUsersContext context, UserDetail distantUD) {
        String specificId = distantUD.getSpecificId();
        try {
            String silverpeasId = this.userManager.updateUser(distantUD, false);
            context.getUpdatedUsers().put(silverpeasId, distantUD);
            String message = MessageFormat.format("{0} {1} updated (id:{2} / specificId:{3})", USER, distantUD.getDisplayedName(), silverpeasId, specificId);
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
            context.appendToReport(message).appendToReport("\n");
        }
        catch (AdminException aeMaj) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while updating user " + specificId, (Throwable)((Object)aeMaj));
            String errorMessage = MessageFormat.format("problem updating user {0} (specificId:{1}) - {2}", distantUD.getDisplayedName(), specificId, aeMaj.getMessage());
            context.appendToReport(errorMessage).appendToReport("\n");
            SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, errorMessage);
            context.appendToReport("user hasn't been updated\n");
        }
    }

    private void addUserDuringSynchronization(SyncOfUsersContext context, UserDetail distantUD) {
        String specificId = distantUD.getSpecificId();
        try {
            String silverpeasId = this.userManager.addUser(distantUD, true, false);
            if (silverpeasId.isEmpty()) {
                String message = MessageFormat.format("problem adding user {0} (specificId:{1}) - Login and LastName must be set !!!", distantUD.getDisplayedName(), specificId);
                context.appendToReport(message).appendToReport("\n");
                SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, message);
                context.appendToReport("user has not been added\n");
            } else {
                context.getAddedUsers().put(silverpeasId, distantUD);
                String message = MessageFormat.format("{0} {1} added (id:{2} / specificId:{3})", USER, distantUD.getDisplayedName(), silverpeasId, specificId);
                context.appendToReport(message).appendToReport("\n");
                SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
            }
        }
        catch (AdminException ae) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while adding user " + specificId, (Throwable)((Object)ae));
            String message = MessageFormat.format("problem adding user {0}(specificId:{1}) - {2}", distantUD.getDisplayedName(), specificId, ae.getMessage());
            SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, message);
            context.appendToReport(message).appendToReport("\n");
            context.appendToReport("user has not been added\n");
        }
    }

    private void removeUserDuringSynchronization(SyncOfUsersContext context, UserDetail silverpeasUD) {
        String specificId = silverpeasUD.getSpecificId();
        try {
            this.userManager.removeUser(silverpeasUD, false);
            silverpeasUD.setState(UserState.REMOVED);
            context.getRemovedUsers().put(silverpeasUD.getId(), silverpeasUD);
            String message = MessageFormat.format("{0} {1} removed (id:{2} / specificId:{3})", USER, silverpeasUD.getDisplayedName(), silverpeasUD.getId(), specificId);
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
        }
        catch (AdminException aeDel) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while removing user " + specificId, (Throwable)((Object)aeDel));
            String message = MessageFormat.format("problem removing user {0} (specificId:{1}) - {2}", silverpeasUD.getDisplayedName(), specificId, aeDel.getMessage());
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, message);
            context.appendToReport("user has not been removed\n");
        }
    }

    private void restoreUserDuringSynchronization(SyncOfUsersContext context, UserDetail distantUD, UserDetail silverpeasUD) {
        String specificId = silverpeasUD.getSpecificId();
        try {
            this.userManager.restoreUser(silverpeasUD, false);
            UserDetail updatedRestoreData = this.getUserDetail(silverpeasUD.getId());
            silverpeasUD.setState(updatedRestoreData.getState());
            silverpeasUD.setStateSaveDate(updatedRestoreData.getStateSaveDate());
            if (DefaultAdministration.mergeDistantUserIntoSilverpeasUser(distantUD, silverpeasUD)) {
                this.userManager.updateUser(silverpeasUD, false);
            }
            context.getRestoredUsers().put(silverpeasUD.getId(), silverpeasUD);
            String message = MessageFormat.format("{0} {1} restored (id:{2} / specificId:{3})", USER, silverpeasUD.getDisplayedName(), silverpeasUD.getId(), specificId);
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_USERS, message);
        }
        catch (AdminException aeDel) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while restoring user " + specificId, (Throwable)((Object)aeDel));
            String message = MessageFormat.format("problem restoring user {0} (specificId:{1}) - {2}", silverpeasUD.getDisplayedName(), specificId, aeDel.getMessage());
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, message);
            context.appendToReport("user has not been restored\n");
        }
    }

    private void deleteRemovedUserDuringSynchronization(SyncOfUsersContext context, UserDetail distantUD, Map<String, UserDetail> indexedSpUsers) {
        block3: {
            String login = distantUD.getLogin();
            try {
                UserDetail silverpeasUser;
                if (this.shouldFallbackUserLogins || (silverpeasUser = indexedSpUsers.get(login)) == null) break block3;
                if (!distantUD.getSpecificId().equals(silverpeasUser.getSpecificId()) && silverpeasUser.isRemovedState()) {
                    this.userManager.deleteUser(silverpeasUser, true);
                    context.getDeletedUsers().put(silverpeasUser.getId(), silverpeasUser);
                    String message = MessageFormat.format("{0} {1} deleted (id:{2} / login:{3})", USER, distantUD.getDisplayedName(), distantUD.getId(), login);
                    context.appendToReport(message).appendToReport("\n");
                    SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
                    break block3;
                }
                String message = MessageFormat.format("{0} {1} must have 'REMOVED' state for deletion (id:{2} / login:{3})", USER, distantUD.getDisplayedName(), distantUD.getId(), login);
                throw new AdminException(message, new String[0]);
            }
            catch (AdminException aeDel) {
                SilverLogger.getLogger((Object)this).error("Full synchro: error while deleting user with login " + login, (Throwable)((Object)aeDel));
                String message = MessageFormat.format("problem deleting user {0} (domainId:{1}, login:{2}) - {3}", distantUD.getDisplayedName(), context.getDomainId(), login, aeDel.getMessage());
                context.appendToReport(message).appendToReport("\n");
                SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_USERS, message);
                context.appendToReport("user has not been deleted\n");
            }
        }
    }

    private void processSpecificSynchronization(String domainId, Collection<UserDetail> usersAdded, Collection<UserDetail> usersUpdated, Collection<UserDetail> usersRemoved) throws AdminException {
        Domain theDomain = this.domainDriverManager.getDomain(domainId);
        SettingBundle propDomainLdap = theDomain.getSettings();
        String nomClasseSynchro = propDomainLdap.getString("synchro.Class", null);
        if (StringUtil.isDefined((String)nomClasseSynchro)) {
            Collection<UserDetail> added = usersAdded;
            Collection<UserDetail> updated = usersUpdated;
            Collection<UserDetail> removed = usersRemoved;
            if (added == null) {
                added = new ArrayList<UserDetail>();
            }
            if (updated == null) {
                updated = new ArrayList<UserDetail>();
            }
            if (removed == null) {
                removed = new ArrayList<UserDetail>();
            }
            try {
                Constructor<?> constructor = Class.forName(nomClasseSynchro).getConstructor(new Class[0]);
                LDAPSynchroUserItf synchroUser = (LDAPSynchroUserItf)constructor.newInstance(new Object[0]);
                synchroUser.processUsers(added, updated, removed);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private SyncOfGroupsContext synchronizeGroups(SyncOfGroupsContext context) throws AdminException {
        String domainId = context.getDomainId();
        context.appendToReport("GroupDetail synchronization : \n");
        SynchroDomainReport.info(ADMIN_SYNCHRONIZE_GROUPS, "Starting groups synchronization...");
        GroupDetail[] distantRootGroups = this.domainDriverManager.getAllRootGroups(domainId);
        SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_GROUPS, MessageFormat.format("Existing currently {0} ROOT groups in external repository before synchronization", distantRootGroups.length));
        List<GroupDetail> allSilverpeasGroups = this.groupManager.getGroupsOfDomain(domainId);
        SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_GROUPS, MessageFormat.format("Existing currently {0} groups in Silverpeas before synchronization", allSilverpeasGroups.size()));
        try {
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_GROUPS, "Adding or updating groups in database...");
            CheckoutGroupDescriptor descriptor = CheckoutGroupDescriptor.synchronizingDomainFrom(allSilverpeasGroups, distantRootGroups);
            this.checkOutGroups(context, descriptor);
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_GROUPS, "Removing groups from database...");
            Collection<GroupDetail> distantGroups = descriptor.getAllSavedDistantGroups().values();
            allSilverpeasGroups.stream().filter(s -> distantGroups.stream().noneMatch(d -> d.getSpecificId().equals(s.getSpecificId()) || this.shouldFallbackGroupNames && d.getName().equals(s.getSpecificId()))).filter(Predicate.not(GroupDetail::isRemovedState)).forEach(s -> this.synchroRemoveGroup(context, s.getSpecificId(), (GroupDetail)s));
            String message = "Groups synchronization terminated\n";
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_USERS, message);
            message = MessageFormat.format("# of updated groups: {0}, added: {1}, removed: {2}, restored: {3}", context.getUpdatedGroups().size(), context.getAddedGroups().size(), context.getRemovedGroups().size(), context.getRestoredGroups().size());
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.info(ADMIN_SYNCHRONIZE_GROUPS, message);
            context.setIndexationBackgroundProcess(new BackgroundGroupIndexationProcess(this.domainDriverManager, context));
            return context;
        }
        catch (Exception e) {
            SynchroDomainReport.error(ADMIN_SYNCHRONIZE_GROUPS, "Probl\u00e8me lors de la synchronisation des groupes : " + e.getMessage(), null);
            throw new AdminException("Fails to synchronize groups in domain " + domainId, e);
        }
    }

    private void synchroRemoveGroup(SyncOfGroupsContext context, String specificId, GroupDetail silverpeasGroup) {
        try {
            List<GroupDetail> removedGroups = this.groupManager.removeGroup(silverpeasGroup, false);
            removedGroups.forEach(g -> {
                this.synchroGroupManager.removeFromContext((Group)g);
                this.cache.opRemoveGroup((Group)g);
                context.getRemovedGroups().put(g.getId(), (GroupDetail)g);
                context.appendToReport(MessageFormat.format("removing group {0} (id:{1})\n", g.getName(), g.getSpecificId()));
                SynchroDomainReport.info(ADMIN_SYNCHRONIZE_GROUPS, "GroupDetail " + g.getName() + " removed (SpecificId:" + g.getSpecificId() + ")");
            });
        }
        catch (AdminException aeDel) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while removing group " + specificId, (Throwable)((Object)aeDel));
            context.appendToReport(MessageFormat.format("problem removing group {0} (specificId:{1}) - {2}\ngroup has not been removed\n", silverpeasGroup.getName(), specificId, aeDel.getMessage()));
        }
    }

    private void checkOutGroups(SyncOfGroupsContext context, CheckoutGroupDescriptor descriptor) throws AdminException {
        descriptor.addDistantTestedGroupsInAllSavedDistantGroups();
        for (GroupDetail distantGroup : descriptor.getDistantTestedGroups()) {
            String silverpeasId;
            distantGroup.setDomainId(context.getDomainId());
            String specificId = distantGroup.getSpecificId();
            Optional<GroupDetail> foundGroup = descriptor.getAllSilverpeasGroups().stream().filter(g -> g.getSpecificId().equals(specificId) || this.shouldFallbackGroupNames && g.getSpecificId().equals(distantGroup.getName())).findFirst();
            if (foundGroup.isPresent()) {
                SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "avant maj du groupe " + specificId + ", recherche de ses groupes parents");
                GroupDetail silverpeasGroup = foundGroup.get();
                silverpeasId = silverpeasGroup.isRemovedState() ? this.restoreGroupDuringSynchronization(context, descriptor, distantGroup, silverpeasGroup) : (this.mergeDistantGroupIntoSilverpeasGroup(context, descriptor, distantGroup, silverpeasGroup) ? this.updateGroupDuringSynchronization(context, specificId, silverpeasGroup) : silverpeasGroup.getId());
            } else {
                SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "avant ajout du groupe " + specificId + ", recherche de ses groupes parents");
                this.mergeDistantGroupIntoSilverpeasGroup(context, descriptor, distantGroup, distantGroup);
                silverpeasId = this.addGroupDuringSynchronization(context, specificId, distantGroup);
            }
            this.recursWithSubGroups(context, descriptor, specificId, silverpeasId);
        }
    }

    private String restoreGroupDuringSynchronization(SyncOfGroupsContext context, CheckoutGroupDescriptor descriptor, GroupDetail distantGroup, GroupDetail silverpeasGroup) {
        String specificId = silverpeasGroup.getSpecificId();
        try {
            this.groupManager.restoreGroup(silverpeasGroup, false);
            GroupDetail updatedRestoreData = this.getGroup(silverpeasGroup.getId());
            silverpeasGroup.setState(updatedRestoreData.getState());
            silverpeasGroup.setStateSaveDate(updatedRestoreData.getStateSaveDate());
            if (this.mergeDistantGroupIntoSilverpeasGroup(context, descriptor, distantGroup, silverpeasGroup)) {
                this.groupManager.updateGroup(silverpeasGroup, false);
            }
            String groupId = silverpeasGroup.getId();
            context.getRestoredGroups().put(groupId, silverpeasGroup);
            String message = MessageFormat.format("{0} {1} restored (id:{2} / specificId:{3})", GROUP, silverpeasGroup.getName(), groupId, specificId);
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_GROUPS, message);
            return groupId;
        }
        catch (AdminException aeDel) {
            SilverLogger.getLogger((Object)this).error("Full synchro: error while restoring group " + specificId, (Throwable)((Object)aeDel));
            String message = MessageFormat.format("problem restoring group {0} (specificId:{1}) - {2}", silverpeasGroup.getName(), specificId, aeDel.getMessage());
            context.appendToReport(message).appendToReport("\n");
            SynchroDomainReport.warn(ADMIN_SYNCHRONIZE_GROUPS, message);
            context.appendToReport("group has not been restored\n");
            return "";
        }
    }

    boolean mergeDistantGroupIntoSilverpeasGroup(SyncOfGroupsContext context, CheckoutGroupDescriptor descriptor, GroupDetail distantGroup, GroupDetail silverpeasGroup) throws AdminException {
        boolean dataUpdated = !Objects.equals(silverpeasGroup.getSpecificId(), distantGroup.getSpecificId());
        silverpeasGroup.setSpecificId(distantGroup.getSpecificId());
        dataUpdated |= !Objects.equals(silverpeasGroup.getName(), distantGroup.getName());
        silverpeasGroup.setName(distantGroup.getName());
        dataUpdated |= !Objects.equals(silverpeasGroup.getDescription(), distantGroup.getDescription());
        silverpeasGroup.setDescription(distantGroup.getDescription());
        dataUpdated |= this.setParentGroup(context, descriptor, silverpeasGroup);
        distantGroup.setSuperGroupId(silverpeasGroup.getSuperGroupId());
        dataUpdated |= this.setUserIds(context, distantGroup, silverpeasGroup);
        distantGroup.setUserIds(silverpeasGroup.getUserIds());
        if (silverpeasGroup.isRemovedState()) {
            return dataUpdated;
        }
        GroupState distantState = Optional.of(distantGroup.getState()).filter(Predicate.not(arg_0 -> GroupState.UNKNOWN.equals(arg_0))).orElse(GroupState.VALID);
        boolean bl = !Objects.equals(silverpeasGroup.getState(), distantState);
        silverpeasGroup.setState(distantState);
        return dataUpdated |= bl;
    }

    private void recursWithSubGroups(SyncOfGroupsContext context, CheckoutGroupDescriptor descriptor, String specificId, String silverpeasId) throws AdminException {
        GroupDetail[] cleanSubGroups;
        GroupDetail[] subGroups;
        if (StringUtil.isDefined((String)silverpeasId) && (subGroups = this.domainDriverManager.getGroups(silverpeasId)) != null && subGroups.length > 0 && (cleanSubGroups = this.removeCrossReferences(subGroups, descriptor.getAllSavedDistantGroups(), specificId)).length > 0) {
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "Ajout ou mise \u00e0 jour de " + cleanSubGroups.length + " groupes fils du groupe " + specificId + "...");
            descriptor.setDistantTestedGroups(cleanSubGroups).setSuperGroupId(silverpeasId);
            this.checkOutGroups(context, descriptor);
        }
    }

    @Nullable
    private String addGroupDuringSynchronization(SyncOfGroupsContext context, String specificId, GroupDetail group) {
        String silverpeasId = null;
        try {
            silverpeasId = this.groupManager.addGroup(group, true, false);
            if (StringUtil.isDefined((String)silverpeasId)) {
                context.getAddedGroups().put(silverpeasId, group);
                context.appendToReport(MessageFormat.format("adding group {0} (id:{1})\n", group.getName(), specificId));
                SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "ajout groupe " + group.getName() + ID_IS + silverpeasId + ") OK");
            } else {
                context.appendToReport(MessageFormat.format("problem adding group id: {0}", specificId));
            }
        }
        catch (AdminException aeAdd) {
            context.appendToReport(MessageFormat.format("problem adding group {0} (id:{1}) {2}\ngroup has not been added\n", group.getName(), specificId, aeAdd.getMessage()));
        }
        return silverpeasId;
    }

    private String updateGroupDuringSynchronization(SyncOfGroupsContext context, String specificId, GroupDetail group) {
        String silverpeasId = null;
        try {
            String result = this.groupManager.updateGroup(group, true);
            if (StringUtil.isDefined((String)result)) {
                context.getUpdatedGroups().put(group.getId(), group);
                silverpeasId = group.getId();
                context.appendToReport(MessageFormat.format("updating group {0} (id:{1})\n", group.getName(), specificId));
                SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "maj groupe " + group.getName() + ID_IS + silverpeasId + ") OK");
            } else {
                SilverLogger.getLogger((Object)this).error("Full Synchro: error while updating group {0}", new Object[]{specificId});
                context.appendToReport(MessageFormat.format("problem updating group id : {0}\n", specificId));
            }
        }
        catch (AdminException aeMaj) {
            SilverLogger.getLogger((Object)this).error("Full Synchro: error while updating group {0}: ", new Object[]{specificId, aeMaj.getMessage()});
            context.appendToReport(MessageFormat.format("problem updating group {0} (id:{1}) {2}\ngroup has not been updated\n", group.getName(), specificId, aeMaj.getMessage()));
        }
        return silverpeasId;
    }

    private boolean setUserIds(SyncOfGroupsContext context, GroupDetail distantGroup, GroupDetail silverpeasGroup) {
        List previousUserIds = Arrays.stream(silverpeasGroup.getUserIds()).distinct().sorted().collect(Collectors.toList());
        List newUserIds = Arrays.stream(distantGroup.getUserIds()).map(context.getUserIdsMapping()::get).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        silverpeasGroup.setUserIds((String[])newUserIds.toArray(String[]::new));
        return !String.join((CharSequence)",", previousUserIds).equals(String.join((CharSequence)",", newUserIds));
    }

    private boolean setParentGroup(SyncOfGroupsContext context, CheckoutGroupDescriptor descriptor, GroupDetail group) throws AdminException {
        String specificId = group.getSpecificId();
        String currentSuperGroupId = group.getSuperGroupId();
        String[] groupParentsIds = this.domainDriverManager.getGroupMemberGroupIds(context.getDomainId(), group.getSpecificId());
        if (groupParentsIds == null || groupParentsIds.length == 0) {
            group.setSuperGroupId(null);
            SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "le groupe " + specificId + " n'a pas de p\u00e8re");
        } else {
            String superGroupId = descriptor.getSuperGroupId();
            group.setSuperGroupId(superGroupId);
            if (superGroupId != null) {
                SynchroDomainReport.debug(ADMIN_SYNCHRONIZE_CHECK_OUT_GROUPS, "le groupe " + specificId + " a pour p\u00e8re le groupe " + this.domainDriverManager.getGroup(superGroupId).getSpecificId() + " d'Id base " + superGroupId);
            }
        }
        return !Objects.equals(currentSuperGroupId, group.getSuperGroupId());
    }

    private GroupDetail[] removeCrossReferences(GroupDetail[] subGroups, Map<String, GroupDetail> allIncludedGroups, String fatherId) {
        ArrayList<GroupDetail> cleanSubGroups = new ArrayList<GroupDetail>(subGroups.length);
        for (GroupDetail subGroup : subGroups) {
            if (allIncludedGroups.get(subGroup.getSpecificId()) == null) {
                cleanSubGroups.add(subGroup);
                continue;
            }
            SilverLogger.getLogger((Object)this).warn("Cross deletion for child {0} of the father {1}", new Object[]{subGroup.getSpecificId(), fatherId});
        }
        return cleanSubGroups.toArray(new GroupDetail[0]);
    }

    @Override
    public List<String> searchUserIdsByProfile(List<String> profileIds, boolean includeRemovedUsersAndGroups) throws AdminException {
        HashSet<String> userIds = new HashSet<String>();
        try {
            for (String profileId : profileIds) {
                ProfileInst profile = this.profileManager.getProfileInst(profileId, includeRemovedUsersAndGroups);
                if (profile == null) continue;
                this.addAllUsersInProfile(profile, userIds);
            }
        }
        catch (Exception e) {
            throw new AdminException("Fail to search user ids by some profiles", e);
        }
        return new ArrayList<String>(userIds);
    }

    @Override
    public SilverpeasList<UserDetail> searchUsers(UserDetailsSearchCriteria searchCriteria) throws AdminException {
        try {
            searchCriteria.setComponentInstanceSupplier((MemoizedSupplier<SilverpeasComponentInstance>)new MemoizedSupplier(() -> {
                if (!searchCriteria.isCriterionOnComponentInstanceIdSet()) {
                    return null;
                }
                String instanceId = searchCriteria.getCriterionOnComponentInstanceId();
                try {
                    return this.getComponentInstance(instanceId);
                }
                catch (AdminException e) {
                    throw new SilverpeasRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"component instance", (Object)instanceId));
                }
            }));
            this.searchCriteriaVisitors.forEach(searchCriteria::accept);
            return searchCriteria.isEmpty() ? ListSlice.emptyList() : this.userManager.getUsersMatchingCriteria(searchCriteria);
        }
        catch (SilverpeasRuntimeException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    private void addAllUsersInProfile(ProfileInst aProfile, Collection<String> userIds) throws AdminException {
        userIds.addAll(aProfile.getAllUsers());
        List<String> groupIds = aProfile.getAllGroups();
        ArrayList<String> allGroupIds = new ArrayList<String>();
        for (String aGroupId : groupIds) {
            allGroupIds.add(aGroupId);
            allGroupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(aGroupId));
        }
        userIds.addAll(this.userManager.getAllUserIdsInGroups(allGroupIds));
    }

    @Override
    public SilverpeasList<GroupDetail> searchGroups(GroupsSearchCriteria searchCriteria) throws AdminException {
        return this.searchGroups(searchCriteria, false);
    }

    @Override
    public SilverpeasList<GroupDetail> searchGroups(GroupsSearchCriteria searchCriteria, boolean orderedByType) throws AdminException {
        this.searchCriteriaVisitors.forEach(searchCriteria::accept);
        return searchCriteria.isEmpty() ? ListSlice.emptyList() : this.groupManager.getGroupsMatchingCriteria(searchCriteria, orderedByType);
    }

    @Override
    public void indexAllUsers() throws AdminException {
        Domain[] domains;
        IndexEngineProxy.removeScopedIndexEntries("users");
        for (Domain domain : domains = this.getAllDomains()) {
            try {
                this.indexUsers(domain.getId());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    @Override
    public void indexUsers(String domainId) throws AdminException {
        try {
            this.domainDriverManager.indexAllUsers(domainId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnIndexing((String)"users in domain", (Object)domainId), e);
        }
    }

    @Override
    public String copyAndPasteComponent(PasteDetail pasteDetail) throws AdminException, QuotaException {
        if (!StringUtil.isDefined((String)pasteDetail.getToSpaceId())) {
            return null;
        }
        ComponentInst newCompo = new ComponentInst(this.getComponentInst(pasteDetail.getFromComponentId()));
        SpaceInst destinationSpace = this.getSpaceInstById(pasteDetail.getToSpaceId());
        String lang = newCompo.getLanguage();
        if (StringUtil.isNotDefined((String)lang)) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        newCompo.setLocalId(-1);
        newCompo.setDomainFatherId(destinationSpace.getId());
        newCompo.setOrderNum(destinationSpace.getAllComponentsInst().size());
        newCompo.setCreationDate(new Date());
        newCompo.setCreatorUserId(pasteDetail.getUserId());
        newCompo.setLanguage(lang);
        String label = this.renameComponentName(newCompo.getLabel(lang), destinationSpace.getAllComponentsInst());
        newCompo.setLabel(label);
        ComponentI18N translation = (ComponentI18N)newCompo.getTranslations().get(lang);
        if (translation != null) {
            translation.setName(label);
        }
        newCompo.removeInheritedProfiles();
        String sComponentId = this.addComponentInst(pasteDetail.getUserId(), newCompo);
        try {
            pasteDetail.setToComponentId(sComponentId);
            ApplicationResourcePasting componentPaste = (ApplicationResourcePasting)ServiceProvider.getService((String)pasteDetail.getFromComponentId(), (String)"ResourcePasting");
            componentPaste.paste(pasteDetail);
        }
        catch (SilverpeasRuntimeException e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return sComponentId;
    }

    private String renameComponentName(String label, List<ComponentInst> listComponents) {
        Object newComponentLabel = label;
        for (ComponentInst componentInst : listComponents) {
            if (!componentInst.getLabel().equals(newComponentLabel)) continue;
            newComponentLabel = "Copie de " + label;
            return this.renameComponentName((String)newComponentLabel, listComponents);
        }
        return newComponentLabel;
    }

    private boolean isParent(int spaceId, Integer anotherSpaceId) throws AdminException {
        if (anotherSpaceId == null || anotherSpaceId < 0) {
            return false;
        }
        List<SpaceInstLight> path = this.treeCache.getSpacePath(anotherSpaceId);
        if (path.isEmpty()) {
            path = this.getPathToSpace(String.valueOf(anotherSpaceId), true);
        }
        for (SpaceInstLight space : path) {
            if (spaceId != space.getLocalId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String copyAndPasteSpace(PasteDetail pasteDetail) throws AdminException, QuotaException {
        boolean pasteAllowed;
        String newSpaceId = null;
        String spaceId = pasteDetail.getFromSpaceId();
        String toSpaceId = pasteDetail.getToSpaceId();
        boolean bl = pasteAllowed = !this.isParent(this.getDriverSpaceId(spaceId), this.getDriverSpaceId(toSpaceId));
        if (pasteAllowed) {
            SpaceInst oldSpace = this.getSpaceInstById(spaceId);
            SpaceInst newSpace = this.createPasteSpace(pasteDetail, oldSpace, toSpaceId);
            newSpace.resetData();
            oldSpace.getAllSpaceProfilesInst().stream().filter(Predicate.not(BaseRightProfile::isInherited)).map(SpaceProfileInst::new).forEach(newSpace::addSpaceProfileInst);
            List<ComponentInst> componentsToCopy = oldSpace.getAllComponentsInst().stream().map(c -> {
                ComponentInst componentInst = new ComponentInst((ComponentInst)c);
                componentInst.setLocalId(c.getLocalId());
                return componentInst;
            }).collect(Collectors.toList());
            newSpaceId = this.addSpaceInst(pasteDetail.getUserId(), newSpace);
            this.copySpaceQuota(oldSpace, newSpace);
            String componentIdAsHomePage = this.pasteComponentsOfSpace(pasteDetail, newSpaceId, newSpace, componentsToCopy);
            List<SpaceInst> subSpacesToCopy = oldSpace.getSubSpaces();
            this.pasteSubspacesOfSpace(pasteDetail, subSpacesToCopy, newSpaceId);
            String newFirstPageExtraParam = null;
            if (StringUtil.isDefined((String)componentIdAsHomePage)) {
                newFirstPageExtraParam = componentIdAsHomePage;
            } else if (newSpace.getFirstPageType() == SpaceInst.FP_TYPE_HTML_PAGE) {
                String oldURL = newSpace.getFirstPageExtraParam();
                newFirstPageExtraParam = oldURL.replaceAll(spaceId, newSpaceId);
            }
            if (StringUtil.isDefined((String)newFirstPageExtraParam)) {
                SpaceInst space = this.getSpaceInstById(newSpaceId);
                space.setFirstPageExtraParam(newFirstPageExtraParam);
                this.updateSpaceInst(space);
            }
        }
        return newSpaceId;
    }

    private void pasteSubspacesOfSpace(PasteDetail pasteDetail, List<SpaceInst> subSpacesToCopy, String newSpaceId) throws AdminException, QuotaException {
        PasteDetail subSpacePasteDetail = new PasteDetail(pasteDetail.getUserId());
        subSpacePasteDetail.setOptions(pasteDetail.getOptions());
        subSpacePasteDetail.setToSpaceId(newSpaceId);
        for (SpaceInst subSpaceInstToCopy : subSpacesToCopy) {
            subSpacePasteDetail.setFromSpaceId(subSpaceInstToCopy.getId());
            this.copyAndPasteSpace(subSpacePasteDetail);
        }
    }

    @Nullable
    private String pasteComponentsOfSpace(PasteDetail pasteDetail, String newSpaceId, SpaceInst newSpace, List<ComponentInst> componentsToCopy) throws AdminException, QuotaException {
        String componentIdAsHomePage = null;
        if (newSpace.getFirstPageType() == SpaceInst.FP_TYPE_COMPONENT_INST) {
            componentIdAsHomePage = newSpace.getFirstPageExtraParam();
        }
        PasteDetail componentPasteDetail = new PasteDetail(pasteDetail.getUserId());
        componentPasteDetail.setOptions(pasteDetail.getOptions());
        componentPasteDetail.setToSpaceId(newSpaceId);
        for (ComponentInst component : componentsToCopy) {
            componentPasteDetail.setFromComponentId(component.getId());
            String componentId = this.copyAndPasteComponent(componentPasteDetail);
            if (componentIdAsHomePage == null || !componentIdAsHomePage.equals(component.getId())) continue;
            componentIdAsHomePage = componentId;
        }
        return componentIdAsHomePage;
    }

    private void copySpaceQuota(SpaceInst oldSpace, SpaceInst newSpace) throws QuotaException {
        Quota componentQuota;
        Quota dataStorageQuota = SpaceServiceProvider.getDataStorageSpaceQuotaService().get(DataStorageSpaceQuotaKey.from(oldSpace));
        if (dataStorageQuota.exists()) {
            SpaceServiceProvider.getDataStorageSpaceQuotaService().initialize(DataStorageSpaceQuotaKey.from(newSpace), dataStorageQuota);
        }
        if ((componentQuota = SpaceServiceProvider.getComponentSpaceQuotaService().get(ComponentSpaceQuotaKey.from(oldSpace))).exists()) {
            SpaceServiceProvider.getComponentSpaceQuotaService().initialize(ComponentSpaceQuotaKey.from(newSpace), componentQuota);
        }
    }

    @Nonnull
    private SpaceInst createPasteSpace(PasteDetail pasteDetail, SpaceInst oldSpace, String toSpaceId) throws AdminException {
        List<String> brotherSpaceIds;
        SpaceInst newSpace = new SpaceInst(oldSpace);
        newSpace.setLocalId(-1);
        if (StringUtil.isDefined((String)toSpaceId)) {
            SpaceInst destinationSpace = this.getSpaceInstById(toSpaceId);
            newSpace.setDomainFatherId(destinationSpace.getId());
            brotherSpaceIds = destinationSpace.getSubSpaces().stream().map(SpaceInst::getId).collect(Collectors.toList());
        } else {
            newSpace.setDomainFatherId("-1");
            brotherSpaceIds = Arrays.asList(this.getAllRootSpaceIds());
        }
        newSpace.setOrderNum(brotherSpaceIds.size());
        newSpace.setCreationDate(new Date());
        newSpace.setCreatorUserId(pasteDetail.getUserId());
        String lang = oldSpace.getLanguage();
        if (StringUtil.isNotDefined((String)lang)) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        newSpace.setLanguage(lang);
        ArrayList<SpaceInstLight> brotherSpaces = new ArrayList<SpaceInstLight>();
        for (String subSpaceId : brotherSpaceIds) {
            brotherSpaces.add(this.getSpaceInstLight(this.getDriverSpaceId(subSpaceId)));
        }
        String name = this.renameSpace(newSpace.getName(newSpace.getLanguage()), brotherSpaces);
        newSpace.setName(name);
        return newSpace;
    }

    private String renameSpace(String label, List<SpaceInstLight> listSpaces) {
        Object newSpaceLabel = label;
        for (SpaceInstLight space : listSpaces) {
            if (!space.getName().equals(newSpaceLabel)) continue;
            newSpaceLabel = "Copie de " + label;
            return this.renameSpace((String)newSpaceLabel, listSpaces);
        }
        return newSpaceLabel;
    }

    private String[] getDirectSpaceProfileIdsOfUser(String sUserId) throws AdminException {
        try {
            return this.spaceProfileManager.getSpaceProfileIdsOfUserType(sUserId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"space profiles of user", (Object)sUserId), e);
        }
    }

    private String[] getDirectSpaceProfileIdsOfGroup(String groupId) throws AdminException {
        try {
            return this.spaceProfileManager.getSpaceProfileIdsOfGroupType(groupId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"space profiles of group", (Object)groupId), e);
        }
    }

    private String[] getDirectComponentProfileIdsOfUser(String sUserId) throws AdminException {
        try {
            return this.profileManager.getProfileIdsOfUser(sUserId, Collections.emptyList());
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"component profiles of user", (Object)sUserId), e);
        }
    }

    private String[] getDirectComponentProfileIdsOfGroup(String groupId) throws AdminException {
        try {
            return this.profileManager.getProfileIdsOfGroup(groupId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"component profiles of group", (Object)groupId), e);
        }
    }

    private String[] getComponentObjectProfileIdsOfUserType(String userId) throws AdminException {
        try {
            return this.profileManager.getAllComponentObjectProfileIdsOfUser(userId, Collections.emptyList());
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"component profiles of user", (Object)userId), e);
        }
    }

    private String[] getComponentObjectProfileIdsOfGroupType(String sGroupId) throws AdminException {
        try {
            return this.profileManager.getAllComponentObjectProfileIdsOfGroup(sGroupId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"component profiles of group", (Object)sGroupId), e);
        }
    }

    private void addTargetProfiles(RightAssignationContext context, String[] sourceSpaceProfileIds, String[] sourceComponentProfileIds, String[] sourceNodeProfileIds) throws AdminException {
        for (String spaceProfileId : sourceSpaceProfileIds) {
            SpaceInstLight spaceInst;
            SpaceProfileInst currentSourceSpaceProfile = this.getSpaceProfileInst(spaceProfileId);
            if (currentSourceSpaceProfile == null || (spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(currentSourceSpaceProfile.getSpaceFatherId()))) == null || spaceInst.isPersonalSpace()) continue;
            this.addInRightProfile(context, currentSourceSpaceProfile);
            this.updateSpaceProfileInst(currentSourceSpaceProfile, context.getAuthor());
        }
        this.addComponentRights(context, sourceComponentProfileIds);
        this.addComponentRights(context, sourceNodeProfileIds);
    }

    private void addComponentRights(RightAssignationContext context, String[] sourceComponentProfileIds) throws AdminException {
        for (String profileId : sourceComponentProfileIds) {
            ProfileInst currentSourceProfile = this.getProfileInst(profileId);
            ComponentInst currentComponent = this.getComponentInst(currentSourceProfile.getComponentFatherId());
            String spaceId = currentComponent.getDomainFatherId();
            SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
            if (currentComponent.getStatus() != null || spaceInst == null || spaceInst.isPersonalSpace()) continue;
            this.addInRightProfile(context, currentSourceProfile);
            this.doUpdateProfileInst(currentSourceProfile, context.getAuthor());
        }
    }

    private void addInRightProfile(RightAssignationContext context, RightProfile rightProfile) {
        if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.USER) {
            rightProfile.addUser(context.getTargetId());
        } else if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.GROUP) {
            rightProfile.addGroup(context.getTargetId());
        }
    }

    private void deleteTargetProfiles(RightAssignationContext context, String[] spaceProfileIdsToDeleteForTarget, String[] componentProfileIdsForTarget) throws AdminException {
        for (String spaceProfileId : spaceProfileIdsToDeleteForTarget) {
            SpaceProfileInst currentTargetSpaceProfile = this.getSpaceProfileInst(spaceProfileId);
            SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(currentTargetSpaceProfile.getSpaceFatherId()));
            if (spaceInst == null || spaceInst.isPersonalSpace()) continue;
            this.removeFromRightProfile(context, currentTargetSpaceProfile);
            this.updateSpaceProfileInst(currentTargetSpaceProfile, context.getAuthor());
        }
        for (String profileId : componentProfileIdsForTarget) {
            ProfileInst currentTargetProfile = this.getProfileInst(profileId);
            ComponentInst currentComponent = this.getComponentInst(currentTargetProfile.getComponentFatherId());
            String spaceId = currentComponent.getDomainFatherId();
            SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
            if (currentComponent.getStatus() != null || spaceInst == null || spaceInst.isPersonalSpace()) continue;
            this.removeFromRightProfile(context, currentTargetProfile);
            this.doUpdateProfileInst(currentTargetProfile, context.getAuthor());
        }
    }

    private void removeFromRightProfile(RightAssignationContext context, RightProfile rightProfile) {
        if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.USER) {
            rightProfile.removeUser(context.getTargetId());
        } else if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.GROUP) {
            rightProfile.removeGroup(context.getTargetId());
        }
    }

    private void assignRightsFromSourceToTarget(RightAssignationContext context) throws AdminException {
        try {
            if (context.areSourceAndTargetEqual()) {
                return;
            }
            String[] spaceProfileIdsToCopy = new String[]{};
            String[] componentProfileIdsToCopy = new String[]{};
            String[] componentObjectProfileIdsToCopy = new String[]{};
            String[] spaceProfileIdsToReplace = new String[]{};
            String[] componentProfileIdsToReplace = new String[]{};
            if (context.getSourceType() == RightAssignationContext.RESOURCE_TYPE.USER) {
                spaceProfileIdsToCopy = this.getDirectSpaceProfileIdsOfUser(context.getSourceId());
                componentProfileIdsToCopy = this.getDirectComponentProfileIdsOfUser(context.getSourceId());
                if (context.isAssignObjectRights()) {
                    componentObjectProfileIdsToCopy = this.getComponentObjectProfileIdsOfUserType(context.getSourceId());
                }
            } else if (context.getSourceType() == RightAssignationContext.RESOURCE_TYPE.GROUP) {
                spaceProfileIdsToCopy = this.getDirectSpaceProfileIdsOfGroup(context.getSourceId());
                componentProfileIdsToCopy = this.getDirectComponentProfileIdsOfGroup(context.getSourceId());
                if (context.isAssignObjectRights()) {
                    componentObjectProfileIdsToCopy = this.getComponentObjectProfileIdsOfGroupType(context.getSourceId());
                }
            }
            if (RightAssignationContext.MODE.REPLACE.equals((Object)context.getMode())) {
                if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.USER) {
                    spaceProfileIdsToReplace = this.getDirectSpaceProfileIdsOfUser(context.getTargetId());
                    componentProfileIdsToReplace = this.getDirectComponentProfileIdsOfUser(context.getTargetId());
                } else if (context.getTargetType() == RightAssignationContext.RESOURCE_TYPE.GROUP) {
                    spaceProfileIdsToReplace = this.getDirectSpaceProfileIdsOfGroup(context.getTargetId());
                    componentProfileIdsToReplace = this.getDirectComponentProfileIdsOfGroup(context.getTargetId());
                }
            }
            this.deleteTargetProfiles(context, spaceProfileIdsToReplace, componentProfileIdsToReplace);
            this.addTargetProfiles(context, spaceProfileIdsToCopy, componentProfileIdsToCopy, componentObjectProfileIdsToCopy);
        }
        catch (Exception e) {
            this.cache.resetCache();
            throw new AdminException("Fail to assign rights", e);
        }
    }

    @Override
    public void assignRightsFromUserToUser(RightAssignationContext.MODE operationMode, String sourceUserId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromUserId(sourceUserId).toUserId(targetUserId);
        this.assignRightsFromSourceToTarget(context);
    }

    @Override
    public void assignRightsFromUserToGroup(RightAssignationContext.MODE operationMode, String sourceUserId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromUserId(sourceUserId).toGroupId(targetGroupId);
        this.assignRightsFromSourceToTarget(context);
    }

    @Override
    public void assignRightsFromGroupToUser(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromGroupId(sourceGroupId).toUserId(targetUserId);
        this.assignRightsFromSourceToTarget(context);
    }

    @Override
    public void assignRightsFromGroupToGroup(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromGroupId(sourceGroupId).toGroupId(targetGroupId);
        this.assignRightsFromSourceToTarget(context);
    }

    private RightAssignationContext initializeRightAssignationContext(RightAssignationContext.MODE operationMode, boolean nodeAssignRights, String authorId) {
        RightAssignationContext context = operationMode == RightAssignationContext.MODE.REPLACE ? RightAssignationContext.replace() : RightAssignationContext.copy();
        if (!nodeAssignRights) {
            context.withoutAssigningComponentObjectRights();
        }
        return context.setAuthor(authorId);
    }

    @Override
    public boolean isDomainManagerUser(String userId, String domainId) {
        UserDetail userDetail = null;
        try {
            userDetail = this.getUserDetail(userId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
        return userDetail != null && userDetail.getDomainId().equals(domainId) && UserAccessLevel.DOMAIN_ADMINISTRATOR.equals((Object)userDetail.getAccessLevel());
    }

    private static class AppRoleMappingManager {
        private final WAComponentRegistry componentRegistry;

        private AppRoleMappingManager(WAComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
        }

        @Nullable
        private String spaceRoleToComponentOne(String spaceRole, String componentName) {
            return this.componentRegistry.getWAComponent(componentName).stream().map(WAComponent::getProfiles).flatMap(l -> l.stream().filter(p -> p.getSpaceProfileMapping().getProfiles().stream().map(org.silverpeas.core.admin.component.model.SpaceProfile::getValue).anyMatch(s -> s.equals(spaceRole))).map(Profile::getName)).findFirst().orElse(null);
        }
    }

    static class CheckoutGroupDescriptor {
        private final Map<String, GroupDetail> allSavedDistantGroups = new HashMap<String, GroupDetail>();
        private final List<GroupDetail> allSilverpeasGroups;
        private GroupDetail[] distantTestedGroups;
        private String superGroupId;

        static CheckoutGroupDescriptor synchronizingDomainFrom(List<GroupDetail> allSilverpeasGroups, GroupDetail[] distantRootGroups) {
            return new CheckoutGroupDescriptor(allSilverpeasGroups, distantRootGroups);
        }

        static CheckoutGroupDescriptor synchronizingOneGroupWithSuperGroupId(String superGroupId) {
            return new CheckoutGroupDescriptor(null, null).setSuperGroupId(superGroupId);
        }

        private CheckoutGroupDescriptor(List<GroupDetail> allSilverpeasGroups, GroupDetail[] distantRootGroups) {
            this.allSilverpeasGroups = allSilverpeasGroups;
            this.setDistantTestedGroups(distantRootGroups);
        }

        void addDistantTestedGroupsInAllSavedDistantGroups() {
            for (GroupDetail testedGroup : this.distantTestedGroups) {
                this.allSavedDistantGroups.put(testedGroup.getSpecificId(), testedGroup);
            }
        }

        public List<GroupDetail> getAllSilverpeasGroups() {
            return this.allSilverpeasGroups;
        }

        public GroupDetail[] getDistantTestedGroups() {
            return this.distantTestedGroups;
        }

        public CheckoutGroupDescriptor setDistantTestedGroups(GroupDetail[] distantTestedGroups) {
            this.distantTestedGroups = distantTestedGroups;
            return this;
        }

        public Map<String, GroupDetail> getAllSavedDistantGroups() {
            return this.allSavedDistantGroups;
        }

        public String getSuperGroupId() {
            return this.superGroupId;
        }

        public CheckoutGroupDescriptor setSuperGroupId(String superGroupId) {
            this.superGroupId = superGroupId;
            return this;
        }
    }

    private static class BackgroundGroupIndexationProcess
    extends AbstractBackgroundProcessRequest {
        private final DomainDriverManager domainDriverManager;
        private final SyncOfGroupsContext context;

        private BackgroundGroupIndexationProcess(DomainDriverManager domainDriverManager, SyncOfGroupsContext context) {
            this.domainDriverManager = domainDriverManager;
            this.context = context;
        }

        protected void process() {
            SilverLogger logger = SilverLogger.getLogger((Object)((Object)this));
            long start = System.currentTimeMillis();
            String totalOfGroups = String.valueOf(this.context.getAddedGroups().size() + this.context.getUpdatedGroups().size() + this.context.getRemovedGroups().size() + this.context.getRestoredGroups().size());
            logger.debug(MessageFormat.format("Starting indexation of {0} groups on domain id {1}...", totalOfGroups, this.context.getDomainId()), new Object[0]);
            Transaction.performInOne(() -> {
                logger.debug(MessageFormat.format("unindexation of {0} removed groups on domain id {1}...", String.valueOf(this.context.getRemovedGroups().size()), this.context.getDomainId()), new Object[0]);
                this.context.getRemovedGroups().keySet().forEach(this.domainDriverManager::unindexGroup);
                logger.debug(MessageFormat.format("indexation of {0} restored groups on domain id {1}...", String.valueOf(this.context.getRestoredGroups().size()), this.context.getDomainId()), new Object[0]);
                this.context.getRestoredGroups().values().forEach(this.domainDriverManager::indexGroup);
                logger.debug(MessageFormat.format("indexation of {0} added groups on domain id {1}...", String.valueOf(this.context.getAddedGroups().size()), this.context.getDomainId()), new Object[0]);
                this.context.getAddedGroups().values().forEach(this.domainDriverManager::indexGroup);
                logger.debug(MessageFormat.format("indexation of {0} updated groups on domain id {1}...", String.valueOf(this.context.getUpdatedGroups().size()), this.context.getDomainId()), new Object[0]);
                this.context.getUpdatedGroups().values().forEach(this.domainDriverManager::indexGroup);
                return null;
            });
            long end = System.currentTimeMillis();
            logger.debug(() -> MessageFormat.format("Ending indexation of {0} groups on domain id {1} in {2}", totalOfGroups, this.context.getDomainId(), DurationFormatUtils.formatDurationHMS((long)(end - start))));
        }
    }

    private static class BackgroundUserIndexationProcess
    extends AbstractBackgroundProcessRequest {
        private final DomainDriverManager domainDriverManager;
        private final SyncOfUsersContext context;

        private BackgroundUserIndexationProcess(DomainDriverManager domainDriverManager, SyncOfUsersContext context) {
            this.domainDriverManager = domainDriverManager;
            this.context = context;
        }

        protected void process() {
            SilverLogger logger = SilverLogger.getLogger((Object)((Object)this));
            long start = System.currentTimeMillis();
            String totalOfUsers = String.valueOf(this.context.getAddedUsers().size() + this.context.getUpdatedUsers().size() + this.context.getRemovedUsers().size() + this.context.getRestoredUsers().size());
            logger.debug(MessageFormat.format("Starting indexation of {0} users on domain id {1}...", totalOfUsers, this.context.getDomainId()), new Object[0]);
            Transaction.performInOne(() -> {
                logger.debug(MessageFormat.format("unindexation of {0} removed users on domain id {1}...", String.valueOf(this.context.getRemovedUsers().size()), this.context.getDomainId()), new Object[0]);
                this.context.getRemovedUsers().keySet().forEach(this.domainDriverManager::unindexUser);
                logger.debug(MessageFormat.format("indexation of {0} restored users on domain id {1}...", String.valueOf(this.context.getRestoredUsers().size()), this.context.getDomainId()), new Object[0]);
                this.context.getRestoredUsers().keySet().forEach(this.domainDriverManager::indexUser);
                logger.debug(MessageFormat.format("indexation of {0} added users on domain id {1}...", String.valueOf(this.context.getAddedUsers().size()), this.context.getDomainId()), new Object[0]);
                this.context.getAddedUsers().keySet().forEach(this.domainDriverManager::indexUser);
                logger.debug(MessageFormat.format("indexation of {0} updated users on domain id {1}...", String.valueOf(this.context.getUpdatedUsers().size()), this.context.getDomainId()), new Object[0]);
                this.context.getUpdatedUsers().keySet().forEach(this.domainDriverManager::indexUser);
                return null;
            });
            long end = System.currentTimeMillis();
            logger.debug(() -> MessageFormat.format("Ending indexation of {0} users on domain id {1} in {2}", totalOfUsers, this.context.getDomainId(), DurationFormatUtils.formatDurationHMS((long)(end - start))));
        }
    }
}

