/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.kernel.util.StringUtil;

public class CommunityMembersGroup
extends GroupDetail {
    public CommunityMembersGroup(String name, String spaceId) {
        this.setName(name);
        this.setRule(null);
        this.setDomainId("-1");
        if (StringUtil.isNotDefined((String)spaceId)) {
            throw new IllegalArgumentException("The identifier of the community space should be set");
        }
        this.setSpaceId(spaceId);
    }

    public CommunityMembersGroup(GroupDetail groupDetail) {
        super(groupDetail);
        if (!groupDetail.isCommunityGroup()) {
            throw new IllegalArgumentException("The specified group isn't a group managed by an application");
        }
        this.setTotalNbUsers(groupDetail.getTotalUsersCount());
        this.setRule(null);
        this.setDomainId("-1");
    }

    @Override
    public boolean isCommunityGroup() {
        return true;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public void setDomainId(String newDomainId) {
        if (!newDomainId.equals("-1")) {
            throw new IllegalArgumentException("An application managed group can belong only to the mixed user domain");
        }
        super.setDomainId(newDomainId);
    }

    @Override
    public void setRule(String rule) {
    }
}

