/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.model;

import org.silverpeas.kernel.bundle.ResourceLocator;

public class DomainProperties {
    private static final String DOMAIN_VISIBILITY_KEY = "domainVisibility";
    private static final String DEFAULT_DOMAIN_ID = "0";
    public static final int DVIS_ALL = 0;
    public static final int DVIS_ONE = 1;
    public static final int DVIS_EACH = 2;

    private DomainProperties() {
    }

    public static boolean isDefaultDomain(String domainId) {
        return DEFAULT_DOMAIN_ID.equals(domainId);
    }

    public static boolean areDomainsVisibleToAll() {
        return DomainProperties.getDomainVisibility() == 0;
    }

    public static boolean areDomainsNonVisibleToOthers() {
        return DomainProperties.getDomainVisibility() == 2;
    }

    public static boolean areDomainsVisibleOnlyToDefaultOne() {
        return DomainProperties.getDomainVisibility() == 1;
    }

    private static int getDomainVisibility() {
        return ResourceLocator.getGeneralSettingBundle().getInteger(DOMAIN_VISIBILITY_KEY, 0);
    }
}

