/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.SilverpeasPersonalComponentInstance;
import org.silverpeas.core.admin.space.PersonalSpaceManager;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class PersonalComponentInstance
implements SilverpeasPersonalComponentInstance {
    private static final long serialVersionUID = -2622307102886492318L;
    private static final String INSTANCE_SUFFIX = "_PCI";
    private static final Pattern INSTANCE_IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z]+)(\\d+)_PCI$");
    private static final int USER_ID_INDEX = 2;
    private static final int COMPONENT_NAME_INDEX = 1;
    private final User user;
    private final transient PersonalComponent personalComponent;

    private PersonalComponentInstance(User user, PersonalComponent personalComponent) {
        this.user = user;
        this.personalComponent = personalComponent;
    }

    public static String getComponentName(String componentInstanceId) {
        String componentName = null;
        Matcher matcher = INSTANCE_IDENTIFIER_PATTERN.matcher(componentInstanceId);
        if (matcher.matches()) {
            componentName = matcher.group(1);
        }
        return componentName;
    }

    public static Optional<PersonalComponentInstance> from(String personalComponentInstanceId) {
        if (StringUtil.isNotDefined((String)personalComponentInstanceId)) {
            String message = SilverpeasExceptionMessages.undefined((String)"personal component instance");
            SilverLogger.getLogger(PersonalComponentInstance.class).error(message, new Object[0]);
            throw new IllegalArgumentException(message);
        }
        PersonalComponentInstance instance = null;
        Matcher matcher = INSTANCE_IDENTIFIER_PATTERN.matcher(personalComponentInstanceId);
        if (matcher.find()) {
            Optional<PersonalComponent> personalComponent = PersonalComponent.getByName(matcher.group(1));
            User user = User.getById((String)matcher.group(2));
            if (personalComponent.isPresent() && user != null) {
                instance = PersonalComponentInstance.from(user, personalComponent.orElse(null));
            }
        }
        return Optional.ofNullable(instance);
    }

    public static PersonalComponentInstance from(User user, PersonalComponent personalComponent) {
        if (user == null || personalComponent == null) {
            if (user == null) {
                SilverLogger.getLogger(PersonalComponentInstance.class).error("user is not define", new Object[0]);
            } else {
                SilverLogger.getLogger(PersonalComponentInstance.class).error("personal component is not defined", new Object[0]);
            }
            throw new IllegalArgumentException("user or/and personal component are not defined");
        }
        return new PersonalComponentInstance(user, personalComponent);
    }

    public User getUser() {
        return this.user;
    }

    public String getId() {
        return this.getName() + this.getUser().getId() + INSTANCE_SUFFIX;
    }

    public String getSpaceId() {
        return PersonalSpaceManager.get().getOrCreatePersonalSpace(this.getUser()).getId();
    }

    public String getName() {
        return this.personalComponent.getName();
    }

    public String getLabel() {
        return this.personalComponent.getLabel(null);
    }

    public String getLabel(String language) {
        return this.personalComponent.getLabel(language);
    }

    public String getDescription() {
        return this.personalComponent.getDescription(null);
    }

    public String getDescription(String language) {
        return this.personalComponent.getDescription(language);
    }

    public int getOrderPosition() {
        return 0;
    }
}

