/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.workflow.api.ProcessInstanceManager;
import org.silverpeas.core.workflow.api.TaskManager;
import org.silverpeas.core.workflow.api.UpdatableProcessInstanceManager;
import org.silverpeas.core.workflow.api.WorkflowEngine;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.event.QuestionEvent;
import org.silverpeas.core.workflow.api.event.ResponseEvent;
import org.silverpeas.core.workflow.api.event.TaskDoneEvent;
import org.silverpeas.core.workflow.api.event.TaskSavedEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowEngineTask;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.instance.HistoryStepImpl;
import org.silverpeas.core.workflow.engine.instance.HistoryStepRepository;
import org.silverpeas.core.workflow.engine.instance.LockingUser;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceRepository;
import org.silverpeas.core.workflow.engine.model.StateImpl;
import org.silverpeas.kernel.util.Mutable;

@Service
@Singleton
public class WorkflowEngineImpl
implements WorkflowEngine {
    @Inject
    private ProcessInstanceRepository repository;
    @Inject
    private HistoryStepRepository historyStepRepository;

    @Override
    public void process(TaskDoneEvent event) throws WorkflowException {
        this.process(event, false);
    }

    @Override
    public void process(TaskDoneEvent event, boolean ignoreControls) throws WorkflowException {
        boolean creationEvent = false;
        ProcessModel model = event.getProcessModel();
        ProcessInstance instance = event.getProcessInstance();
        Action action = model.getAction(event.getActionName());
        if (action != null && "create".equals(action.getKind())) {
            if (!event.isResumingAction()) {
                UpdatableProcessInstanceManager instanceManager = (UpdatableProcessInstanceManager)WorkflowHub.getProcessInstanceManager();
                instance = instanceManager.createProcessInstance(model.getModelId());
                event.setProcessInstance(instance);
            }
            creationEvent = true;
        }
        if (!ignoreControls) {
            this.processControls(event, instance.getInstanceId(), creationEvent);
        }
        WorkflowEngineTask.addTaskDoneRequest(event);
    }

    private void processControls(GenericEvent event, String id, boolean creation) {
        Transaction.performInOne(() -> {
            ProcessInstanceImpl instance = this.repository.getById(id);
            try {
                this.manageLocks(instance);
                if (!creation) {
                    this.manageRights(event, instance);
                    this.checkUserLock(event, instance);
                } else if (event instanceof TaskSavedEvent) {
                    instance.lock(new StateImpl(""), event.getUser());
                }
                this.repository.save((IdentifiableEntity)instance);
            }
            catch (WorkflowException we) {
                throw new WorkflowException("WorkflowEngineImpl.processControls", "workflowEngine.EX_ERR_PROCESS_EVENT", (Exception)((Object)we));
            }
            return null;
        });
    }

    @Override
    public void process(TaskSavedEvent event) throws WorkflowException {
        boolean creationEvent = false;
        ProcessModel model = event.getProcessModel();
        ProcessInstance instance = event.getProcessInstance();
        Action action = model.getAction(event.getActionName());
        if (event.isFirstTimeSaved() && action != null && "create".equals(action.getKind())) {
            UpdatableProcessInstanceManager instanceManager = (UpdatableProcessInstanceManager)WorkflowHub.getProcessInstanceManager();
            instance = instanceManager.createProcessInstance(model.getModelId());
            event.setProcessInstance(instance);
            creationEvent = true;
        }
        this.processControls(event, instance.getInstanceId(), creationEvent);
        WorkflowEngineTask.addTaskSavedRequest(event);
    }

    @Override
    public void process(QuestionEvent event) throws WorkflowException {
        ProcessInstance instance = event.getProcessInstance();
        this.processControls(event, instance.getInstanceId(), false);
        WorkflowEngineTask.addQuestionRequest(event);
    }

    @Override
    public void process(ResponseEvent event) throws WorkflowException {
        ProcessInstance instance = event.getProcessInstance();
        this.processControls(event, instance.getInstanceId(), false);
        WorkflowEngineTask.addResponseRequest(event);
    }

    @Override
    public void reAssignActors(UpdatableProcessInstance instance, Actor[] unAssignedActors, Actor[] assignedActors, User user) throws WorkflowException {
        ProcessInstanceManager instanceManager = WorkflowHub.getProcessInstanceManager();
        String id = instance.getInstanceId();
        Mutable step = Mutable.empty();
        Transaction.performInOne(() -> {
            ProcessInstanceImpl processInstance = this.repository.getById(id);
            UpdatableHistoryStep newStep = (UpdatableHistoryStep)instanceManager.createHistoryStep();
            newStep.setUserId(user.getUserId());
            newStep.setAction("#reAssign#");
            newStep.setActionDate(new Date());
            newStep.setUserRoleName("supervisor");
            newStep.setResolvedState("DummyStateFromReassignment");
            newStep.setActionStatus(ActionStatus.TO_BE_PROCESSED);
            newStep.setProcessInstance(processInstance);
            this.historyStepRepository.save((IdentifiableEntity)((HistoryStepImpl)newStep));
            step.set((Object)newStep);
            return newStep;
        });
        instance.addHistoryStep((HistoryStep)step.get());
        Transaction.performInOne(() -> {
            ProcessInstanceImpl processInstance = this.repository.getById(id);
            UpdatableHistoryStep currentStep = (UpdatableHistoryStep)processInstance.getHistoryStep(((UpdatableHistoryStep)step.get()).getId());
            processInstance.updateHistoryStep(currentStep);
            this.unassignTasksToWorkingUsers(unAssignedActors, processInstance);
            this.removeWorkingUsersFromProcessInstance(unAssignedActors, processInstance);
            this.assignTasksToWorkingUsers(assignedActors, user, processInstance);
            this.addWorkingUsersToProcessInstance(assignedActors, processInstance);
            currentStep.setActionStatus(ActionStatus.AFFECTATIONS_DONE);
            processInstance.updateHistoryStep(currentStep);
            this.repository.save((IdentifiableEntity)processInstance);
            return null;
        });
    }

    private void addWorkingUsersToProcessInstance(Actor[] assignedActors, UpdatableProcessInstance processInstance) throws WorkflowException {
        for (Actor assignedActor : assignedActors) {
            processInstance.addWorkingUser(assignedActor.getUser(), assignedActor.getState(), assignedActor.getUserRoleName());
        }
    }

    private void assignTasksToWorkingUsers(Actor[] assignedActors, User user, UpdatableProcessInstance processInstance) throws WorkflowException {
        Task[] tasks;
        TaskManager taskManager = WorkflowHub.getTaskManager();
        for (Task task : tasks = taskManager.createTasks(assignedActors, processInstance)) {
            taskManager.assignTask(task, user);
        }
    }

    private void removeWorkingUsersFromProcessInstance(Actor[] unAssignedActors, UpdatableProcessInstance processInstance) throws WorkflowException {
        for (Actor unAssignedActor : unAssignedActors) {
            processInstance.removeWorkingUser(unAssignedActor.getUser(), unAssignedActor.getState(), unAssignedActor.getUserRoleName());
        }
    }

    private void unassignTasksToWorkingUsers(Actor[] unAssignedActors, UpdatableProcessInstance processInstance) throws WorkflowException {
        Task[] tasks;
        TaskManager taskManager = WorkflowHub.getTaskManager();
        for (Task task : tasks = taskManager.createTasks(unAssignedActors, processInstance)) {
            taskManager.unAssignTask(task);
        }
    }

    private void manageLocks(UpdatableProcessInstance instance) throws WorkflowException {
        if (instance == null) {
            throw new WorkflowException("WorkflowEngineImpl.manageLocks", "EX_ERR_EVENT_WITHOUT_INSTANCE");
        }
        instance.lock();
    }

    private void manageRights(GenericEvent event, UpdatableProcessInstance instance) throws WorkflowException {
        boolean validUser = false;
        State resolvedState = event.getResolvedState();
        if (resolvedState == null) {
            resolvedState = new StateImpl("");
        }
        User actor = event.getUser();
        Actor[] wkUsers = instance.getWorkingUsers(resolvedState.getName(), event.getUserRoleName());
        if (wkUsers != null) {
            for (Actor wkUser : wkUsers) {
                if (!wkUser.getUser().equals(actor)) continue;
                validUser = true;
            }
        }
        if (!validUser) {
            throw new WorkflowException("WorkflowEngineImpl.manageRights", "EX_ERR_FORBIDDEN_ACTION");
        }
    }

    private void checkUserLock(GenericEvent event, UpdatableProcessInstance instance) throws WorkflowException {
        State resolvedState = event.getResolvedState();
        if (resolvedState == null) {
            resolvedState = new StateImpl("");
        }
        LockingUser lockingUser = instance.getLockingUser(resolvedState.getName());
        User actor = event.getUser();
        if (lockingUser == null) {
            throw new WorkflowException("WorkflowEngineImpl.process(TaskDoneEvent)", "EX_ERR_NO_LOCK_BEFORE_ACTION");
        }
        User user = WorkflowHub.getUserManager().getUser(lockingUser.getUserId());
        if (!user.equals(actor)) {
            throw new WorkflowException("WorkflowEngineImpl.process(TaskDoneEvent)", "EX_ERR_INSTANCE_LOCKED_BY_ANOTHER_USER");
        }
    }
}

